/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PrivilegesHandler
extends AbstractRegexEntryHandler {
    private static final String PRIVILEGE = "privilege";
    private static final String NAME = "name";
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public PrivilegesHandler() {
        super("META-INF/vault/privileges\\.xml");
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        SAXParser saxParser = this.saxParserFactory.newSAXParser();
        AclManager aclManager = converter.getAclManager();
        PrivilegeHandler handler = new PrivilegeHandler(aclManager);
        saxParser.parse(archive.openInputStream(entry), (DefaultHandler)handler);
    }

    private static final class PrivilegeHandler
    extends DefaultHandler {
        private final AclManager aclManager;

        public PrivilegeHandler(AclManager aclManager) {
            this.aclManager = aclManager;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String privilege;
            if (PrivilegesHandler.PRIVILEGE.equals(qName) && (privilege = attributes.getValue(PrivilegesHandler.NAME)) != null && !privilege.isEmpty()) {
                this.aclManager.addPrivilege(privilege);
            }
        }
    }
}

