/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RepoPath
implements Comparable<RepoPath> {
    private final List<String> path;

    public RepoPath(String path) {
        path = path.trim();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = Arrays.asList(path.split("/"));
    }

    public RepoPath(List<String> list) {
        this.path = new ArrayList<String>(list);
    }

    @Override
    public int compareTo(RepoPath o) {
        String me = this.toString();
        String them = o.toString();
        return me.compareTo(them);
    }

    public RepoPath getParent() {
        if (this.path.isEmpty()) {
            return null;
        }
        ArrayList<String> parentPath = new ArrayList<String>(this.path.subList(0, this.path.size() - 1));
        if (parentPath.isEmpty()) {
            return null;
        }
        return new RepoPath(parentPath);
    }

    public int getSegmentCount() {
        return this.path.size();
    }

    public boolean startsWith(RepoPath otherPath) {
        if (otherPath == null) {
            return true;
        }
        if (this.path.size() < otherPath.path.size()) {
            return false;
        }
        ArrayList<String> l = new ArrayList<String>(this.path.subList(0, otherPath.path.size()));
        return l.equals(otherPath.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepoPath other = (RepoPath)obj;
        return Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "/" + this.path.stream().collect(Collectors.joining("/"));
    }
}

