/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyParser;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;

abstract class AbstractPolicyEntryHandler
extends AbstractRegexEntryHandler {
    private final SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();

    AbstractPolicyEntryHandler(@NotNull String regex) {
        super(regex);
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException {
        block20: {
            Matcher matcher = this.getPattern().matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
            }
            String resourcePath = matcher.group(1);
            try {
                boolean hasRejectedNodes;
                TransformerHandler handler = this.saxTransformerFactory.newTransformerHandler();
                handler.getTransformer().setOutputProperty("indent", "yes");
                handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                handler.getTransformer().setOutputProperty("encoding", "UTF-8");
                StringWriter stringWriter = new StringWriter();
                handler.setResult(new StreamResult(stringWriter));
                AbstractPolicyParser policyParser = this.createPolicyParser(new RepoPath(PlatformNameFormat.getRepositoryPath((String)resourcePath)), converter.getAclManager(), handler);
                try (InputStream input = archive.openInputStream(entry);){
                    hasRejectedNodes = (Boolean)policyParser.parse(input);
                }
                if (!hasRejectedNodes) break block20;
                try (StringReader reader = new StringReader(stringWriter.toString());
                     OutputStreamWriter writer = new OutputStreamWriter(converter.getMainPackageAssembler().createEntry(path));){
                    IOUtils.copy((Reader)reader, (Writer)writer);
                }
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    @NotNull
    abstract AbstractPolicyParser createPolicyParser(@NotNull RepoPath var1, @NotNull AclManager var2, @NotNull TransformerHandler var3);
}

