/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.XMLNodeToXMLFileWriter;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.xmlbuffer.XMLNode;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultContentXMLContentCreator
implements ContentCreator {
    private static final String ACL_NOT_SUPPORTED_MSG = "Sling Initial Content - ACL statements are not supported yet . SLING issue: https://issues.apache.org/jira/browse/SLING-11060";
    private final String repositoryPath;
    private final OutputStream targetOutputStream;
    private final VaultPackageAssembler packageAssembler;
    private final LinkedList<XMLNode> parentNodePathStack = new LinkedList();
    private final JcrNamespaceRegistry namespaceRegistry;
    private final boolean isFileDescriptorEntry;
    private boolean isFirstElement = true;
    private boolean finished = false;
    private boolean xmlProcessed = false;
    private String primaryNodeName;
    private XMLNode currentNode;

    VaultContentXMLContentCreator(@NotNull String repositoryPath, @NotNull OutputStream targetOutputStream, @NotNull JcrNamespaceRegistry namespaceRegistry, @NotNull VaultPackageAssembler packageAssembler, boolean isFileDescriptorEntry) {
        this.repositoryPath = repositoryPath;
        this.targetOutputStream = targetOutputStream;
        this.packageAssembler = packageAssembler;
        this.namespaceRegistry = namespaceRegistry;
        this.isFileDescriptorEntry = isFileDescriptorEntry;
    }

    void setIsXmlProcessed() {
        this.xmlProcessed = true;
    }

    public void createNode(String name, String primaryNodeType, String[] mixinNodeTypes) throws RepositoryException {
        String basePath;
        String jcrNodeName;
        String elementName;
        if (this.xmlProcessed && this.isFirstElement) {
            elementName = "jcr:root";
            this.primaryNodeName = name;
            jcrNodeName = name;
            this.isFirstElement = false;
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            elementName = VaultContentXMLContentCreator.getValidElementName(name);
            jcrNodeName = name;
        } else {
            elementName = "jcr:root";
            jcrNodeName = null;
        }
        if (this.parentNodePathStack.isEmpty()) {
            basePath = this.repositoryPath;
        } else {
            StringBuilder basePathBuilder = new StringBuilder(this.repositoryPath);
            Iterator<XMLNode> xmlNodeIterator = this.parentNodePathStack.descendingIterator();
            while (xmlNodeIterator.hasNext()) {
                XMLNode parent = xmlNodeIterator.next();
                String parentJcrNodeName = parent.getJcrNodeName();
                if (!StringUtils.isNotBlank((CharSequence)parentJcrNodeName)) continue;
                basePathBuilder.append("/");
                basePathBuilder.append(parentJcrNodeName);
            }
            basePath = basePathBuilder.toString();
        }
        String defaultNtType = this.isFileDescriptorEntry ? "nt:file" : "nt:unstructured";
        String toUsePrimaryNodeType = StringUtils.isNotBlank((CharSequence)primaryNodeType) ? primaryNodeType : defaultNtType;
        XMLNode intermediateNode = new XMLNode(this.packageAssembler, basePath, elementName, jcrNodeName, toUsePrimaryNodeType, mixinNodeTypes);
        if (this.currentNode != null) {
            this.currentNode.addChildNode(elementName, intermediateNode);
        }
        this.currentNode = intermediateNode;
        if (ArrayUtils.isNotEmpty((Object[])mixinNodeTypes)) {
            this.currentNode.addProperty("jcr:mixinTypes", "[" + String.join((CharSequence)",", mixinNodeTypes) + "]");
        }
        this.parentNodePathStack.push(this.currentNode);
    }

    @NotNull
    private static String getValidElementName(@NotNull String name) {
        if (StringUtils.isNumeric((CharSequence)name.substring(0, 1))) {
            return "_" + name;
        }
        return name;
    }

    @Nullable
    public String getPrimaryNodeName() {
        return this.primaryNodeName;
    }

    public void finishNode() {
        if (this.parentNodePathStack.size() > 1) {
            this.parentNodePathStack.pop();
        }
        this.currentNode = this.parentNodePathStack.peek();
    }

    public void finish() throws RepositoryException {
        if (this.finished) {
            return;
        }
        try {
            XMLNodeToXMLFileWriter writer = new XMLNodeToXMLFileWriter(this.currentNode, this.targetOutputStream, this.namespaceRegistry);
            writer.write();
            this.finished = true;
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void createProperty(String name, int propertyType, String value) throws RepositoryException {
        this.currentNode.addProperty(name, propertyType, value);
    }

    public void createProperty(String name, int propertyType, String[] values) throws RepositoryException {
        this.currentNode.addProperty(name, propertyType, values);
    }

    public void createProperty(String name, Object value) throws RepositoryException {
        this.currentNode.addProperty(name, value);
    }

    public void createProperty(String name, Object[] values) throws RepositoryException {
        this.currentNode.addProperty(name, values);
    }

    public void createFileAndResourceNode(String name, InputStream data, String mimeType, long lastModified) throws RepositoryException {
        this.createNode(name, "nt:file", null);
        this.createNode("jcr:content", "nt:resource", null);
        if (lastModified <= 0L) {
            lastModified = System.currentTimeMillis();
        }
        this.createProperty("jcr:mimeType", mimeType);
        this.createProperty("jcr:lastModified", lastModified);
        this.createProperty("jcr:data", data);
    }

    public boolean switchCurrentNode(String subPath, String newNodeType) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createUser(String name, String password, Map<String, Object> extraProperties) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createGroup(String name, String[] members, Map<String, Object> extraProperties) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createAce(String principal, String[] grantedPrivileges, String[] deniedPrivileges, String order) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createAce(String principalId, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removedRestrictionNames) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }
}

