/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.xmlbuffer.XMLNode;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.jetbrains.annotations.NotNull;

class XMLNodeToXMLFileWriter {
    private final XMLNode parentNode;
    private final XMLEventWriter eventWriter;
    private final JcrNamespaceRegistry namespaceRegistry;
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();

    XMLNodeToXMLFileWriter(@NotNull XMLNode parentNode, @NotNull OutputStream targetOutputStream, @NotNull JcrNamespaceRegistry namespaceRegistry) throws XMLStreamException {
        this.parentNode = parentNode;
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(targetOutputStream, StandardCharsets.UTF_8.name());
        this.eventWriter = new IndentingXMLEventWriter(writer);
        this.namespaceRegistry = namespaceRegistry;
        this.eventWriter.setNamespaceContext(this.namespaceRegistry);
    }

    void write() throws XMLStreamException, RepositoryException {
        this.eventWriter.add(this.eventFactory.createStartDocument());
        this.writeNode(this.parentNode, true);
        this.eventWriter.add(this.eventFactory.createEndDocument());
    }

    void writeNode(@NotNull XMLNode xmlNode, boolean isFirstElement) throws RepositoryException, XMLStreamException {
        this.eventWriter.add(this.eventFactory.createStartElement("", "", xmlNode.getXmlElementName()));
        if (isFirstElement) {
            for (String prefix : this.namespaceRegistry.getPrefixes()) {
                this.eventWriter.add(this.eventFactory.createNamespace(prefix, this.namespaceRegistry.getURI(prefix)));
            }
        }
        String primaryNodeType = xmlNode.getPrimaryNodeType();
        Object[] mixinNodeTypes = xmlNode.getMixinNodeTypes();
        this.eventWriter.add(this.eventFactory.createAttribute("jcr:primaryType", StringUtils.isNotBlank((CharSequence)primaryNodeType) ? primaryNodeType : "nt:unstructured"));
        if (ArrayUtils.isNotEmpty((Object[])mixinNodeTypes)) {
            this.eventWriter.add(this.eventFactory.createAttribute("jcr:mixinTypes", "[" + String.join((CharSequence)",", (CharSequence[])mixinNodeTypes) + "]"));
        }
        for (Map.Entry<String, String> entry : xmlNode.getVltXmlParsedProperties().entrySet()) {
            if (entry.getKey().equals("jcr:primaryType") || entry.getKey().equals("jcr:mixinTypes")) continue;
            this.eventWriter.add(this.eventFactory.createAttribute(entry.getKey(), entry.getValue()));
        }
        for (XMLNode node : xmlNode.getChildren().values()) {
            this.writeNode(node, false);
        }
        this.eventWriter.add(this.eventFactory.createEndElement("", "", xmlNode.getXmlElementName()));
    }
}

