/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultPackageUtils {
    private static final String DEPENDENCIES_DELIMITER = ",";

    private VaultPackageUtils() {
    }

    @NotNull
    public static PackageType detectPackageType(@NotNull VaultPackage vaultPackage) {
        PackageType packageType = vaultPackage.getPackageType();
        if (packageType != null) {
            return packageType;
        }
        WorkspaceFilter filter = vaultPackage.getMetaInf().getFilter();
        if (filter != null) {
            for (PathFilterSet p : filter.getFilterSets()) {
                if ("cleanup".equals(p.getType())) continue;
                String root = p.getRoot();
                @NotNull PackageType newPackageType = VaultPackageUtils.detectPackageType(root);
                if (packageType != null && packageType != newPackageType) {
                    return PackageType.MIXED;
                }
                packageType = newPackageType;
            }
        }
        return packageType != null ? packageType : PackageType.MIXED;
    }

    @NotNull
    public static PackageType detectPackageType(String path) {
        if ("/apps".equals(path) || path.startsWith("/apps/") || "/libs".equals(path) || path.startsWith("/libs/")) {
            return PackageType.APPLICATION;
        }
        return PackageType.CONTENT;
    }

    @Nullable
    static PackageType recalculatePackageType(PackageType sourcePackageType, @NotNull File outputDirectory) {
        if (sourcePackageType != null && sourcePackageType != PackageType.MIXED) {
            return null;
        }
        AtomicBoolean foundMutableFiles = new AtomicBoolean();
        AtomicBoolean foundImmutableFiles = new AtomicBoolean();
        VaultPackageUtils.forEachDirectoryBelowJcrRoot(outputDirectory, (child, base) -> {
            if (child.getName().equals("apps") || child.getName().equals("libs")) {
                foundImmutableFiles.weakCompareAndSet(false, true);
            } else {
                foundMutableFiles.weakCompareAndSet(false, true);
            }
        });
        if (foundImmutableFiles.get() && !foundMutableFiles.get()) {
            return PackageType.APPLICATION;
        }
        if (!foundImmutableFiles.get() && foundMutableFiles.get()) {
            return PackageType.CONTENT;
        }
        return PackageType.MIXED;
    }

    static void forEachDirectoryBelowJcrRoot(File outputDirectory, BiConsumer<File, File> consumer) {
        File jcrRootDir = new File(outputDirectory, "jcr_root");
        if (jcrRootDir.exists() && jcrRootDir.isDirectory()) {
            for (File child : jcrRootDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
                consumer.accept(child, jcrRootDir);
            }
        }
    }

    @NotNull
    public static Set<Dependency> getDependencies(@NotNull VaultPackage vaultPackage) {
        Dependency[] originalDepenencies = vaultPackage.getDependencies();
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        if (originalDepenencies != null && originalDepenencies.length > 0) {
            dependencies.addAll(Arrays.asList(originalDepenencies));
        }
        return dependencies;
    }

    public static void setDependencies(@Nullable Set<Dependency> dependencies, @NotNull Properties properties) {
        if (dependencies == null || dependencies.isEmpty()) {
            properties.remove("dependencies");
            return;
        }
        String dependenciesString = dependencies.stream().map(d -> d.toString()).collect(Collectors.joining(DEPENDENCIES_DELIMITER));
        properties.setProperty("dependencies", dependenciesString);
    }
}

