/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.felix.cm.json.Configurations;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;

public abstract class ConfigurableEntity
extends DescribableEntity {
    private final Map<String, PropertyDescription> properties = Configurations.newConfiguration();

    @Override
    public void clear() {
        super.clear();
        this.properties.clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            JsonValue val = this.getAttributes().remove("properties");
            if (val != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    PropertyDescription prop = new PropertyDescription();
                    prop.fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    if (this.getPropertyDescriptions().put((String)innerEntry.getKey(), prop) == null) continue;
                    throw new IOException("Duplicate key for property description (keys are case-insensitive) : ".concat((String)innerEntry.getKey()));
                }
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Map<String, PropertyDescription> getPropertyDescriptions() {
        return this.properties;
    }

    @Override
    JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getPropertyDescriptions().isEmpty()) {
            JsonObjectBuilder propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, PropertyDescription> entry : this.getPropertyDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("properties", propBuilder);
        }
        return objBuilder;
    }
}

