/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sling.feature.extension.apiregions.api.config.Option;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyType;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;

public class PropertyValidator {
    private static final List<String> PLACEHOLDERS = Arrays.asList("$[env:", "$[secret:", "$[prop:");

    public PropertyValidationResult validate(Object value, PropertyDescription desc) {
        PropertyValidationResult result = new PropertyValidationResult();
        if (value == null) {
            if (desc.isRequired()) {
                result.getErrors().add("No value provided");
            }
        } else {
            ArrayList<Object> values;
            if (value.getClass().isArray()) {
                values = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    values.add(Array.get(value, i));
                }
            } else if (value instanceof Collection) {
                values = new ArrayList();
                Collection c = (Collection)value;
                for (Object o : c) {
                    values.add(o);
                }
            } else {
                values = null;
                this.validateValue(desc, value, result);
            }
            if (values != null) {
                for (Object e : values) {
                    this.validateValue(desc, e, result);
                }
                this.validateList(desc, values, result.getErrors());
            }
            if (desc.getDeprecated() != null) {
                result.getWarnings().add(desc.getDeprecated());
            }
        }
        return result;
    }

    void validateList(PropertyDescription prop, List<Object> values, List<String> messages) {
        boolean found;
        if (prop.getCardinality() > 0 && values.size() > prop.getCardinality()) {
            messages.add("Array/collection contains too many elements, only " + prop.getCardinality() + " allowed");
        }
        if (prop.getIncludes() != null) {
            for (String inc : prop.getIncludes()) {
                found = false;
                for (Object val : values) {
                    if (!inc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                messages.add("Required included value " + inc + " not found");
            }
        }
        if (prop.getExcludes() != null) {
            for (String exc : prop.getExcludes()) {
                found = false;
                for (Object val : values) {
                    if (!exc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                messages.add("Required excluded value " + exc + " found");
            }
        }
    }

    void validateValue(PropertyDescription desc, Object value, PropertyValidationResult result) {
        List<String> messages = result.getErrors();
        if (value != null) {
            boolean hasPlaceholder = false;
            if (value instanceof String) {
                String strVal = (String)value;
                for (String p : PLACEHOLDERS) {
                    if (!strVal.contains(p)) continue;
                    hasPlaceholder = true;
                    break;
                }
            }
            if (!hasPlaceholder) {
                switch (desc.getType()) {
                    case BOOLEAN: {
                        this.validateBoolean(desc, value, messages);
                        break;
                    }
                    case BYTE: {
                        this.validateByte(desc, value, messages);
                        break;
                    }
                    case CHARACTER: {
                        this.validateCharacter(desc, value, messages);
                        break;
                    }
                    case DOUBLE: {
                        this.validateDouble(desc, value, messages);
                        break;
                    }
                    case FLOAT: {
                        this.validateFloat(desc, value, messages);
                        break;
                    }
                    case INTEGER: {
                        this.validateInteger(desc, value, messages);
                        break;
                    }
                    case LONG: {
                        this.validateLong(desc, value, messages);
                        break;
                    }
                    case SHORT: {
                        this.validateShort(desc, value, messages);
                        break;
                    }
                    case STRING: {
                        this.validateRequired(desc, value, messages);
                        break;
                    }
                    case EMAIL: {
                        this.validateEmail(desc, value, messages);
                        break;
                    }
                    case PASSWORD: {
                        this.validatePassword(desc, value, messages, false);
                        break;
                    }
                    case URL: {
                        this.validateURL(desc, value, messages);
                        break;
                    }
                    case PATH: {
                        this.validatePath(desc, value, messages);
                        break;
                    }
                    default: {
                        messages.add("Unable to validate value - unknown property type : " + (Object)((Object)desc.getType()));
                    }
                }
                this.validateRegex(desc, value, messages);
                this.validateOptions(desc, value, messages);
            } else if (desc.getType() == PropertyType.PASSWORD) {
                this.validatePassword(desc, value, messages, true);
            } else if (desc.getType() == PropertyType.STRING) {
                if (desc.getRegex() != null || desc.getOptions() != null || desc.isRequired()) {
                    result.markSkipped();
                }
            } else {
                result.markSkipped();
            }
        } else {
            messages.add("Null value provided for validation");
        }
    }

    void validateRequired(PropertyDescription prop, Object value, List<String> messages) {
        String val;
        if (prop.isRequired() && (val = value.toString()).isEmpty()) {
            messages.add("Value is required");
        }
    }

    void validateBoolean(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Boolean)) {
            if (value instanceof String) {
                String v = (String)value;
                if (!v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("false")) {
                    messages.add("Boolean value must either be true or false, but not " + value);
                }
            } else {
                messages.add("Boolean value must either be of type Boolean or String : " + value);
            }
        }
    }

    void validateByte(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Byte)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Byte.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Byte : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, ((Number)value).byteValue(), messages);
            } else {
                messages.add("Byte value must either be of type Byte or String : " + value);
            }
        } else {
            this.validateRange(prop, (Byte)value, messages);
        }
    }

    void validateShort(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Short)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Short.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Short : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, ((Number)value).shortValue(), messages);
            } else {
                messages.add("Short value must either be of type Short or String : " + value);
            }
        } else {
            this.validateRange(prop, (Short)value, messages);
        }
    }

    void validateInteger(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Integer)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Integer.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Integer : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, ((Number)value).intValue(), messages);
            } else {
                messages.add("Integer value must either be of type Integer or String : " + value);
            }
        } else {
            this.validateRange(prop, (Integer)value, messages);
        }
    }

    void validateLong(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Long)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Long.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Long : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, ((Number)value).longValue(), messages);
            } else {
                messages.add("Long value must either be of type Long or String : " + value);
            }
        } else {
            this.validateRange(prop, (Long)value, messages);
        }
    }

    void validateFloat(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Float)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Float.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Float : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, Float.valueOf(((Number)value).floatValue()), messages);
            } else {
                messages.add("Float value must either be of type Float or String : " + value);
            }
        } else {
            this.validateRange(prop, (Float)value, messages);
        }
    }

    void validateDouble(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Double)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(prop, Double.valueOf(v), messages);
                }
                catch (NumberFormatException nfe) {
                    messages.add("Value is not a valid Double : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(prop, ((Number)value).doubleValue(), messages);
            } else {
                messages.add("Double value must either be of type Double or String : " + value);
            }
        } else {
            this.validateRange(prop, (Double)value, messages);
        }
    }

    void validateCharacter(PropertyDescription prop, Object value, List<String> messages) {
        if (!(value instanceof Character)) {
            if (value instanceof String) {
                String v = (String)value;
                if (v.length() > 1) {
                    messages.add("Value is not a valid Character : " + value);
                }
            } else {
                messages.add("Character value must either be of type Character or String : " + value);
            }
        }
    }

    void validateURL(PropertyDescription prop, Object value, List<String> messages) {
        String val = value.toString();
        try {
            new URL(val);
        }
        catch (MalformedURLException mue) {
            messages.add("Value is not a valid URL : " + val);
        }
    }

    void validateEmail(PropertyDescription prop, Object value, List<String> messages) {
        String val = value.toString();
        if (!val.contains("@")) {
            messages.add("Not a valid email address " + val);
        }
    }

    void validatePassword(PropertyDescription desc, Object value, List<String> messages, boolean hasPlaceholder) {
        if (!hasPlaceholder) {
            messages.add("Value for a password must use a placeholder");
        }
    }

    void validatePath(PropertyDescription prop, Object value, List<String> messages) {
        String val = value.toString();
        if (!val.startsWith("/")) {
            messages.add("Not a valid path " + val);
        }
    }

    void validateRange(PropertyDescription prop, Number value, List<String> messages) {
        if (prop.getRange() != null) {
            if (prop.getRange().getMin() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double min = prop.getRange().getMin().doubleValue();
                    if (value.doubleValue() < min) {
                        messages.add("Value " + value + " is too low; should not be lower than " + prop.getRange().getMin());
                    }
                } else {
                    long min = prop.getRange().getMin().longValue();
                    if (value.longValue() < min) {
                        messages.add("Value " + value + " is too low; should not be lower than " + prop.getRange().getMin());
                    }
                }
            }
            if (prop.getRange().getMax() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double max = prop.getRange().getMax().doubleValue();
                    if (value.doubleValue() > max) {
                        messages.add("Value " + value + " is too high; should not be higher than " + prop.getRange().getMax());
                    }
                } else {
                    long max = prop.getRange().getMax().longValue();
                    if (value.longValue() > max) {
                        messages.add("Value " + value + " is too high; should not be higher than " + prop.getRange().getMax());
                    }
                }
            }
        }
    }

    void validateRegex(PropertyDescription prop, Object value, List<String> messages) {
        if (prop.getRegexPattern() != null && !prop.getRegexPattern().matcher(value.toString()).matches()) {
            messages.add("Value " + value + " does not match regex " + prop.getRegex());
        }
    }

    void validateOptions(PropertyDescription prop, Object value, List<String> messages) {
        if (prop.getOptions() != null) {
            boolean found = false;
            for (Option opt : prop.getOptions()) {
                if (!opt.getValue().equals(value.toString())) continue;
                found = true;
            }
            if (!found) {
                messages.add("Value " + value + " does not match provided options");
            }
        }
    }
}

