/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.io.IOUtils;
import org.osgi.framework.Version;

public class LauncherProperties {
    private static final String REGION_ORDER = "__region.order__";

    public static Properties getBundleIDtoBSNandVersionMap(Feature app, ArtifactProvider artifactProvider) {
        HashMap<ArtifactId, String> map = new HashMap<ArtifactId, String>();
        for (Artifact bundle : app.getBundles()) {
            map.computeIfAbsent(bundle.getId(), id -> {
                try (JarFile jarFile = IOUtils.getJarFileFromURL((URL)artifactProvider.provide(id), (boolean)true, null);){
                    Attributes manifest = jarFile.getManifest().getMainAttributes();
                    String bsn = manifest.getValue("Bundle-SymbolicName");
                    if (bsn != null && !bsn.trim().isEmpty()) {
                        String string = bsn.trim() + "~" + Version.parseVersion((String)manifest.getValue("Bundle-Version"));
                        return string;
                    }
                    String string = null;
                    return string;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        Properties result = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            result.setProperty(((ArtifactId)entry.getKey()).toMvnId(), (String)entry.getValue());
        }
        return result;
    }

    public static Properties getBundleIDtoFeaturesMap(Feature app) {
        HashMap<ArtifactId, Set> map = new HashMap<ArtifactId, Set>();
        for (Artifact bundle : app.getBundles()) {
            map.compute(bundle.getId(), (id, features) -> {
                if (features == null) {
                    features = new HashSet<ArtifactId>();
                }
                features.addAll(Arrays.asList(bundle.getFeatureOrigins(app.getId())));
                return features;
            });
        }
        Properties result = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            result.setProperty(((ArtifactId)entry.getKey()).toMvnId(), ((Set)entry.getValue()).stream().map(ArtifactId::toMvnId).collect(Collectors.joining(",")));
        }
        return result;
    }

    public static Properties getFeatureIDtoRegionsMap(ApiRegions regions) {
        HashMap<ArtifactId, List> map = new HashMap<ArtifactId, List>();
        for (ApiRegion region : regions.listRegions()) {
            for (ArtifactId featureId : region.getFeatureOrigins()) {
                map.compute(featureId, (id, regionNames) -> {
                    if (regionNames == null) {
                        regionNames = new LinkedList<String>();
                    }
                    regionNames.add(region.getName());
                    int insertionIndex = regionNames.size() - 1;
                    for (ApiRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
                        String parentName = parent.getName();
                        if (regionNames.contains(parentName)) continue;
                        regionNames.add(insertionIndex, parentName);
                    }
                    return regionNames;
                });
            }
        }
        Properties result = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            result.setProperty(((ArtifactId)entry.getKey()).toMvnId(), String.join((CharSequence)",", (Iterable)entry.getValue()));
        }
        result.put(REGION_ORDER, regions.listRegions().stream().map(ApiRegion::getName).collect(Collectors.joining(",")));
        return result;
    }

    public static Properties getRegionNametoPackagesMap(ApiRegions regions) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (ApiRegion region : regions.listRegions()) {
            for (ApiExport export : region.listExports()) {
                map.compute(region.getName(), (name, exports) -> {
                    if (exports == null) {
                        exports = new HashSet<String>();
                    }
                    exports.add(export.getName());
                    return exports;
                });
            }
        }
        Properties result = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            result.setProperty((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
        }
        return result;
    }

    public static void save(Properties properties, File file) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            properties.store(output, "");
        }
    }
}

