/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.Deprecation;
import org.apache.sling.feature.extension.apiregions.api.DeprecationInfo;
import org.apache.sling.feature.extension.apiregions.api.DeprecationValidationMode;

public class ApiExport
implements Comparable<ApiExport> {
    private static final String DEPRECATED_KEY = "deprecated";
    private static final String MSG_KEY = "msg";
    private static final String SINCE_KEY = "since";
    private static final String FOR_REMOVAL_KEY = "for-removal";
    private static final String MODE_KEY = "mode";
    private static final String MEMBERS_KEY = "members";
    private static final String NAME_KEY = "name";
    private static final String TOGGLE_KEY = "toggle";
    private static final String PREVIOUS_KEY = "previous";
    private static final String PREVIOUS_ARTIFACT_ID_KEY = "previous-artifact-id";
    private static final String PREVIOUS_PACKAGE_VERSION_KEY = "previous-package-version";
    private final String name;
    private String toggle;
    private ArtifactId previousArtifactId;
    @Deprecated
    private String previousPackageVersion;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Deprecation deprecation = new Deprecation();

    public ApiExport(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getToggle() {
        return this.toggle;
    }

    public void setToggle(String toggle) {
        this.toggle = toggle;
    }

    @Deprecated
    public String getPreviousPackageVersion() {
        return this.previousPackageVersion;
    }

    @Deprecated
    public void setPreviousPackageVersion(String version) {
        this.previousPackageVersion = version;
    }

    public ArtifactId getPreviousArtifactId() {
        return this.previousArtifactId;
    }

    public void setPreviousArtifactId(ArtifactId previous) {
        this.previousArtifactId = previous;
    }

    @Deprecated
    public ArtifactId getPrevious() {
        return this.getPreviousArtifactId();
    }

    @Deprecated
    public void setPrevious(ArtifactId previous) {
        this.setPreviousArtifactId(previous);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    void parseDeprecation(JsonValue dValue) throws IOException {
        if (dValue.getValueType() == JsonValue.ValueType.STRING) {
            DeprecationInfo info = new DeprecationInfo(((JsonString)dValue).getString());
            this.getDeprecation().setPackageInfo(info);
        } else if (dValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject depObj = dValue.asJsonObject();
            if (depObj.containsKey((Object)MSG_KEY) && depObj.containsKey((Object)MEMBERS_KEY)) {
                throw new IOException("Export " + this.getName() + " has wrong info in " + DEPRECATED_KEY);
            }
            if (!depObj.containsKey((Object)MSG_KEY) && !depObj.containsKey((Object)MEMBERS_KEY)) {
                throw new IOException("Export " + this.getName() + " has missing info in " + DEPRECATED_KEY);
            }
            if (depObj.containsKey((Object)MSG_KEY)) {
                DeprecationInfo info = new DeprecationInfo(depObj.getString(MSG_KEY));
                info.setSince(depObj.getString(SINCE_KEY, null));
                info.setForRemoval(depObj.getString(FOR_REMOVAL_KEY, null));
                if (depObj.getString(MODE_KEY, null) != null) {
                    try {
                        info.setMode(DeprecationValidationMode.valueOf(depObj.getString(MODE_KEY)));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new IOException(iae);
                    }
                }
                this.getDeprecation().setPackageInfo(info);
            } else {
                if (depObj.containsKey((Object)SINCE_KEY)) {
                    throw new IOException("Export " + this.getName() + " has wrong since in " + DEPRECATED_KEY);
                }
                if (depObj.containsKey((Object)FOR_REMOVAL_KEY)) {
                    throw new IOException("Export " + this.getName() + " has wrong for-removal in " + DEPRECATED_KEY);
                }
                if (depObj.containsKey((Object)MODE_KEY)) {
                    throw new IOException("Export " + this.getName() + " has wrong mode in " + DEPRECATED_KEY);
                }
                JsonValue val = (JsonValue)depObj.get((Object)MEMBERS_KEY);
                if (val.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IOException("Export " + this.getName() + " has wrong type for " + MEMBERS_KEY + " : " + val.getValueType().name());
                }
                for (Map.Entry memberProp : val.asJsonObject().entrySet()) {
                    if (((JsonValue)memberProp.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                        DeprecationInfo info = new DeprecationInfo(((JsonString)memberProp.getValue()).getString());
                        this.getDeprecation().addMemberInfo((String)memberProp.getKey(), info);
                        continue;
                    }
                    if (((JsonValue)memberProp.getValue()).getValueType() == JsonValue.ValueType.OBJECT) {
                        JsonObject memberObj = ((JsonValue)memberProp.getValue()).asJsonObject();
                        if (!memberObj.containsKey((Object)MSG_KEY)) {
                            throw new IOException("Export " + this.getName() + " has wrong type for member in " + MEMBERS_KEY + " : " + ((JsonValue)memberProp.getValue()).getValueType().name());
                        }
                        DeprecationInfo info = new DeprecationInfo(memberObj.getString(MSG_KEY));
                        info.setSince(memberObj.getString(SINCE_KEY, null));
                        info.setForRemoval(depObj.getString(FOR_REMOVAL_KEY, null));
                        if (depObj.getString(MODE_KEY, null) != null) {
                            try {
                                info.setMode(DeprecationValidationMode.valueOf(depObj.getString(MODE_KEY)));
                            }
                            catch (IllegalArgumentException iae) {
                                throw new IOException(iae);
                            }
                        }
                        this.getDeprecation().addMemberInfo((String)memberProp.getKey(), info);
                        continue;
                    }
                    throw new IOException("Export " + this.getName() + " has wrong type for member in " + MEMBERS_KEY + " : " + ((JsonValue)memberProp.getValue()).getValueType().name());
                }
            }
        } else {
            throw new IOException("Export " + this.getName() + " has wrong type for " + DEPRECATED_KEY + " : " + dValue.getValueType().name());
        }
    }

    JsonValue deprecationToJSON() {
        Deprecation dep = this.getDeprecation();
        if (dep.getPackageInfo() != null) {
            if (dep.getPackageInfo().getSince() == null && dep.getPackageInfo().getForRemoval() == null && dep.getPackageInfo().getMode() == null) {
                return Json.createValue((String)dep.getPackageInfo().getMessage());
            }
            JsonObjectBuilder depBuilder = Json.createObjectBuilder();
            depBuilder.add(MSG_KEY, dep.getPackageInfo().getMessage());
            if (dep.getPackageInfo().getSince() != null) {
                depBuilder.add(SINCE_KEY, dep.getPackageInfo().getSince());
            }
            if (dep.getPackageInfo().getForRemoval() != null) {
                depBuilder.add(FOR_REMOVAL_KEY, dep.getPackageInfo().getForRemoval());
            }
            if (dep.getPackageInfo().getMode() != null) {
                depBuilder.add(MODE_KEY, dep.getPackageInfo().getMode().name());
            }
            return depBuilder.build();
        }
        if (!dep.getMemberInfos().isEmpty()) {
            JsonObjectBuilder depBuilder = Json.createObjectBuilder();
            JsonObjectBuilder membersBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, DeprecationInfo> memberEntry : dep.getMemberInfos().entrySet()) {
                if (memberEntry.getValue().getSince() == null && memberEntry.getValue().getForRemoval() == null && memberEntry.getValue().getMode() == null) {
                    membersBuilder.add(memberEntry.getKey(), memberEntry.getValue().getMessage());
                    continue;
                }
                JsonObjectBuilder mBuilder = Json.createObjectBuilder();
                mBuilder.add(MSG_KEY, memberEntry.getValue().getMessage());
                if (memberEntry.getValue().getSince() != null) {
                    mBuilder.add(SINCE_KEY, memberEntry.getValue().getSince());
                }
                if (memberEntry.getValue().getForRemoval() != null) {
                    mBuilder.add(FOR_REMOVAL_KEY, memberEntry.getValue().getForRemoval());
                }
                if (memberEntry.getValue().getMode() != null) {
                    mBuilder.add(MODE_KEY, memberEntry.getValue().getMode().name());
                }
                membersBuilder.add(memberEntry.getKey(), mBuilder);
            }
            depBuilder.add(MEMBERS_KEY, membersBuilder);
            return depBuilder.build();
        }
        return null;
    }

    JsonValue toJSONValue() {
        JsonValue depValue = this.deprecationToJSON();
        if (this.getToggle() == null && this.getPreviousPackageVersion() == null && this.getPreviousArtifactId() == null && this.getProperties().isEmpty() && depValue == null) {
            return Json.createValue((String)this.getName());
        }
        JsonObjectBuilder expBuilder = Json.createObjectBuilder();
        expBuilder.add(NAME_KEY, this.getName());
        if (this.getToggle() != null) {
            expBuilder.add(TOGGLE_KEY, this.getToggle());
        }
        if (this.getPreviousPackageVersion() != null) {
            expBuilder.add(PREVIOUS_PACKAGE_VERSION_KEY, this.getPreviousPackageVersion());
        }
        if (this.getPreviousArtifactId() != null) {
            expBuilder.add(PREVIOUS_ARTIFACT_ID_KEY, this.getPreviousArtifactId().toMvnId());
        }
        if (depValue != null) {
            expBuilder.add(DEPRECATED_KEY, depValue);
        }
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            expBuilder.add(entry.getKey(), entry.getValue());
        }
        return expBuilder.build();
    }

    static ApiExport fromJson(ApiRegion region, JsonValue val) throws IOException {
        if (val.getValueType() == JsonValue.ValueType.STRING) {
            String name = ((JsonString)val).getString();
            if (!name.startsWith("#")) {
                ApiExport export = new ApiExport(name);
                if (!region.add(export)) {
                    throw new IOException("Export " + export.getName() + " is defined twice in region " + region.getName());
                }
                return export;
            }
            return null;
        }
        if (val.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject expObj = (JsonObject)val;
            ApiExport export = new ApiExport(expObj.getString(NAME_KEY));
            if (!region.add(export)) {
                throw new IOException("Export " + export.getName() + " is defined twice in region " + region.getName());
            }
            boolean setPreviousArtifact = false;
            for (String key : expObj.keySet()) {
                if (NAME_KEY.equals(key)) continue;
                if (TOGGLE_KEY.equals(key)) {
                    export.setToggle(expObj.getString(key));
                    continue;
                }
                if (PREVIOUS_PACKAGE_VERSION_KEY.equals(key)) {
                    export.setPreviousPackageVersion(expObj.getString(key));
                    continue;
                }
                if (PREVIOUS_KEY.equals(key)) {
                    if (setPreviousArtifact) {
                        throw new IOException("Export " + export.getName() + " is defining previous artifact id twice in region " + region.getName());
                    }
                    export.setPreviousArtifactId(ArtifactId.parse((String)expObj.getString(key)));
                    setPreviousArtifact = true;
                    continue;
                }
                if (PREVIOUS_ARTIFACT_ID_KEY.equals(key)) {
                    if (setPreviousArtifact) {
                        throw new IOException("Export " + export.getName() + " is defining previous artifact id twice in region " + region.getName());
                    }
                    export.setPreviousArtifactId(ArtifactId.parse((String)expObj.getString(key)));
                    setPreviousArtifact = true;
                    continue;
                }
                if (DEPRECATED_KEY.equals(key)) {
                    JsonValue dValue = (JsonValue)expObj.get((Object)DEPRECATED_KEY);
                    export.parseDeprecation(dValue);
                    continue;
                }
                export.getProperties().put(key, expObj.getString(key));
            }
            return export;
        }
        throw new IOException("Region " + region.getName() + " has wrong type for package export : " + val.getValueType().name());
    }

    @Override
    public int compareTo(ApiExport o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "ApiExport [name=" + this.name + ", toggle=" + this.toggle + ", previousPackageVersion=" + this.previousPackageVersion + ", previousArtifactId=" + this.previousArtifactId + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        return Objects.hash(this.deprecation, this.name, this.previousPackageVersion, this.previousArtifactId, this.properties, this.toggle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiExport other = (ApiExport)obj;
        return Objects.equals(this.deprecation, other.deprecation) && Objects.equals(this.name, other.name) && Objects.equals(this.previousArtifactId, other.previousArtifactId) && Objects.equals(this.previousPackageVersion, other.previousPackageVersion) && Objects.equals(this.properties, other.properties) && Objects.equals(this.toggle, other.toggle);
    }
}

