/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.parser;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentElementImpl;
import org.apache.sling.fsprovider.internal.parser.ContentFileParserUtil;
import org.apache.sling.jcr.contentparser.ContentType;

public final class ContentFileCache {
    private final Map<String, ContentElement> contentCache;
    private final ContentElement NULL_ELEMENT = new ContentElementImpl(null, Collections.emptyMap());

    public ContentFileCache(int maxSize) {
        this.contentCache = maxSize > 0 ? Collections.synchronizedMap(new LRUMap(maxSize)) : null;
    }

    public ContentElement get(String path, File file) {
        return this.get(path, file, null);
    }

    public ContentElement get(String path, File file, ContentType contentType) {
        ContentElement content = null;
        if (this.contentCache != null) {
            content = this.contentCache.get(path);
        }
        if (content == null) {
            content = contentType != null ? ContentFileParserUtil.parse(file, contentType) : ContentFileParserUtil.parse(file);
            if (content == null) {
                content = this.NULL_ELEMENT;
            }
            if (this.contentCache != null) {
                this.contentCache.put(path, content);
            }
        }
        if (content == this.NULL_ELEMENT) {
            return null;
        }
        return content;
    }

    public void remove(String path) {
        if (this.contentCache != null) {
            this.contentCache.remove(path);
        }
    }

    public void clear() {
        if (this.contentCache != null) {
            this.contentCache.clear();
        }
    }

    public int size() {
        if (this.contentCache != null) {
            return this.contentCache.size();
        }
        return 0;
    }
}

