/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.i18n.impl.ResourceBundleEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceBundle
extends ResourceBundle {
    private static final Logger log = LoggerFactory.getLogger(JcrResourceBundle.class);
    static final String JCR_PATH = "jcr:path";
    static final String PROP_KEY = "sling:key";
    static final String PROP_VALUE = "sling:message";
    static final String PROP_BASENAME = "sling:basename";
    static final String PROP_LANGUAGE = "jcr:language";
    private final HashMap<String, Object> resources;
    private final Locale locale;

    JcrResourceBundle(Locale locale, String baseName, ResourceResolver resourceResolver) {
        this.locale = locale;
        long start = System.currentTimeMillis();
        String loadQuery = JcrResourceBundle.getFullLoadQuery(locale, baseName);
        this.resources = this.loadFully(resourceResolver, loadQuery);
        long end = System.currentTimeMillis();
        log.debug("JcrResourceBundle: Fully loaded {} entries for {} (base: {}) in {}ms", new Object[]{this.resources.size(), locale, baseName, end - start});
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> parentKeys = this.parent != null ? this.parent.getKeys() : null;
        return new ResourceBundleEnumeration(this.resources.keySet(), parentKeys);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.resources.get(key);
    }

    private HashMap<String, Object> loadFully(ResourceResolver resourceResolver, String fullLoadQuery) {
        log.debug("Executing full load query {}", (Object)fullLoadQuery);
        Iterator bundles = resourceResolver.queryResources(fullLoadQuery, "xpath");
        String[] path = resourceResolver.getSearchPath();
        ArrayList res0 = new ArrayList();
        for (int i = 0; i < path.length; ++i) {
            res0.add(new HashMap());
        }
        HashMap<String, Object> rest = new HashMap<String, Object>();
        while (bundles.hasNext()) {
            Map row = (Map)bundles.next();
            String jcrPath = (String)row.get(JCR_PATH);
            String key = (String)row.get(PROP_KEY);
            if (key == null) {
                key = ResourceUtil.getName((String)jcrPath);
            }
            Map<String, Object> dst = rest;
            for (int i = 0; i < path.length; ++i) {
                if (!jcrPath.startsWith(path[i])) continue;
                dst = (Map)res0.get(i);
                break;
            }
            dst.put(key, row.get(PROP_VALUE));
        }
        for (int i = path.length - 1; i >= 0; --i) {
            rest.putAll((Map)res0.get(i));
        }
        return rest;
    }

    private static String getFullLoadQuery(Locale locale, String baseName) {
        StringBuilder buf = new StringBuilder(64);
        buf.append("//element(*,mix:language)[");
        String localeString = locale.toString().toLowerCase();
        String localeRFC4646String = JcrResourceBundle.toRFC4646String(locale).toLowerCase();
        if (localeString.equals(localeRFC4646String)) {
            buf.append("fn:lower-case(@jcr:language)='");
            buf.append(localeString);
            buf.append('\'');
        } else {
            buf.append("(fn:lower-case(@jcr:language)='");
            buf.append(localeString);
            buf.append('\'');
            buf.append(" or fn:lower-case(@jcr:language)='");
            buf.append(localeRFC4646String);
            buf.append("')");
        }
        if (baseName != null) {
            buf.append(" and @");
            buf.append(PROP_BASENAME);
            if (baseName.length() > 0) {
                buf.append("='").append(baseName).append('\'');
            }
        }
        buf.append("]//element(*,sling:Message)");
        buf.append("[@").append(PROP_VALUE).append("]/(@");
        buf.append(PROP_KEY).append("|@").append(PROP_VALUE).append(")");
        return buf.toString();
    }

    private static String toRFC4646String(Locale locale) {
        return locale.toString().replace('_', '-');
    }
}

