/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.JcrResourceBundle;
import org.apache.sling.i18n.impl.RootResourceBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="%provider.name", description="%provider.description")
@Service(value={ResourceBundleProvider.class, ResourceChangeListener.class})
@Property(name="resource.paths", value={"/"})
public class JcrResourceBundleProvider
implements ResourceBundleProvider,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final boolean DEFAULT_PRELOAD_BUNDLES = false;
    private static final int DEFAULT_INVALIDATION_DELAY = 5000;
    private static final String SLING_I18N_USER = "sling-i18n";
    @Property(value={"en"})
    private static final String PROP_DEFAULT_LOCALE = "locale.default";
    @Property(boolValue={false})
    private static final String PROP_PRELOAD_BUNDLES = "preload.bundles";
    @Property(longValue={5000L})
    private static final String PROP_INVALIDATION_DELAY = "invalidation.delay";
    @Reference
    private Scheduler scheduler;
    private final Collection<String> scheduledJobNames = Collections.synchronizedList(new ArrayList());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Locale defaultLocale = Locale.ENGLISH;
    private ResourceResolver resourceResolver;
    private final ConcurrentHashMap<Key, JcrResourceBundle> resourceBundleCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Key, Semaphore> loadingGuards = new ConcurrentHashMap();
    private final Set<String> languageRootPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private ResourceBundle rootResourceBundle;
    private BundleContext bundleContext;
    private final Map<Key, ServiceRegistration<ResourceBundle>> bundleServiceRegistrations = new HashMap<Key, ServiceRegistration<ResourceBundle>>();
    private boolean preloadBundles;
    private long invalidationDelay;

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        return this.getResourceBundleInternal(baseName, locale);
    }

    public void onChange(List<ResourceChange> changes) {
        boolean refreshed = false;
        for (ResourceChange change : changes) {
            this.log.trace("handleEvent: Detecting event {} for path '{}'", (Object)change.getType(), (Object)change.getPath());
            if (this.languageRootPaths.contains(change.getPath())) {
                this.log.debug("handleEvent: Detected change of cached language root '{}', removing all cached ResourceBundles", (Object)change.getPath());
                this.scheduleReloadBundles(true);
                continue;
            }
            for (String root : this.languageRootPaths) {
                if (!change.getPath().startsWith(root)) continue;
                for (JcrResourceBundle bundle : this.resourceBundleCache.values()) {
                    if (!bundle.getLanguageRootPaths().contains(root)) continue;
                    this.log.debug("handleEvent: Resource changes below '{}', reloading ResourceBundle '{}'", (Object)root, (Object)bundle);
                    this.scheduleReloadBundle(bundle);
                    return;
                }
                this.log.debug("handleEvent: No cached resource bundle found with root '{}'", (Object)root);
                break;
            }
            if (!refreshed) {
                this.resourceResolver.refresh();
                refreshed = true;
            }
            if (!this.isDictionaryResource(change)) continue;
            this.scheduleReloadBundles(true);
        }
    }

    private boolean isDictionaryResource(ResourceChange change) {
        Resource resource = this.resourceResolver.getResource(change.getPath());
        if (resource == null) {
            this.log.trace("Could not get resource for '{}' for event {}", (Object)change.getPath(), (Object)change.getType());
            return false;
        }
        if (resource.getResourceType() == null) {
            return false;
        }
        if (resource.isResourceType("sling:MessageEntry")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:MessageEntry", (Object)change.getPath());
            return true;
        }
        ValueMap valueMap = resource.getValueMap();
        if (this.hasMixin(valueMap, "sling:Message")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:Message", (Object)change.getPath());
            return true;
        }
        if (change.getPath().endsWith(".json") && this.hasMixin(valueMap, "mix:language")) {
            this.log.debug("Found new dictionary: New {} resource in '{}' detected", (Object)"mix:language", (Object)change.getPath());
            return true;
        }
        return false;
    }

    private boolean hasMixin(ValueMap valueMap, String mixin) {
        String[] mixins = (String[])valueMap.get("jcr:mixinTypes", String[].class);
        if (mixins != null) {
            for (String m : mixins) {
                if (!mixin.equals(m)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReloadBundles(boolean withDelay) {
        Collection<String> collection = this.scheduledJobNames;
        synchronized (collection) {
            for (String scheduledJobName : this.scheduledJobNames) {
                this.scheduler.unschedule(scheduledJobName);
            }
        }
        this.scheduledJobNames.clear();
        ScheduleOptions options = withDelay ? this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay)) : this.scheduler.NOW();
        options.name("JcrResourceBundleProvider: reload all resource bundles");
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.log.info("Reloading all resource bundles");
                JcrResourceBundleProvider.this.clearCache();
                JcrResourceBundleProvider.this.preloadBundles();
            }
        }, options);
    }

    private void scheduleReloadBundle(JcrResourceBundle bundle) {
        String baseName = bundle.getBaseName();
        Locale locale = bundle.getLocale();
        final Key key = new Key(baseName, locale);
        ScheduleOptions options = this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay));
        final String jobName = "JcrResourceBundleProvider: reload bundle with key " + key.toString();
        this.scheduledJobNames.add(jobName);
        options.name(jobName);
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.reloadBundle(key);
                JcrResourceBundleProvider.this.scheduledJobNames.remove(jobName);
            }
        }, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadBundle(Key key) {
        this.resourceBundleCache.remove(key);
        this.log.info("Reloading resource bundle for {}", (Object)key);
        ServiceRegistration<ResourceBundle> serviceRegistration = null;
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            serviceRegistration = this.bundleServiceRegistrations.remove(key);
        }
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        } else {
            this.log.warn("Could not find resource bundle service for {}", (Object)key);
        }
        ArrayList<JcrResourceBundle> dependentBundles = new ArrayList<JcrResourceBundle>();
        for (JcrResourceBundle bundle : this.resourceBundleCache.values()) {
            JcrResourceBundle parentBundle;
            Key parentKey;
            if (!(bundle.getParent() instanceof JcrResourceBundle) || !(parentKey = new Key((parentBundle = (JcrResourceBundle)bundle.getParent()).getBaseName(), parentBundle.getLocale())).equals(key)) continue;
            this.log.debug("Also invalidate dependent bundle {} which has bundle {} as parent", (Object)bundle, (Object)parentBundle);
            dependentBundles.add(bundle);
        }
        for (JcrResourceBundle dependentBundle : dependentBundles) {
            this.reloadBundle(new Key(dependentBundle.getBaseName(), dependentBundle.getLocale()));
        }
        if (this.preloadBundles) {
            this.getResourceBundle(key.baseName, key.locale);
        }
    }

    protected void activate(BundleContext context, Map<String, Object> props) throws LoginException {
        String localeString = PropertiesUtil.toString(props.get(PROP_DEFAULT_LOCALE), null);
        this.defaultLocale = JcrResourceBundleProvider.toLocale(localeString);
        this.preloadBundles = PropertiesUtil.toBoolean(props.get(PROP_PRELOAD_BUNDLES), false);
        this.bundleContext = context;
        this.invalidationDelay = PropertiesUtil.toLong(props.get(PROP_INVALIDATION_DELAY), 5000L);
        if (this.resourceResolverFactory != null) {
            Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SLING_I18N_USER);
            this.resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);
            this.scheduleReloadBundles(false);
        }
    }

    protected void deactivate() {
        this.clearCache();
        this.resourceResolver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleInternal(String baseName, Locale locale) {
        Key key = new Key(baseName, locale);
        JcrResourceBundle resourceBundle = this.resourceBundleCache.get(key);
        if (resourceBundle != null) {
            this.log.debug("getResourceBundleInternal({}): got cache hit on first try", (Object)key);
        } else {
            if (this.loadingGuards.get(key) == null) {
                this.loadingGuards.putIfAbsent(key, new Semaphore(1));
            }
            Semaphore loadingGuard = this.loadingGuards.get(key);
            try {
                loadingGuard.acquire();
                resourceBundle = this.resourceBundleCache.get(key);
                if (resourceBundle != null) {
                    this.log.debug("getResourceBundleInternal({}): got cache hit on second try", (Object)key);
                } else {
                    this.log.debug("getResourceBundleInternal({}): reading from Repository", (Object)key);
                    resourceBundle = this.createResourceBundle(key.baseName, key.locale);
                    this.resourceBundleCache.put(key, resourceBundle);
                    this.registerResourceBundle(key, resourceBundle);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            finally {
                loadingGuard.release();
            }
        }
        this.log.trace("getResourceBundleInternal({}) ==> {}", (Object)key, (Object)resourceBundle);
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerResourceBundle(Key key, JcrResourceBundle resourceBundle) {
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        if (key.baseName != null) {
            ((Dictionary)serviceProps).put("baseName", key.baseName);
        }
        ((Dictionary)serviceProps).put("locale", key.locale.toString());
        ServiceRegistration serviceReg = this.bundleContext.registerService(ResourceBundle.class, (Object)resourceBundle, serviceProps);
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            this.bundleServiceRegistrations.put(key, (ServiceRegistration<ResourceBundle>)serviceReg);
        }
        Set<String> languageRoots = resourceBundle.getLanguageRootPaths();
        this.languageRootPaths.addAll(languageRoots);
        this.log.debug("registerResourceBundle({}, ...): added service registration and language roots {}", (Object)key, languageRoots);
        this.log.info("Currently loaded dictionaries across all locales: {}", this.languageRootPaths);
    }

    private JcrResourceBundle createResourceBundle(String baseName, Locale locale) {
        JcrResourceBundle bundle = new JcrResourceBundle(locale, baseName, this.resourceResolver);
        Locale parentLocale = this.getParentLocale(locale);
        if (parentLocale != null) {
            bundle.setParent(this.getResourceBundleInternal(baseName, parentLocale));
        } else {
            bundle.setParent(this.getRootResourceBundle());
        }
        return bundle;
    }

    private Locale getParentLocale(Locale locale) {
        if (locale.getVariant().length() != 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() != 0) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.defaultLocale;
        }
        return null;
    }

    private ResourceBundle getRootResourceBundle() {
        if (this.rootResourceBundle == null) {
            this.rootResourceBundle = new RootResourceBundle();
        }
        return this.rootResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        this.resourceBundleCache.clear();
        this.languageRootPaths.clear();
        JcrResourceBundleProvider jcrResourceBundleProvider = this;
        synchronized (jcrResourceBundleProvider) {
            for (ServiceRegistration<ResourceBundle> serviceReg : this.bundleServiceRegistrations.values()) {
                serviceReg.unregister();
            }
            this.bundleServiceRegistrations.clear();
        }
    }

    private void preloadBundles() {
        if (this.preloadBundles) {
            this.resourceResolver.refresh();
            Iterator bundles = this.resourceResolver.queryResources("//element(*,mix:language)[@jcr:language]", "xpath");
            HashSet<Key> usedKeys = new HashSet<Key>();
            while (bundles.hasNext()) {
                Key key;
                Map bundle = (Map)bundles.next();
                if (!bundle.containsKey("jcr:language")) continue;
                Locale locale = JcrResourceBundleProvider.toLocale(bundle.get("jcr:language").toString());
                String baseName = null;
                if (bundle.containsKey("sling:basename")) {
                    baseName = bundle.get("sling:basename").toString();
                }
                if (!usedKeys.add(key = new Key(baseName, locale))) continue;
                this.getResourceBundle(baseName, locale);
            }
        }
    }

    static Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = (localeString = localeString.replaceAll("-", "_")).split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = parts[0];
        boolean isValidLanguageCode = false;
        String[] langs = Locale.getISOLanguages();
        for (int i = 0; i < langs.length; ++i) {
            if (!langs[i].equalsIgnoreCase(lang)) continue;
            isValidLanguageCode = true;
            break;
        }
        if (!isValidLanguageCode) {
            lang = Locale.getDefault().getLanguage();
        }
        if (parts.length == 1) {
            return new Locale(lang);
        }
        String country = parts[1];
        boolean isValidCountryCode = false;
        String[] countries = Locale.getISOCountries();
        for (int i = 0; i < countries.length; ++i) {
            if (!countries[i].equalsIgnoreCase(country)) continue;
            isValidCountryCode = true;
            break;
        }
        if (!isValidCountryCode) {
            country = Locale.getDefault().getCountry();
        }
        if (parts.length == 2) {
            return new Locale(lang, country);
        }
        return new Locale(lang, country, parts[2]);
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected static final class Key {
        final String baseName;
        final Locale locale;
        private final int hashCode;

        Key(String baseName, Locale locale) {
            int hc = 0;
            if (baseName != null) {
                hc += 17 * baseName.hashCode();
            }
            if (locale != null) {
                hc += 13 * locale.hashCode();
            }
            this.baseName = baseName;
            this.locale = locale;
            this.hashCode = hc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.baseName, other.baseName) && Key.equals(this.locale, other.locale);
            }
            return false;
        }

        private static boolean equals(Object o1, Object o2) {
            return !(o1 == null ? o2 != null : !o1.equals(o2));
        }

        public String toString() {
            return "Key(" + this.baseName + ", " + this.locale + ")";
        }
    }
}

