/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.Arrays;
import java.util.Locale;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

class PotentialLanguageRootCheck {
    private final String baseName;
    private final String localeString;
    private final String localeStringLower;
    private final String localeRFC4646String;
    private final String localeRFC4646StringLower;

    public PotentialLanguageRootCheck(String baseName, Locale locale) {
        this.baseName = baseName;
        this.localeString = locale.toString();
        this.localeStringLower = this.localeString.toLowerCase();
        this.localeRFC4646String = PotentialLanguageRootCheck.toRFC4646String(locale);
        this.localeRFC4646StringLower = this.localeRFC4646String.toLowerCase();
    }

    public boolean isResourceBundle(Resource resource) {
        String language;
        boolean match = false;
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        if (properties != null && (language = (String)properties.get("jcr:language", String.class)) != null && language.length() > 0 && (language.equals(this.localeString) || language.equals(this.localeStringLower) || language.equals(this.localeRFC4646String) || language.equals(this.localeRFC4646StringLower))) {
            String[] baseNames = (String[])properties.get("sling:basename", (Object)new String[0]);
            if (this.baseName == null || Arrays.asList(baseNames).contains(this.baseName)) {
                match = true;
            }
        }
        return match;
    }

    private static String toRFC4646String(Locale locale) {
        return locale.toString().replace('_', '-');
    }
}

