/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.Config;
import org.apache.sling.i18n.impl.JcrResourceBundle;
import org.apache.sling.i18n.impl.LocatorPaths;
import org.apache.sling.i18n.impl.LocatorPathsTracker;
import org.apache.sling.i18n.impl.PathFilter;
import org.apache.sling.i18n.impl.RootResourceBundle;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceBundleProvider.class, ResourceChangeListener.class}, property={"service.description=Apache Sling I18n Resource Bundle Provider", "service.vendor=The Apache Software Foundation", "resource.paths=/", "resource.change.types=ADDED", "resource.change.types=REMOVED", "resource.change.types=CHANGED"})
@Designate(ocd=Config.class)
public class JcrResourceBundleProvider
implements ResourceBundleProvider,
ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern USER_ASSIGNED_COUNTRY_CODES_PATTERN = Pattern.compile("aa|q[m-z]|x[a-z]|zz");
    @Reference
    private Scheduler scheduler;
    private final Collection<String> scheduledJobNames = Collections.synchronizedList(new ArrayList());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    private volatile Locale defaultLocale = Locale.ENGLISH;
    private ResourceBundleRegistry resourceBundleRegistry;
    private final ConcurrentHashMap<Key, Semaphore> loadingGuards = new ConcurrentHashMap();
    private final Set<String> languageRootPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile ResourceBundle rootResourceBundle;
    private BundleTracker<Set<LocatorPaths>> locatorPathsTracker;
    private List<LocatorPaths> locatorPaths = new CopyOnWriteArrayList<LocatorPaths>();
    private volatile PathFilter pathFilter;
    private volatile boolean preloadBundles;
    private volatile long invalidationDelay;

    public void registerLocatorPaths(Set<LocatorPaths> locatorPathsSet) {
        this.locatorPaths.addAll(locatorPathsSet);
        this.clearCache();
    }

    public void unregisterLocatorPaths(Set<LocatorPaths> locatorPathsSet) {
        this.locatorPaths.removeAll(locatorPathsSet);
        this.clearCache();
    }

    private ResourceResolver createResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return this.getResourceBundleInternal(null, baseName, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(List<ResourceChange> changes) {
        if (this.resourceBundleRegistry.isClosed()) {
            return;
        }
        ChangeStatus status = new ChangeStatus();
        try {
            for (ResourceChange change : changes) {
                if (!this.pathFilter.includePath(change.getPath())) continue;
                this.onChange(status, change);
                if (!status.reloadAll) continue;
                break;
            }
            if (status.reloadAll) {
                this.scheduleReloadBundles(true);
            } else {
                for (JcrResourceBundle bundle : status.reloadBundles) {
                    this.scheduleReloadBundle(bundle);
                }
            }
        }
        catch (LoginException le) {
            this.log.error("Unable to get service resource resolver.", (Throwable)le);
        }
        finally {
            if (status.resourceResolver != null) {
                status.resourceResolver.close();
            }
        }
    }

    private void onChange(ChangeStatus status, ResourceChange change) throws LoginException {
        this.log.debug("onChange: Detecting change {} for path '{}'", (Object)change.getType(), (Object)change.getPath());
        if (this.languageRootPaths.contains(change.getPath())) {
            this.log.debug("onChange: Detected change of cached language root '{}', removing all cached ResourceBundles", (Object)change.getPath());
            status.reloadAll = true;
        } else {
            for (String root : this.languageRootPaths) {
                if (!change.getPath().startsWith(root)) continue;
                for (JcrResourceBundle bundle : this.resourceBundleRegistry.getResourceBundles()) {
                    if (!bundle.getLanguageRootPaths().contains(root)) continue;
                    this.log.debug("onChange: Resource changes below '{}', reloading ResourceBundle '{}'", (Object)root, (Object)bundle);
                    status.reloadBundles.add(bundle);
                }
            }
            if (status.resourceResolver == null) {
                status.resourceResolver = this.createResourceResolver();
            }
            if (this.isDictionaryResource(status.resourceResolver, change)) {
                status.reloadAll = true;
            }
        }
    }

    private boolean isDictionaryResource(ResourceResolver resolver, ResourceChange change) {
        Resource resource = resolver.getResource(change.getPath());
        if (resource == null) {
            this.log.trace("Could not get resource for '{}' for event {}", (Object)change.getPath(), (Object)change.getType());
            return false;
        }
        if (resource.getResourceType() == null) {
            return false;
        }
        if (resource.isResourceType("sling:MessageEntry")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:MessageEntry", (Object)change.getPath());
            return true;
        }
        ValueMap valueMap = resource.getValueMap();
        if (this.hasMixin(valueMap, "sling:Message")) {
            this.log.debug("Found new dictionary entry: New {} resource in '{}' detected", (Object)"sling:Message", (Object)change.getPath());
            return true;
        }
        if (change.getPath().endsWith(".json") && this.hasMixin(valueMap, "mix:language")) {
            this.log.debug("Found new dictionary: New {} resource in '{}' detected", (Object)"mix:language", (Object)change.getPath());
            return true;
        }
        return false;
    }

    private boolean hasMixin(ValueMap valueMap, String mixin) {
        String[] mixins = (String[])valueMap.get("jcr:mixinTypes", String[].class);
        if (mixins != null) {
            for (String m : mixins) {
                if (!mixin.equals(m)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReloadBundles(boolean withDelay) {
        Collection<String> collection = this.scheduledJobNames;
        synchronized (collection) {
            for (String scheduledJobName : this.scheduledJobNames) {
                this.scheduler.unschedule(scheduledJobName);
            }
        }
        this.scheduledJobNames.clear();
        ScheduleOptions options = withDelay ? this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay)) : this.scheduler.NOW();
        options.name("ResourceBundleProvider: reload all resource bundles");
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.log.info("Reloading all resource bundles");
                JcrResourceBundleProvider.this.clearCache();
                JcrResourceBundleProvider.this.preloadBundles();
            }
        }, options);
    }

    private void scheduleReloadBundle(JcrResourceBundle bundle) {
        final Key key = new Key(bundle.getBaseName(), bundle.getLocale());
        ScheduleOptions options = this.scheduler.AT(new Date(System.currentTimeMillis() + this.invalidationDelay));
        final String jobName = "ResourceBundleProvider: reload bundle with key " + key.toString();
        this.scheduledJobNames.add(jobName);
        options.name(jobName);
        this.scheduler.schedule((Object)new Runnable(){

            @Override
            public void run() {
                JcrResourceBundleProvider.this.reloadBundle(key);
                JcrResourceBundleProvider.this.scheduledJobNames.remove(jobName);
            }
        }, options);
    }

    void reloadBundle(Key key) {
        this.log.info("Reloading resource bundle for {}", (Object)key);
        if (!this.preloadBundles) {
            this.resourceBundleRegistry.unregisterResourceBundle(key);
        }
        ArrayList<JcrResourceBundle> dependentBundles = new ArrayList<JcrResourceBundle>();
        for (JcrResourceBundle bundle : this.resourceBundleRegistry.getResourceBundles()) {
            JcrResourceBundle parentBundle;
            Key parentKey;
            if (!(bundle.getParent() instanceof JcrResourceBundle) || !(parentKey = new Key((parentBundle = (JcrResourceBundle)bundle.getParent()).getBaseName(), parentBundle.getLocale())).equals(key)) continue;
            this.log.debug("Also invalidate dependent bundle {} which has bundle {} as parent", (Object)bundle, (Object)parentBundle);
            dependentBundles.add(bundle);
        }
        for (JcrResourceBundle dependentBundle : dependentBundles) {
            this.reloadBundle(new Key(dependentBundle.getBaseName(), dependentBundle.getLocale()));
        }
        if (this.preloadBundles && !this.resourceBundleRegistry.isClosed()) {
            this.getResourceBundleInternal(null, key.baseName, key.locale, true);
        }
    }

    @Activate
    protected void activate(BundleContext context, Config config) throws LoginException {
        this.defaultLocale = JcrResourceBundleProvider.toLocale(config.locale_default());
        this.preloadBundles = config.preload_bundles();
        this.invalidationDelay = config.invalidation_delay();
        this.pathFilter = new PathFilter(config.included_paths(), config.excluded_paths());
        this.resourceBundleRegistry = new ResourceBundleRegistry(context);
        this.locatorPathsTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)new LocatorPathsTracker(this));
        this.locatorPathsTracker.open();
        if (this.resourceResolverFactory != null) {
            this.scheduleReloadBundles(false);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.locatorPathsTracker != null) {
            this.locatorPathsTracker.close();
            this.locatorPathsTracker = null;
        }
        if (this.resourceBundleRegistry != null) {
            this.resourceBundleRegistry.close();
        }
        this.clearCache();
    }

    private ResourceBundle getResourceBundleInternal(ResourceResolver optionalResolver, String baseName, Locale locale) {
        return this.getResourceBundleInternal(optionalResolver, baseName, locale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleInternal(ResourceResolver optionalResolver, String baseName, Locale locale, boolean forceReload) {
        JcrResourceBundle resourceBundle;
        Key key;
        block17: {
            if (locale == null) {
                locale = this.defaultLocale;
            }
            key = new Key(baseName, locale);
            JcrResourceBundle jcrResourceBundle = resourceBundle = !forceReload ? this.resourceBundleRegistry.getResourceBundle(key) : null;
            if (resourceBundle != null) {
                this.log.debug("getResourceBundleInternal({}): got cache hit on first try", (Object)key);
            } else {
                if (this.loadingGuards.get(key) == null) {
                    this.loadingGuards.putIfAbsent(key, new Semaphore(1));
                }
                Semaphore loadingGuard = this.loadingGuards.get(key);
                try {
                    loadingGuard.acquire();
                    JcrResourceBundle jcrResourceBundle2 = resourceBundle = !forceReload ? this.resourceBundleRegistry.getResourceBundle(key) : null;
                    if (resourceBundle != null) {
                        this.log.debug("getResourceBundleInternal({}): got cache hit on second try", (Object)key);
                        break block17;
                    }
                    this.log.debug("getResourceBundleInternal({}): reading from Repository", (Object)key);
                    try (ResourceResolver localResolver = null;){
                        if (optionalResolver == null) {
                            optionalResolver = localResolver = this.createResourceResolver();
                        }
                        resourceBundle = this.createResourceBundle(optionalResolver, key.baseName, key.locale);
                        this.resourceBundleRegistry.registerResourceBundle(key, resourceBundle);
                        Set<String> languageRoots = resourceBundle.getLanguageRootPaths();
                        this.languageRootPaths.addAll(languageRoots);
                        this.log.debug("Key {} - added service registration and language roots {}", (Object)key, languageRoots);
                        this.log.info("Currently loaded dictionaries across all locales: {}", this.languageRootPaths);
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                finally {
                    loadingGuard.release();
                }
            }
        }
        this.log.trace("getResourceBundleInternal({}) ==> {}", (Object)key, (Object)resourceBundle);
        return resourceBundle;
    }

    private JcrResourceBundle createResourceBundle(ResourceResolver resolver, String baseName, Locale locale) {
        JcrResourceBundle bundle = new JcrResourceBundle(locale, baseName, resolver, this.locatorPaths, this.pathFilter);
        Locale parentLocale = this.getParentLocale(locale);
        if (parentLocale != null) {
            bundle.setParent(this.getResourceBundleInternal(resolver, baseName, parentLocale));
        } else {
            bundle.setParent(this.getRootResourceBundle());
        }
        return bundle;
    }

    protected Locale getParentLocale(Locale locale) {
        if (!locale.getScript().isEmpty() && !locale.getVariant().isEmpty()) {
            try {
                return new Locale.Builder().setLanguage(locale.getLanguage()).setRegion(locale.getCountry()).setScript(locale.getScript()).build();
            }
            catch (IllformedLocaleException e) {
                return new Locale(locale.getLanguage(), locale.getCountry());
            }
        }
        if (!locale.getScript().isEmpty() && !locale.getCountry().isEmpty()) {
            try {
                return new Locale.Builder().setLanguage(locale.getLanguage()).setScript(locale.getScript()).build();
            }
            catch (IllformedLocaleException e) {
                return new Locale(locale.getLanguage());
            }
        }
        if (!locale.getScript().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.defaultLocale;
        }
        return null;
    }

    private ResourceBundle getRootResourceBundle() {
        if (this.rootResourceBundle == null) {
            this.rootResourceBundle = new RootResourceBundle();
        }
        return this.rootResourceBundle;
    }

    void clearCache() {
        this.languageRootPaths.clear();
        this.resourceBundleRegistry.unregisterAll();
    }

    private void preloadBundles() {
        if (this.preloadBundles && !this.resourceBundleRegistry.isClosed()) {
            try (ResourceResolver resolver = this.createResourceResolver();){
                Iterator bundles = resolver.queryResources("//element(*,mix:language)[@jcr:language]", "xpath");
                HashSet<Key> usedKeys = new HashSet<Key>();
                while (bundles.hasNext()) {
                    Map bundle = (Map)bundles.next();
                    if (!bundle.containsKey("jcr:language") || !bundle.containsKey("jcr:path")) continue;
                    String path = bundle.get("jcr:path").toString();
                    String language = bundle.get("jcr:language").toString();
                    if (this.pathFilter.includePath(path)) {
                        Locale locale = JcrResourceBundleProvider.toLocale(language);
                        String baseName = bundle.containsKey("sling:basename") ? bundle.get("sling:basename").toString() : null;
                        Key key = new Key(baseName, locale);
                        if (!usedKeys.add(key)) continue;
                        this.getResourceBundleInternal(resolver, baseName, locale);
                        continue;
                    }
                    this.log.warn("Ignoring i18n bundle for language {} at {} because it is not included by the path filter", (Object)language, (Object)path);
                }
            }
            catch (LoginException le) {
                this.log.error("Unable to create service user resource resolver.", (Throwable)le);
            }
        }
    }

    static Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = (localeString = localeString.replaceAll("-", "_")).split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = JcrResourceBundleProvider.getValidLanguage(parts[0]);
        if (parts.length == 1) {
            return new Locale(lang);
        }
        Locale localeWithBuilder = JcrResourceBundleProvider.createLocaleWithBuilder(parts, lang);
        if (localeWithBuilder != null) {
            return localeWithBuilder;
        }
        return JcrResourceBundleProvider.createLocaleWithConstructor(lang, parts);
    }

    private static Locale createLocaleWithBuilder(String[] parts, String lang) {
        if (parts.length >= 2 && JcrResourceBundleProvider.isScript(parts[1])) {
            try {
                switch (parts.length) {
                    case 2: {
                        return new Locale.Builder().setLanguage(lang).setScript(parts[1]).build();
                    }
                    case 3: {
                        return new Locale.Builder().setLanguage(lang).setScript(parts[1]).setRegion(JcrResourceBundleProvider.getValidCountry(parts[2])).build();
                    }
                }
                return JcrResourceBundleProvider.processMultipleParts(parts, lang);
            }
            catch (IllformedLocaleException e) {
                LoggerFactory.getLogger(JcrResourceBundleProvider.class).warn("Failed to create locale with LocaleBuilder having parts: {}", (Object)Arrays.toString(parts), (Object)e);
            }
        }
        return null;
    }

    private static Locale processMultipleParts(String[] parts, String lang) {
        if (parts.length >= 4) {
            Locale.Builder localeBuilder = new Locale.Builder().setLanguage(lang).setScript(parts[1]).setRegion(JcrResourceBundleProvider.getValidCountry(parts[2]));
            try {
                localeBuilder.setVariant(parts[3]);
                return localeBuilder.build();
            }
            catch (IllformedLocaleException e) {
                return localeBuilder.build();
            }
        }
        return null;
    }

    private static String getValidLanguage(String lang) {
        for (String validLang : Locale.getISOLanguages()) {
            if (!validLang.equalsIgnoreCase(lang)) continue;
            return lang;
        }
        return Locale.getDefault().getLanguage();
    }

    private static String getValidCountry(String country) {
        return JcrResourceBundleProvider.isValidCountryCode(country) ? country : Locale.getDefault().getCountry();
    }

    private static Locale createLocaleWithConstructor(String lang, String[] parts) {
        String country = parts.length > 1 ? JcrResourceBundleProvider.getValidCountry(parts[1]) : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return new Locale(lang, country, variant);
    }

    private static boolean isValidCountryCode(String country) {
        boolean isValidCountryCode = false;
        if (USER_ASSIGNED_COUNTRY_CODES_PATTERN.matcher(country.toLowerCase()).matches()) {
            isValidCountryCode = true;
        } else {
            String[] countries = Locale.getISOCountries();
            for (int i = 0; i < countries.length; ++i) {
                if (!countries[i].equalsIgnoreCase(country)) continue;
                isValidCountryCode = true;
                break;
            }
        }
        return isValidCountryCode;
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (JcrResourceBundleProvider.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isScript(String s) {
        return s.length() == 4 && JcrResourceBundleProvider.isAlphaString(s);
    }

    private static class ResourceBundleRegistry
    implements AutoCloseable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final BundleContext bundleContext;
        final AtomicBoolean closed = new AtomicBoolean(false);
        private final AtomicReference<ConcurrentHashMap<Key, Entry>> registrations;

        ResourceBundleRegistry(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.registrations = new AtomicReference(new ConcurrentHashMap());
        }

        JcrResourceBundle getResourceBundle(Key key) {
            Entry entry = this.registrations.get().get(key);
            return entry != null ? entry.resourceBundle : null;
        }

        Collection<JcrResourceBundle> getResourceBundles() {
            return this.registrations.get().values().stream().map(e -> e.resourceBundle).collect(Collectors.toList());
        }

        void registerResourceBundle(Key key, JcrResourceBundle resourceBundle) {
            if (this.closed.get()) {
                return;
            }
            ServiceRegistration serviceReg = this.bundleContext.registerService(ResourceBundle.class, (Object)resourceBundle, ResourceBundleRegistry.serviceProps(key));
            Entry oldEntry = this.registrations.get().put(key, new Entry(resourceBundle, (ServiceRegistration<ResourceBundle>)serviceReg));
            if (oldEntry != null) {
                oldEntry.serviceRegistration.unregister();
            }
            this.log.debug("[ResourceBundleRegistry.updateResourceBundle] Registry updated - Nr of entries: {} - Keys: {}", (Object)this.registrations.get().size(), (Object)this.registrations.get().keySet());
        }

        private static Dictionary<String, Object> serviceProps(Key key) {
            Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
            if (key.baseName != null) {
                ((Dictionary)serviceProps).put("baseName", key.baseName);
            }
            ((Dictionary)serviceProps).put("locale", key.locale.toString());
            return serviceProps;
        }

        void unregisterResourceBundle(Key key) {
            if (this.closed.get()) {
                return;
            }
            Entry oldEntry = this.registrations.get().remove(key);
            if (oldEntry != null) {
                oldEntry.serviceRegistration.unregister();
            } else {
                this.log.warn("[ResourceBundleRegistry.unregisterResourceBundle] Could not find resource bundle service for {}", (Object)key);
            }
        }

        void unregisterAll() {
            if (this.closed.get()) {
                return;
            }
            this.unregisterAllInternal();
        }

        private void unregisterAllInternal() {
            this.log.debug("[ResourceBundleRegistry.clearInternal] Before - Nr of Keys: {} - Keys: {}", (Object)this.registrations.get().size(), (Object)this.registrations.get().keySet());
            ConcurrentHashMap oldServiceReg = this.registrations.getAndSet(new ConcurrentHashMap());
            for (Entry entry : oldServiceReg.values()) {
                entry.serviceRegistration.unregister();
            }
            this.log.debug("[ResourceBundleRegistry.clearInternal] After - Nr of Keys: {} - Keys: {}", (Object)this.registrations.get().size(), (Object)this.registrations.get().keySet());
        }

        boolean isClosed() {
            return this.closed.get();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.unregisterAllInternal();
            }
        }

        private static class Entry {
            final JcrResourceBundle resourceBundle;
            final ServiceRegistration<ResourceBundle> serviceRegistration;

            Entry(JcrResourceBundle resourceBundle, ServiceRegistration<ResourceBundle> serviceRegistration) {
                this.resourceBundle = resourceBundle;
                this.serviceRegistration = serviceRegistration;
            }
        }
    }

    private static final class ChangeStatus {
        public ResourceResolver resourceResolver;
        public boolean reloadAll = false;
        public final Set<JcrResourceBundle> reloadBundles = new HashSet<JcrResourceBundle>();

        private ChangeStatus() {
        }
    }

    protected static final class Key {
        final String baseName;
        final Locale locale;
        private final int hashCode;

        Key(String baseName, Locale locale) {
            int hc = 0;
            if (baseName != null) {
                hc += 17 * baseName.hashCode();
            }
            if (locale != null) {
                hc += 13 * locale.hashCode();
            }
            this.baseName = baseName;
            this.locale = locale;
            this.hashCode = hc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.baseName, other.baseName) && Key.equals(this.locale, other.locale);
            }
            return false;
        }

        private static boolean equals(Object o1, Object o2) {
            return !(o1 == null ? o2 != null : !o1.equals(o2));
        }

        public String toString() {
            return "Key(" + this.baseName + ", " + this.locale + ")";
        }
    }
}

