/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;

public class OsgiInstallerWebConsolePlugin
extends GenericServlet {
    private InfoProvider installer;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MMM-dd");

    private String getType(RegisteredResource rsrc) {
        String type = rsrc.getType();
        if (type.equals("bundle")) {
            return "Bundles";
        }
        if (type.equals("config")) {
            return "Configurations";
        }
        if (type.equals("file")) {
            return "Files";
        }
        if (type.equals("properties")) {
            return "Properties";
        }
        return type;
    }

    private String getEntityId(RegisteredResource rsrc, String alias) {
        String id = rsrc.getEntityId();
        int pos = id.indexOf(58);
        if (pos != -1) {
            id = id.substring(pos + 1);
        }
        return alias == null ? id : id + '\n' + alias;
    }

    private String getURL(Resource rsrc) {
        if (rsrc.getVersion() != null) {
            return rsrc.getURL() + " (" + rsrc.getVersion() + ")";
        }
        return rsrc.getURL();
    }

    private String getState(Resource rsrc) {
        String stateInfo = rsrc.getState().toString();
        if (rsrc.getState() == ResourceState.INSTALLED) {
            if (rsrc.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                stateInfo = "EXCLUDED";
            }
            if (rsrc.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                stateInfo = stateInfo + "(*)";
            }
        }
        return stateInfo;
    }

    private String getInfo(RegisteredResource rsrc) {
        return rsrc.getDigest() + '/' + String.valueOf(rsrc.getPriority());
    }

    private synchronized String formatDate(long time) {
        if (time == -1L) {
            return "-";
        }
        Date d = new Date(time);
        return this.dateFormat.format(d);
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        PrintWriter pw = res.getWriter();
        InstallationState state = this.installer.getInstallationState();
        pw.print("<p class='statline ui-state-highlight'>Apache Sling OSGi Installer");
        if (state.getActiveResources().size() == 0 && state.getInstalledResources().size() == 0 && state.getUntransformedResources().size() == 0) {
            pw.print(" - no resources registered.");
        }
        pw.print("</p>");
        String rt = null;
        for (ResourceGroup group : state.getActiveResources()) {
            Resource toActivate = (Resource)group.getResources().get(0);
            if (!toActivate.getType().equals(rt)) {
                if (rt != null) {
                    pw.println("</tbody></table>");
                }
                pw.println("<div class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                pw.printf("<span style='float: left; margin-left: 1em;'>Active Resources - %s</span>", this.getType((RegisteredResource)toActivate));
                pw.println("</div>");
                pw.println("<table class='nicetable'><tbody>");
                pw.printf("<tr><th>Entity ID</th><th>Digest/Priority</th><th>URL (Version)</th><th>State</th></tr>", new Object[0]);
                rt = toActivate.getType();
            }
            pw.printf("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", this.getEntityId((RegisteredResource)toActivate, group.getAlias()), this.getInfo((RegisteredResource)toActivate), this.getURL(toActivate), toActivate.getState());
        }
        if (rt != null) {
            pw.println("</tbody></table>");
        }
        rt = null;
        for (ResourceGroup group : state.getInstalledResources()) {
            long lastChange;
            List resources = group.getResources();
            if (resources.size() <= 0) continue;
            Iterator iter = resources.iterator();
            Resource first = (Resource)iter.next();
            if (!first.getType().equals(rt)) {
                if (rt != null) {
                    pw.println("</tbody></table>");
                }
                pw.println("<div class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                pw.printf("<span style='float: left; margin-left: 1em;'>Processed Resources - %s</span>", this.getType((RegisteredResource)first));
                pw.println("</div>");
                pw.println("<table class='nicetable'><tbody>");
                pw.printf("<tr><th>Entity ID</th><th>Digest/Priority</th><th>URL (Version)</th><th>State</th></tr>", new Object[0]);
                rt = first.getType();
            }
            pw.print("<tr><td>");
            pw.print(this.getEntityId((RegisteredResource)first, group.getAlias()));
            pw.print("</td><td>");
            pw.print(this.getInfo((RegisteredResource)first));
            pw.print("</td><td>");
            pw.print(this.getURL(first));
            pw.print("</td><td>");
            pw.print(this.getState(first));
            if (first.getState() == ResourceState.INSTALLED && (lastChange = first.getLastChange()) > 0L) {
                pw.print("<br/>");
                pw.print(this.formatDate(lastChange));
            }
            pw.print("</td></tr>");
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                pw.printf("<tr><td></td><td colspan='2'>%s</td><td></td></tr>", first.getAttribute("org.apache.sling.installer.api.resource.install.excluded"));
            }
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                pw.printf("<tr><td></td><td colspan='2'>%s</td><td></td></tr>", first.getAttribute("org.apache.sling.installer.api.resource.install.info"));
            }
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                pw.printf("<tr><td></td><td>%s</td><td>%s</td><td>%s</td></tr>", this.getInfo((RegisteredResource)resource), this.getURL(resource), resource.getState());
            }
        }
        if (rt != null) {
            pw.println("</tbody></table>");
        }
        rt = null;
        for (RegisteredResource registeredResource : state.getUntransformedResources()) {
            if (!registeredResource.getType().equals(rt)) {
                if (rt != null) {
                    pw.println("</tbody></table>");
                }
                pw.println("<div class='ui-widget-header ui-corner-top buttonGroup' style='height: 15px;'>");
                pw.printf("<span style='float: left; margin-left: 1em;'>Untransformed Resources - %s</span>", this.getType(registeredResource));
                pw.println("</div>");
                pw.println("<table class='nicetable'><tbody>");
                pw.printf("<tr><th>Digest/Priority</th><th>URL</th></tr>", new Object[0]);
                rt = registeredResource.getType();
            }
            pw.printf("<tr><td>%s</td><td>%s</td></tr>", this.getInfo(registeredResource), registeredResource.getURL());
        }
        if (rt != null) {
            pw.println("</tbody></table>");
        }
    }

    public void printConfiguration(PrintWriter pw, String mode) {
        if (!"zip".equals(mode) && !"txt".equals(mode)) {
            return;
        }
        pw.println("Apache Sling OSGi Installer");
        pw.println("===========================");
        InstallationState state = this.installer.getInstallationState();
        pw.println("Active Resources");
        pw.println("----------------");
        String rt = null;
        for (ResourceGroup group : state.getActiveResources()) {
            Resource toActivate = (Resource)group.getResources().get(0);
            if (!toActivate.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType((RegisteredResource)toActivate));
                rt = toActivate.getType();
            }
            pw.printf("- %s: %s, %s, %s%n", this.getEntityId((RegisteredResource)toActivate, group.getAlias()), this.getInfo((RegisteredResource)toActivate), this.getURL(toActivate), toActivate.getState());
        }
        pw.println();
        pw.println("Processed Resources");
        pw.println("-------------------");
        rt = null;
        for (ResourceGroup group : state.getInstalledResources()) {
            List resources = group.getResources();
            if (resources.size() <= 0) continue;
            Iterator iter = resources.iterator();
            Resource first = (Resource)iter.next();
            if (!first.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType((RegisteredResource)first));
                rt = first.getType();
            }
            pw.printf("* %s: %s, %s, %s%n", this.getEntityId((RegisteredResource)first, group.getAlias()), this.getInfo((RegisteredResource)first), this.getURL(first), this.getState(first));
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.excluded") != null) {
                pw.printf("  : %s", first.getAttribute("org.apache.sling.installer.api.resource.install.excluded"));
            }
            if (first.getAttribute("org.apache.sling.installer.api.resource.install.info") != null) {
                pw.printf("  : %s", first.getAttribute("org.apache.sling.installer.api.resource.install.info"));
            }
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                pw.printf("  - %s, %s, %s%n", this.getInfo((RegisteredResource)resource), this.getURL(resource), resource.getState());
            }
        }
        pw.println();
        pw.println("Untransformed Resources");
        pw.println("-----------------------");
        rt = null;
        for (RegisteredResource registeredResource : state.getUntransformedResources()) {
            if (!registeredResource.getType().equals(rt)) {
                pw.printf("%s:%n", this.getType(registeredResource));
                rt = registeredResource.getType();
            }
            pw.printf("- %s, %s%n", this.getInfo(registeredResource), registeredResource.getURL());
        }
    }

    protected void bindInstaller(InfoProvider infoProvider) {
        this.installer = infoProvider;
    }

    protected void unbindInstaller(InfoProvider infoProvider) {
        if (this.installer == infoProvider) {
            this.installer = null;
        }
    }
}

