/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.hc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"hc.name=OSGi Installer Health Check"})
@Designate(ocd=Configuration.class)
public class OsgiInstallerHealthCheck
implements HealthCheck {
    protected static final String HC_NAME = "OSGi Installer Health Check";
    @Reference
    private InfoProvider infoProvider;
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstallerHealthCheck.class);
    private Configuration configuration;
    private Map<String, Version> skipEntityIdsWithVersions;
    private static final String DOCUMENTATION_URL = "https://sling.apache.org/documentation/bundles/osgi-installer.html#health-check";
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Activate
    protected void activate(Configuration configuration) {
        this.configuration = configuration;
        this.skipEntityIdsWithVersions = this.parseEntityIdsWithVersions(configuration.skipEntityIds());
    }

    private Map<String, Version> parseEntityIdsWithVersions(String[] entityIdsAndVersions) throws IllegalArgumentException {
        HashMap<String, Version> entityIdsWithVersions = new HashMap<String, Version>();
        if (entityIdsAndVersions != null) {
            for (String entityIdAndVersion : entityIdsAndVersions) {
                String[] parts = entityIdAndVersion.split(" ", 2);
                String entityId = parts[0];
                Version version = parts.length > 1 ? Version.parseVersion((String)parts[1]) : null;
                entityIdsWithVersions.put(entityId, version);
            }
        }
        return entityIdsWithVersions;
    }

    public Result execute() {
        InstallationState installationState = this.infoProvider.getInstallationState();
        FormattingResultLog hcLog = new FormattingResultLog();
        int numCheckedConfigurationGroups = 0;
        int numCheckedBundleGroups = 0;
        for (ResourceGroup group : installationState.getInstalledResources()) {
            String type;
            switch (type = this.evaluateGroup(group, hcLog)) {
                case "config": {
                    ++numCheckedConfigurationGroups;
                    break;
                }
                case "bundle": {
                    ++numCheckedBundleGroups;
                }
            }
        }
        hcLog.info("Checked {} OSGi bundle and {} configuration groups.", new Object[]{numCheckedBundleGroups, numCheckedConfigurationGroups});
        if (hcLog.getAggregateStatus().ordinal() >= Result.Status.WARN.ordinal()) {
            hcLog.info("Refer to the OSGi installer's documentation page at {} for further details on how to fix those issues.", new Object[]{DOCUMENTATION_URL});
        }
        return new Result((ResultLog)hcLog);
    }

    private String evaluateGroup(ResourceGroup group, FormattingResultLog hcLog) {
        Resource invalidResource = null;
        String resourceType = "";
        boolean isGroupRelevant = false;
        block11: for (Resource resource : group.getResources()) {
            switch (resourceType = resource.getType()) {
                case "config": {
                    if (this.configuration.checkConfigurations()) break;
                    LOG.debug("Skip resource '{}', configuration checks are disabled", (Object)resource.getEntityId());
                    return "";
                }
                case "bundle": {
                    if (this.configuration.checkBundles()) break;
                    LOG.debug("Skip resource '{}', bundle checks are disabled", (Object)resource.getEntityId());
                    return "";
                }
                default: {
                    LOG.debug("Skip resource '{}' as it is neither a bundle nor a configuration but a {}", (Object)resource.getEntityId(), (Object)resourceType);
                    return "";
                }
            }
            if (StringUtils.startsWithAny((String)resource.getURL(), (String[])this.configuration.urlPrefixes())) {
                isGroupRelevant = true;
                switch (resource.getState()) {
                    case IGNORED: 
                    case INSTALL: {
                        if (!this.configuration.allowIgnoredArtifactsInGroup()) {
                            this.reportInvalidResource(resource, resourceType, hcLog);
                            continue block11;
                        }
                        if (invalidResource != null) continue block11;
                        invalidResource = resource;
                        continue block11;
                    }
                }
                if (!this.configuration.allowIgnoredArtifactsInGroup()) continue;
                return resourceType;
            }
            LOG.debug("Skipping resource '{}' as its URL is not starting with any of these prefixes'{}'", (Object)resource, (Object)StringUtils.join((Object[])this.configuration.urlPrefixes(), (String)","));
        }
        if (invalidResource != null && this.configuration.allowIgnoredArtifactsInGroup()) {
            this.reportInvalidResource(invalidResource, resourceType, hcLog);
        }
        return isGroupRelevant ? resourceType : "";
    }

    private void reportInvalidResource(Resource invalidResource, String resourceType, FormattingResultLog hcLog) {
        if (this.skipEntityIdsWithVersions.containsKey(invalidResource.getEntityId())) {
            Version version = this.skipEntityIdsWithVersions.get(invalidResource.getEntityId());
            if (version != null) {
                if (version.equals((Object)invalidResource.getVersion())) {
                    LOG.debug("Skipping not installed resource '{}' as its entity id and version is in the skip list", (Object)invalidResource);
                    return;
                }
            } else {
                LOG.debug("Skipping not installed resource '{}' as its entity id is in the skip list", (Object)invalidResource);
                return;
            }
        }
        if (resourceType.equals("config")) {
            hcLog.critical("The installer state of the OSGi configuration resource '{}' is {}, config might have been manually overwritten!", new Object[]{invalidResource, invalidResource.getState()});
        } else {
            hcLog.critical("The installer state of the OSGi bundle resource '{}' is {}, probably because a later or the same version of that bundle is already installed!", new Object[]{invalidResource, invalidResource.getState()});
        }
    }

    @ObjectClassDefinition(name="OSGi Installer Health Check", description="Checks that all OSGi configurations/bundles are successfully installed by the OSGi Installer (and are not skipped for some reason).")
    protected static @interface Configuration {
        @AttributeDefinition(name="Tags", description="Tags with which this healthcheck is associated")
        public String[] tags() default {"installer", "osgi"};

        @AttributeDefinition(name="URL Prefixes to consider", description="Only those OSGi configurations/bundles whose location are starting with one of the given URL prefixes are checked (whether they are installed correctly). Open /system/console/osgi-installer for a list of valid prefixes.")
        public String[] urlPrefixes() default {"jcrinstall:/apps/"};

        @AttributeDefinition(name="Check Bundles", description="If enabled bundles are checked (restricted to the ones matching one of the prefixes)")
        public boolean checkBundles() default true;

        @AttributeDefinition(name="Check Configurations", description="If enabled configurations are checked (restricted to the ones matching one of the prefixes)")
        public boolean checkConfigurations() default true;

        @AttributeDefinition(name="Allow ignored artifacts in a group", description="If true there is no warning reported for not installed artifacts if at least one artifact in the same group (i.e. with the same entity id) is installed matching one of the configured URL prefixes. Otherwise there is a warning for every ignored artifact.")
        public boolean allowIgnoredArtifactsInGroup() default false;

        @AttributeDefinition(name="Skip entity ids", description="The given entity ids should be skipped for the health check. Each entry has the format '<entity id> [<version>]'.")
        public String[] skipEntityIds();
    }
}

