/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.ConfigNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FileNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FolderNameFilter;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerConfig {
    private final boolean writeBack;
    private final Collection<JcrInstaller.NodeConverter> converters = new ArrayList<JcrInstaller.NodeConverter>();
    private final int maxWatchedFolderDepth;
    private final FolderNameFilter folderNameFilter;
    private final String[] roots;
    private final String newConfigPath;
    private final String pauseScanNodePath;
    private final List<WatchedFolder> watchedFolders = new LinkedList<WatchedFolder>();
    private final Logger logger;

    public InstallerConfig(Logger logger, ComponentContext ctx, Dictionary<?, ?> cfg, SlingSettingsService settings) {
        boolean preSlash;
        this.logger = logger;
        this.writeBack = PropertiesUtil.toBoolean(this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.enable.writeback"), true);
        this.converters.add(new FileNodeConverter());
        this.converters.add(new ConfigNodeConverter());
        Object obj = this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.folder.max.depth");
        if (obj != null) {
            this.maxWatchedFolderDepth = Integer.valueOf(String.valueOf(obj));
            logger.debug("Using configured ({}) folder name max depth '{}'", (Object)"sling.jcrinstall.folder.max.depth", (Object)this.maxWatchedFolderDepth);
        } else {
            this.maxWatchedFolderDepth = 4;
            logger.debug("Using default folder max depth {}, not provided by {}", (Object)this.maxWatchedFolderDepth, (Object)"sling.jcrinstall.folder.max.depth");
        }
        String folderNameRegexp = (String)this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.folder.name.regexp");
        if (folderNameRegexp != null) {
            folderNameRegexp = folderNameRegexp.trim();
            logger.debug("Using configured ({}) folder name regexp '{}'", (Object)"sling.jcrinstall.folder.name.regexp", (Object)folderNameRegexp);
        } else {
            folderNameRegexp = ".*/install$";
            logger.debug("Using default folder name regexp '{}', not provided by {}", (Object)folderNameRegexp, (Object)"sling.jcrinstall.folder.name.regexp");
        }
        this.folderNameFilter = new FolderNameFilter(PropertiesUtil.toStringArray(this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.search.path"), JcrInstaller.DEFAULT_SEARCH_PATH), folderNameRegexp, settings.getRunModes());
        this.roots = this.folderNameFilter.getRootPaths();
        String newCfgPath = PropertiesUtil.toString(this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.new.config.path"), "sling/install");
        boolean postSlash = newCfgPath.endsWith("/");
        if (!postSlash) {
            newCfgPath = newCfgPath.concat("/");
        }
        if (!(preSlash = newCfgPath.startsWith("/"))) {
            newCfgPath = this.folderNameFilter.getRootPaths()[0] + '/' + newCfgPath;
        }
        this.newConfigPath = newCfgPath;
        this.pauseScanNodePath = PropertiesUtil.toString(this.getPropertyValue(logger, ctx, cfg, "sling.jcrinstall.signal.path"), "/system/sling/installer/jcr/pauseInstallation");
    }

    private Object getPropertyValue(Logger logger, ComponentContext ctx, Dictionary<?, ?> oldConfig, String name) {
        String result = null;
        if (oldConfig != null && (result = (String)oldConfig.get(name)) != null) {
            logger.warn("Using configuration value from obsolete configuration with PID {} for property {}. Please merge this configuration into the configuration with the PID {}.", new Object[]{"org.apache.sling.jcr.install.impl.JcrInstaller", name, ctx.getProperties().get("service.pid")});
        }
        if (result == null && (result = ctx.getBundleContext().getProperty(name)) == null) {
            result = ctx.getProperties().get(name);
        }
        return result;
    }

    public String[] getRoots() {
        return this.roots;
    }

    public FolderNameFilter getFolderNameFilter() {
        return this.folderNameFilter;
    }

    public Collection<JcrInstaller.NodeConverter> getConverters() {
        return this.converters;
    }

    public int getMaxWatchedFolderDepth() {
        return this.maxWatchedFolderDepth;
    }

    public String getPauseScanNodePath() {
        return this.pauseScanNodePath;
    }

    public boolean isWriteBack() {
        return this.writeBack;
    }

    public String getNewConfigPath() {
        return this.newConfigPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WatchedFolder> cloneWatchedFolders() {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            return new ArrayList<WatchedFolder>(this.watchedFolders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstallableResource> scanWatchedFolders() throws RepositoryException {
        LinkedList<InstallableResource> resources = new LinkedList<InstallableResource>();
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            for (WatchedFolder f : this.watchedFolders) {
                WatchedFolder.ScanResult r = f.scan();
                this.logger.debug("Startup: {} provides resources {}", (Object)f, r.toAdd);
                resources.addAll(r.toAdd);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkForRemovedWatchedFolders(Session session) throws RepositoryException {
        LinkedList<String> removedResources = new LinkedList<String>();
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            Iterator<WatchedFolder> i = this.watchedFolders.iterator();
            while (i.hasNext()) {
                WatchedFolder wf = i.next();
                this.logger.debug("Item {} exists? {}", (Object)wf.getPath(), (Object)session.itemExists(wf.getPath()));
                if (session.itemExists(wf.getPath())) continue;
                this.logger.info("Deleting {}, path does not exist anymore", (Object)wf);
                removedResources.addAll(wf.scan().toRemove);
                i.remove();
            }
        }
        return removedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchedFolder(WatchedFolder toAdd) {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            WatchedFolder existing = null;
            for (WatchedFolder wf : this.watchedFolders) {
                if (!wf.getPath().equals(toAdd.getPath())) continue;
                existing = wf;
                break;
            }
            if (existing == null) {
                this.watchedFolders.add(toAdd);
                toAdd.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyWatchFolderNeedsScan() {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            for (WatchedFolder wf : this.watchedFolders) {
                if (!wf.needsScan()) continue;
                return true;
            }
        }
        return false;
    }
}

