/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.UpdateResult;
import org.apache.sling.installer.provider.jcr.impl.InstallerConfig;
import org.apache.sling.installer.provider.jcr.impl.JcrUtil;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.apache.sling.installer.provider.jcr.impl.RootFolderListener;
import org.apache.sling.installer.provider.jcr.impl.RootFolderMoveListener;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%jcrinstall.name", description="%jcrinstall.description", immediate=true, metatype=true)
@Properties(value={@Property(name="service.description", value={"Sling JCR Install Service"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="handler.schemes", value={"jcrinstall"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="service.ranking", intValue={100})})
@Service(value={UpdateHandler.class})
public class JcrInstaller
implements UpdateHandler,
ManagedService {
    public static final long RUN_LOOP_DELAY_MSEC = 500L;
    public static final String URL_SCHEME = "jcrinstall";
    public static final String OLD_PID = "org.apache.sling.jcr.install.impl.JcrInstaller";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long[] counters = new long[3];
    public static final int SCAN_FOLDERS_COUNTER = 0;
    public static final int UPDATE_FOLDERS_LIST_COUNTER = 1;
    public static final int RUN_LOOP_COUNTER = 2;
    public static final int COUNTERS_COUNT = 3;
    private static final String NT_FILE = "nt:file";
    private static final String NT_RESOURCE = "nt:resource";
    private static final String PROP_DATA = "jcr:data";
    private static final String PROP_MODIFIED = "jcr:lastModified";
    private static final String PROP_ENC = "jcr:encoding";
    private static final String PROP_MIME = "jcr:mimeType";
    private static final String MIME_TXT = "text/plain";
    private static final String ENCODING = "UTF-8";
    public static final String DEFAULT_FOLDER_NAME_REGEXP = ".*/install$";
    @Property(value={".*/install$"})
    public static final String FOLDER_NAME_REGEXP_PROPERTY = "sling.jcrinstall.folder.name.regexp";
    public static final int DEFAULT_FOLDER_MAX_DEPTH = 4;
    @Property(intValue={4})
    public static final String PROP_INSTALL_FOLDER_MAX_DEPTH = "sling.jcrinstall.folder.max.depth";
    @Property(value={"/libs:100", "/apps:200"}, unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_SEARCH_PATH = "sling.jcrinstall.search.path";
    public static final String[] DEFAULT_SEARCH_PATH = new String[]{"/libs:100", "/apps:200"};
    public static final String DEFAULT_NEW_CONFIG_PATH = "sling/install";
    @Property(value={"sling/install"})
    public static final String PROP_NEW_CONFIG_PATH = "sling.jcrinstall.new.config.path";
    public static final String PAUSE_SCAN_NODE_PATH = "/system/sling/installer/jcr/pauseInstallation";
    @Property(value={"/system/sling/installer/jcr/pauseInstallation"})
    public static final String PROP_SCAN_PROP_PATH = "sling.jcrinstall.signal.path";
    private volatile boolean pauseMessageLogged = false;
    public static final boolean DEFAULT_ENABLE_WRITEBACK = true;
    @Property(boolValue={true})
    public static final String PROP_ENABLE_WRITEBACK = "sling.jcrinstall.enable.writeback";
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settings;
    @Reference
    private OsgiInstaller installer;
    private volatile ComponentContext componentContext;
    private volatile ServiceRegistration managedServiceRef;
    private volatile Dictionary<?, ?> oldConfiguration;
    private final RescanTimer updateFoldersListTimer = new RescanTimer();
    private static final AtomicInteger bgThreadCounter = new AtomicInteger();
    private volatile StoppableThread backgroundThread;

    protected void activate(ComponentContext context) {
        this.componentContext = context;
        this.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", OLD_PID);
        this.managedServiceRef = this.componentContext.getBundleContext().registerService(ManagedService.class.getName(), (Object)this, props);
    }

    private void start() {
        block2: {
            this.logger.info("Activating Apache Sling JCR Installer");
            InstallerConfig cfg = new InstallerConfig(this.logger, this.componentContext, this.oldConfiguration, this.settings);
            try {
                this.backgroundThread = new StoppableThread(cfg);
                this.backgroundThread.start();
            }
            catch (RepositoryException re) {
                this.logger.error("Repository exception during startup - deactivating installer!", (Throwable)re);
                ComponentContext ctx = this.componentContext;
                if (ctx == null) break block2;
                String name = (String)this.componentContext.getProperties().get("component.name");
                ctx.disableComponent(name);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.managedServiceRef != null) {
            this.managedServiceRef.unregister();
            this.managedServiceRef = null;
        }
        this.stop();
        this.componentContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this.logger.info("Deactivating Apache Sling JCR Installer");
        if (this.backgroundThread != null) {
            Object object = this.backgroundThread.lock;
            synchronized (object) {
                this.backgroundThread.active.set(false);
                this.backgroundThread.lock.notify();
            }
            this.logger.debug("Waiting for " + this.backgroundThread.getName() + " Thread to end...");
            this.backgroundThread.shutdown();
            this.backgroundThread = null;
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        boolean restart = this.oldConfiguration == null ? properties != null : true;
        this.oldConfiguration = properties;
        if (restart) {
            try {
                this.stop();
                this.start();
            }
            catch (Exception e) {
                this.logger.error("Error restarting", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPathsToWatch(InstallerConfig cfg, Session session, String rootPath) throws RepositoryException {
        Session s = null;
        try {
            s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            if (!s.itemExists(rootPath) || !s.getItem(rootPath).isNode()) {
                this.logger.info("Bundles root node {} not found, ignored", (Object)rootPath);
            } else {
                this.logger.debug("Bundles root node {} found, looking for bundle folders inside it", (Object)rootPath);
                Node n = (Node)s.getItem(rootPath);
                this.findPathsUnderNode(cfg, session, n);
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    void findPathsUnderNode(InstallerConfig cfg, Session session, Node n) throws RepositoryException {
        int depth;
        String path = n.getPath();
        int priority = cfg.getFolderNameFilter().getPriority(path);
        if (priority > 0) {
            cfg.addWatchedFolder(new WatchedFolder(session, path, priority, cfg.getConverters()));
        }
        if ((depth = path.split("/").length) > cfg.getMaxWatchedFolderDepth()) {
            this.logger.debug("Not recursing into {} due to maxWatchedFolderDepth={}", (Object)path, (Object)cfg.getMaxWatchedFolderDepth());
            return;
        }
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            this.findPathsUnderNode(cfg, session, it.nextNode());
        }
    }

    private List<String> updateFoldersList(InstallerConfig cfg, Session session) throws Exception {
        this.logger.debug("Updating folder list.");
        for (String root : cfg.getRoots()) {
            this.findPathsToWatch(cfg, session, root);
        }
        List<String> removedResources = cfg.checkForRemovedWatchedFolders(session);
        return removedResources;
    }

    InstallerConfig getConfiguration() {
        InstallerConfig cfg = null;
        StoppableThread st = this.backgroundThread;
        if (st != null) {
            cfg = st.getConfiguration();
        }
        return cfg;
    }

    Session getSession() {
        return this.backgroundThread.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOneCycle(InstallerConfig cfg, Session session) {
        this.logger.debug("Running watch cycle.");
        try {
            boolean didRefresh = false;
            if (cfg.anyWatchFolderNeedsScan()) {
                session.refresh(false);
                didRefresh = true;
                if (this.scanningIsPaused(cfg, session)) {
                    if (!this.pauseMessageLogged) {
                        this.logger.info("Detected signal for pausing the JCR Provider i.e. child nodes found under path {}. JCR Provider scanning would not be performed", (Object)cfg.getPauseScanNodePath());
                        this.pauseMessageLogged = true;
                    }
                    return;
                }
                if (this.pauseMessageLogged) {
                    this.pauseMessageLogged = false;
                }
            }
            boolean scanWf = false;
            for (WatchedFolder wf : cfg.cloneWatchedFolders()) {
                if (!wf.needsScan()) continue;
                scanWf = true;
                if (!didRefresh) {
                    session.refresh(false);
                    didRefresh = true;
                }
                this.counters[0] = this.counters[0] + 1L;
                WatchedFolder.ScanResult sr = wf.scan();
                boolean toDo = false;
                if (sr.toAdd.size() > 0) {
                    this.logger.info("Registering resource with OSGi installer: {}", sr.toAdd);
                    toDo = true;
                }
                if (sr.toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer: {}", sr.toRemove);
                    toDo = true;
                }
                if (!toDo) continue;
                this.installer.updateResources(URL_SCHEME, sr.toAdd.toArray(new InstallableResource[sr.toAdd.size()]), sr.toRemove.toArray(new String[sr.toRemove.size()]));
            }
            if (scanWf || this.updateFoldersListTimer.expired()) {
                if (!didRefresh) {
                    session.refresh(false);
                    didRefresh = true;
                }
                this.updateFoldersListTimer.reset();
                this.counters[1] = this.counters[1] + 1L;
                List<String> toRemove = this.updateFoldersList(cfg, session);
                if (toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer (folder deleted): {}", toRemove);
                    this.installer.updateResources(URL_SCHEME, null, toRemove.toArray(new String[toRemove.size()]));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception in runOneCycle()", (Throwable)e);
        }
        if (this.backgroundThread.active.get()) {
            Object object = this.backgroundThread.lock;
            synchronized (object) {
                try {
                    this.backgroundThread.lock.wait(500L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.counters[2] = this.counters[2] + 1L;
    }

    boolean scanningIsPaused(InstallerConfig cfg, Session session) throws RepositoryException {
        if (session.nodeExists(cfg.getPauseScanNodePath())) {
            Node node = session.getNode(cfg.getPauseScanNodePath());
            boolean result = node.hasNodes();
            if (result && this.logger.isDebugEnabled()) {
                ArrayList<String> nodeNames = new ArrayList<String>();
                NodeIterator childItr = node.getNodes();
                while (childItr.hasNext()) {
                    nodeNames.add(childItr.nextNode().getName());
                }
                this.logger.debug("Found child nodes {} at path {}. Scanning would be paused", nodeNames, (Object)cfg.getPauseScanNodePath());
            }
            return result;
        }
        return false;
    }

    long[] getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult handleRemoval(String resourceType, String id, String url) {
        InstallerConfig cfg = this.getConfiguration();
        if (cfg == null || !cfg.isWriteBack()) {
            return null;
        }
        int pos = url.indexOf(58);
        String path = url.substring(pos + 1);
        if (!url.startsWith(URL_SCHEME)) {
            this.logger.debug("Not removing unmanaged artifact from repository: {}", (Object)url);
            return null;
        }
        String[] rootPaths = cfg.getFolderNameFilter().getRootPaths();
        String systemConfigRootPath = rootPaths[rootPaths.length - 1];
        if (path.startsWith(systemConfigRootPath)) {
            this.logger.debug("Not removing system artifact from repository at {}", (Object)path);
            return null;
        }
        boolean found = false;
        int lastSlash = path.lastIndexOf(47);
        while (!found && lastSlash > 1) {
            String prefix = path.substring(0, lastSlash);
            if (cfg.getFolderNameFilter().getPriority(prefix) != -1) {
                found = true;
                continue;
            }
            lastSlash = prefix.lastIndexOf(47);
        }
        if (found) {
            this.logger.debug("Removing artifact at {}", (Object)path);
            Session session = null;
            try {
                session = this.repository.loginAdministrative(null);
                if (session.itemExists(path)) {
                    session.getItem(path).remove();
                    session.save();
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to remove resource from " + path, (Throwable)re);
                UpdateResult updateResult = null;
                return updateResult;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            return new UpdateResult(url);
        }
        this.logger.debug("Not removing unmanaged artifact from repository at {}", (Object)path);
        return null;
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, null, dict, attributes);
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, is, null, attributes);
    }

    private String getPathWithHighestPrio(InstallerConfig cfg, String oldPath) {
        String path;
        String rootPath = cfg.getFolderNameFilter().getRootPaths()[0] + '/';
        if (!oldPath.startsWith(rootPath)) {
            int slashPos = oldPath.indexOf(47, 1);
            path = rootPath + oldPath.substring(slashPos + 1);
        } else {
            path = oldPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        InstallerConfig cfg = this.getConfiguration();
        if (cfg == null || !cfg.isWriteBack()) {
            return null;
        }
        if (!resourceType.equals("config")) {
            return null;
        }
        Session session = null;
        try {
            String path;
            int lastSlash;
            session = this.repository.loginAdministrative(null);
            boolean resourceIsMoved = true;
            if (url != null) {
                String nodePath;
                int pos = url.indexOf(58);
                String oldPath = url.substring(pos + 1);
                if (url.startsWith("jcrinstall:")) {
                    nodePath = this.getPathWithHighestPrio(cfg, oldPath);
                } else {
                    lastSlash = url.lastIndexOf(47);
                    int lastPos = url.lastIndexOf(46);
                    String name = lastSlash == -1 || lastPos < lastSlash ? id : url.substring(lastSlash + 1, lastPos);
                    nodePath = this.getPathWithHighestPrio(cfg, cfg.getNewConfigPath() + name + ".config");
                }
                if (!nodePath.endsWith(".config")) {
                    if (session.itemExists(nodePath)) {
                        session.getItem(nodePath).remove();
                    }
                    path = nodePath + ".config";
                } else {
                    path = nodePath;
                }
                resourceIsMoved = nodePath.equals(oldPath);
                this.logger.debug("Update of {} at {}", (Object)resourceType, (Object)path);
            } else {
                String name = attributes != null && attributes.get("resource.uri.hint") != null ? (String)attributes.get("resource.uri.hint") : id;
                path = cfg.getNewConfigPath() + name + ".config";
                this.logger.debug("Add of {} at {}", (Object)resourceType, (Object)path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("# Configuration created by Apache Sling JCR Installer\n".getBytes(ENCODING));
            ConfigurationHandler.write(baos, dict);
            baos.close();
            JcrUtil.createPath(session, path, NT_FILE);
            Node dataNode = JcrUtil.createPath(session, path + "/jcr:content", NT_RESOURCE);
            dataNode.setProperty(PROP_DATA, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            dataNode.setProperty(PROP_MODIFIED, Calendar.getInstance());
            dataNode.setProperty(PROP_ENC, ENCODING);
            dataNode.setProperty(PROP_MIME, MIME_TXT);
            session.save();
            UpdateResult result = new UpdateResult("jcrinstall:" + path);
            lastSlash = path.lastIndexOf(47);
            String parentPath = path.substring(0, lastSlash);
            result.setPriority(Integer.valueOf(cfg.getFolderNameFilter().getPriority(parentPath)));
            result.setResourceIsMoved(resourceIsMoved);
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)re);
            UpdateResult updateResult = null;
            return updateResult;
        }
        catch (IOException e) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)e);
            UpdateResult updateResult = null;
            return updateResult;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindInstaller(OsgiInstaller osgiInstaller) {
        this.installer = osgiInstaller;
    }

    protected void unbindInstaller(OsgiInstaller osgiInstaller) {
        if (this.installer == osgiInstaller) {
            this.installer = null;
        }
    }

    class StoppableThread
    extends Thread
    implements EventListener {
        final Object lock = new Object();
        final AtomicBoolean active = new AtomicBoolean(false);
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final InstallerConfig cfg;
        private final List<RootFolderListener> listeners = new LinkedList<RootFolderListener>();
        private volatile RootFolderMoveListener moveEventListener;
        private volatile Session session;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoppableThread(InstallerConfig cfg) throws RepositoryException {
            this.cfg = cfg;
            this.setName("JcrInstaller." + String.valueOf(bgThreadCounter.incrementAndGet()));
            this.setDaemon(true);
            try {
                this.session = JcrInstaller.this.repository.loginAdministrative(JcrInstaller.this.repository.getDefaultWorkspace());
                for (String path : cfg.getRoots()) {
                    this.listeners.add(new RootFolderListener(this.session, path, JcrInstaller.this.updateFoldersListTimer, cfg));
                    JcrInstaller.this.logger.debug("Configured root folder: {}", (Object)path);
                }
                this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/", false, null, null, true);
                if (cfg.getRoots() != null && cfg.getRoots().length > 0) {
                    this.moveEventListener = new RootFolderMoveListener(this.session, cfg.getRoots(), JcrInstaller.this.updateFoldersListTimer);
                }
                JcrInstaller.this.logger.debug("Watching for node events on / to detect removal/add of our root folders");
                for (String root : cfg.getRoots()) {
                    JcrInstaller.this.findPathsToWatch(cfg, this.session, root);
                }
                List<InstallableResource> resources = cfg.scanWatchedFolders();
                JcrInstaller.this.logger.debug("Registering {} resources with OSGi installer: {}", (Object)resources.size(), resources);
                JcrInstaller.this.installer.registerResources(JcrInstaller.URL_SCHEME, resources.toArray(new InstallableResource[resources.size()]));
                this.active.set(true);
            }
            finally {
                if (!this.active.get()) {
                    this.shutdown();
                }
            }
        }

        public void shutdown() {
            while (this.running.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                if (this.session != null) {
                    for (RootFolderListener wfc : this.listeners) {
                        wfc.cleanup(this.session);
                    }
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                    if (this.moveEventListener != null) {
                        this.moveEventListener.cleanup(this.session);
                        this.moveEventListener = null;
                    }
                }
            }
            catch (RepositoryException e) {
                JcrInstaller.this.logger.warn("Exception in stop()", (Throwable)e);
            }
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
            this.listeners.clear();
        }

        public void onEvent(EventIterator it) {
            try {
                while (it.hasNext()) {
                    Event e = it.nextEvent();
                    JcrInstaller.this.logger.debug("Got event {}", (Object)e);
                    this.checkChanges(e.getPath());
                }
            }
            catch (RepositoryException re) {
                JcrInstaller.this.logger.warn("RepositoryException in onEvent", (Throwable)re);
            }
        }

        private void checkChanges(String path) {
            for (String root : this.cfg.getRoots()) {
                if (!path.startsWith(root)) continue;
                JcrInstaller.this.logger.info("Got event for root {}, scheduling scanning of new folders", (Object)root);
                JcrInstaller.this.updateFoldersListTimer.scheduleScan();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            JcrInstaller.this.logger.info("Background thread {} starting", (Object)Thread.currentThread().getName());
            while (this.active.get()) {
                this.running.set(true);
                try {
                    JcrInstaller.this.runOneCycle(this.cfg, this.session);
                }
                finally {
                    this.running.set(false);
                }
            }
            JcrInstaller.this.logger.info("Background thread {} done", (Object)Thread.currentThread().getName());
            ((JcrInstaller)JcrInstaller.this).counters[2] = -1L;
        }

        public InstallerConfig getConfiguration() {
            return this.cfg;
        }
    }

    static interface NodeConverter {
        public InstallableResource convertNode(Node var1, int var2) throws RepositoryException;
    }
}

