/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.UpdateResult;
import org.apache.sling.installer.provider.jcr.impl.ConfigNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FileNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FolderNameFilter;
import org.apache.sling.installer.provider.jcr.impl.JcrUtil;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.apache.sling.installer.provider.jcr.impl.RootFolderListener;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%jcrinstall.name", description="%jcrinstall.description", immediate=true, metatype=true)
@Properties(value={@Property(name="service.description", value={"Sling JCR Install Service"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="handler.schemes", value={"jcrinstall"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="service.ranking", intValue={100})})
@Service(value={UpdateHandler.class})
public class JcrInstaller
implements EventListener,
UpdateHandler,
ManagedService {
    public static final long RUN_LOOP_DELAY_MSEC = 500L;
    public static final String URL_SCHEME = "jcrinstall";
    private static final String OLD_PID = "org.apache.sling.jcr.install.impl.JcrInstaller";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long[] counters = new long[3];
    public static final int SCAN_FOLDERS_COUNTER = 0;
    public static final int UPDATE_FOLDERS_LIST_COUNTER = 1;
    public static final int RUN_LOOP_COUNTER = 2;
    public static final int COUNTERS_COUNT = 3;
    private static final String NT_FILE = "nt:file";
    private static final String NT_RESOURCE = "nt:resource";
    private static final String PROP_DATA = "jcr:data";
    private static final String PROP_MODIFIED = "jcr:lastModified";
    private static final String PROP_ENC = "jcr:encoding";
    private static final String PROP_MIME = "jcr:mimeType";
    private static final String MIME_TXT = "text/plain";
    private static final String ENCODING = "UTF-8";
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settings;
    @Reference
    private OsgiInstaller installer;
    public static final String DEFAULT_FOLDER_NAME_REGEXP = ".*/install$";
    @Property(value={".*/install$"})
    public static final String FOLDER_NAME_REGEXP_PROPERTY = "sling.jcrinstall.folder.name.regexp";
    public static final int DEFAULT_FOLDER_MAX_DEPTH = 4;
    @Property(intValue={4})
    public static final String PROP_INSTALL_FOLDER_MAX_DEPTH = "sling.jcrinstall.folder.max.depth";
    @Property(value={"/libs:100", "/apps:200"}, unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_SEARCH_PATH = "sling.jcrinstall.search.path";
    public static final String[] DEFAULT_SEARCH_PATH = new String[]{"/libs:100", "/apps:200"};
    private int maxWatchedFolderDepth;
    private FolderNameFilter folderNameFilter;
    private List<WatchedFolder> watchedFolders;
    private Session session;
    private String[] roots;
    private ComponentContext componentContext;
    private ServiceRegistration managedServiceRef;
    private Dictionary<?, ?> oldConfiguration;
    private static final String DEFAULT_NEW_CONFIG_PATH = "sling/install";
    @Property(value={"sling/install"})
    private static final String PROP_NEW_CONFIG_PATH = "sling.jcrinstall.new.config.path";
    private String newConfigPath;
    public static final String PAUSE_SCAN_NODE_PATH = "/system/sling/installer/jcr/pauseInstallation";
    @Property(value={"/system/sling/installer/jcr/pauseInstallation"})
    private static final String PROP_SCAN_PROP_PATH = "sling.jcrinstall.signal.path";
    private String pauseScanNodePath;
    private volatile boolean pauseMessageLogged = false;
    private static final boolean DEFAULT_ENABLE_WRITEBACK = true;
    @Property(boolValue={true})
    private static final String PROP_ENABLE_WRITEBACK = "sling.jcrinstall.enable.writeback";
    private boolean writeBack;
    private EventListener moveEventListener;
    private final Collection<NodeConverter> converters = new ArrayList<NodeConverter>();
    private final List<RootFolderListener> listeners = new LinkedList<RootFolderListener>();
    private final RescanTimer updateFoldersListTimer = new RescanTimer();
    static int bgThreadCounter;
    private StoppableThread backgroundThread;

    protected void activate(ComponentContext context) {
        if (this.backgroundThread != null) {
            throw new IllegalStateException("Expected backgroundThread to be null in activate()");
        }
        this.componentContext = context;
        this.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", OLD_PID);
        this.managedServiceRef = this.componentContext.getBundleContext().registerService(ManagedService.class.getName(), (Object)this, props);
    }

    private void start() {
        boolean preSlash;
        this.logger.info("Activating Apache Sling JCR Installer");
        this.writeBack = PropertiesUtil.toBoolean(this.getPropertyValue(PROP_ENABLE_WRITEBACK), true);
        this.converters.add(new FileNodeConverter());
        this.converters.add(new ConfigNodeConverter());
        Object obj = this.getPropertyValue(PROP_INSTALL_FOLDER_MAX_DEPTH);
        if (obj != null) {
            this.maxWatchedFolderDepth = Integer.valueOf(String.valueOf(obj));
            this.logger.debug("Using configured ({}) folder name max depth '{}'", (Object)PROP_INSTALL_FOLDER_MAX_DEPTH, (Object)this.maxWatchedFolderDepth);
        } else {
            this.maxWatchedFolderDepth = 4;
            this.logger.debug("Using default folder max depth {}, not provided by {}", (Object)this.maxWatchedFolderDepth, (Object)PROP_INSTALL_FOLDER_MAX_DEPTH);
        }
        String folderNameRegexp = (String)this.getPropertyValue(FOLDER_NAME_REGEXP_PROPERTY);
        if (folderNameRegexp != null) {
            folderNameRegexp = folderNameRegexp.trim();
            this.logger.debug("Using configured ({}) folder name regexp '{}'", (Object)FOLDER_NAME_REGEXP_PROPERTY, (Object)folderNameRegexp);
        } else {
            folderNameRegexp = DEFAULT_FOLDER_NAME_REGEXP;
            this.logger.debug("Using default folder name regexp '{}', not provided by {}", (Object)folderNameRegexp, (Object)FOLDER_NAME_REGEXP_PROPERTY);
        }
        this.folderNameFilter = new FolderNameFilter(PropertiesUtil.toStringArray(this.getPropertyValue(PROP_SEARCH_PATH), DEFAULT_SEARCH_PATH), folderNameRegexp, this.settings.getRunModes());
        this.roots = this.folderNameFilter.getRootPaths();
        this.newConfigPath = PropertiesUtil.toString(this.getPropertyValue(PROP_NEW_CONFIG_PATH), DEFAULT_NEW_CONFIG_PATH);
        boolean postSlash = this.newConfigPath.endsWith("/");
        if (!postSlash) {
            this.newConfigPath = this.newConfigPath.concat("/");
        }
        if (!(preSlash = this.newConfigPath.startsWith("/"))) {
            this.newConfigPath = this.folderNameFilter.getRootPaths()[0] + '/' + this.newConfigPath;
        }
        this.pauseScanNodePath = PropertiesUtil.toString(this.getPropertyValue(PROP_SCAN_PROP_PATH), PAUSE_SCAN_NODE_PATH);
        this.backgroundThread = new StoppableThread();
        this.backgroundThread.start();
    }

    protected void deactivate(ComponentContext context) {
        if (this.managedServiceRef != null) {
            this.managedServiceRef.unregister();
            this.managedServiceRef = null;
        }
        this.stop();
        this.componentContext = null;
    }

    private void stop() {
        this.logger.info("Deactivating Apache Sling JCR Installer");
        long timeout = 30000L;
        this.backgroundThread.active = false;
        this.logger.debug("Waiting for " + this.backgroundThread.getName() + " Thread to end...");
        this.backgroundThread.interrupt();
        try {
            this.backgroundThread.join(30000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        this.backgroundThread = null;
        this.folderNameFilter = null;
        this.watchedFolders = null;
        this.converters.clear();
        try {
            if (this.session != null) {
                for (RootFolderListener wfc : this.listeners) {
                    wfc.cleanup(this.session);
                }
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                if (this.moveEventListener != null) {
                    this.session.getWorkspace().getObservationManager().removeEventListener(this.moveEventListener);
                    this.moveEventListener = null;
                }
            }
        }
        catch (RepositoryException e) {
            this.logger.warn("Exception in stop()", (Throwable)e);
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.listeners.clear();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        boolean restart = this.oldConfiguration == null ? properties != null : true;
        this.oldConfiguration = properties;
        if (restart) {
            try {
                this.stop();
                this.start();
            }
            catch (Exception e) {
                this.logger.error("Error restarting", (Throwable)e);
            }
        }
    }

    protected Object getPropertyValue(String name) {
        Dictionary<?, ?> oldConfig = this.oldConfiguration;
        String result = null;
        if (oldConfig != null && (result = (String)oldConfig.get(name)) != null) {
            this.logger.warn("Using configuration value from obsolete configuration with PID {} for property {}. Please merge this configuration into the configuration with the PID {}.", new Object[]{OLD_PID, name, this.componentContext.getProperties().get("service.pid")});
        }
        if (result == null && (result = this.componentContext.getBundleContext().getProperty(name)) == null) {
            result = this.componentContext.getProperties().get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPathsToWatch(String rootPath, List<WatchedFolder> result) throws RepositoryException {
        Session s = null;
        try {
            s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            if (!s.itemExists(rootPath) || !s.getItem(rootPath).isNode()) {
                this.logger.info("Bundles root node {} not found, ignored", (Object)rootPath);
            } else {
                this.logger.debug("Bundles root node {} found, looking for bundle folders inside it", (Object)rootPath);
                Node n = (Node)s.getItem(rootPath);
                this.findPathsUnderNode(n, result);
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    void findPathsUnderNode(Node n, List<WatchedFolder> result) throws RepositoryException {
        int depth;
        String path = n.getPath();
        int priority = this.folderNameFilter.getPriority(path);
        if (priority > 0) {
            result.add(new WatchedFolder(this.session, path, priority, this.converters));
        }
        if ((depth = path.split("/").length) > this.maxWatchedFolderDepth) {
            this.logger.debug("Not recursing into {} due to maxWatchedFolderDepth={}", (Object)path, (Object)this.maxWatchedFolderDepth);
            return;
        }
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            this.findPathsUnderNode(it.nextNode(), result);
        }
    }

    private void addWatchedFolder(WatchedFolder toAdd) throws RepositoryException {
        WatchedFolder existing = null;
        for (WatchedFolder wf : this.watchedFolders) {
            if (!wf.getPath().equals(toAdd.getPath())) continue;
            existing = wf;
            break;
        }
        if (existing == null) {
            toAdd.start();
            this.watchedFolders.add(toAdd);
        }
    }

    private List<String> updateFoldersList() throws Exception {
        this.logger.debug("Updating folder list.");
        LinkedList<String> result = new LinkedList<String>();
        ArrayList<WatchedFolder> newFolders = new ArrayList<WatchedFolder>();
        for (String root : this.roots) {
            this.findPathsToWatch(root, newFolders);
        }
        for (WatchedFolder wf : newFolders) {
            this.addWatchedFolder(wf);
        }
        ArrayList<WatchedFolder> toRemove = new ArrayList<WatchedFolder>();
        for (WatchedFolder wf : this.watchedFolders) {
            this.logger.debug("Item {} exists? {}", (Object)wf.getPath(), (Object)this.session.itemExists(wf.getPath()));
            if (this.session.itemExists(wf.getPath())) continue;
            result.addAll(wf.scan().toRemove);
            wf.stop();
            toRemove.add(wf);
        }
        for (WatchedFolder wf : toRemove) {
            this.logger.info("Deleting {}, path does not exist anymore", (Object)wf);
            this.watchedFolders.remove(wf);
        }
        return result;
    }

    private void checkChanges(String path) {
        for (String root : this.roots) {
            if (!path.startsWith(root)) continue;
            this.logger.info("Got event for root {}, scheduling scanning of new folders", (Object)root);
            this.updateFoldersListTimer.scheduleScan();
        }
    }

    public void onEvent(EventIterator it) {
        try {
            while (it.hasNext()) {
                Event e = it.nextEvent();
                this.logger.debug("Got event {}", (Object)e);
                this.checkChanges(e.getPath());
            }
        }
        catch (RepositoryException re) {
            this.logger.warn("RepositoryException in onEvent", (Throwable)re);
        }
    }

    public void runOneCycle() {
        this.logger.debug("Running watch cycle.");
        try {
            boolean didRefresh = false;
            if (this.anyWatchFolderNeedsScan()) {
                this.session.refresh(false);
                didRefresh = true;
                if (this.scanningIsPaused()) {
                    if (!this.pauseMessageLogged) {
                        this.logger.info("Detected signal for pausing the JCR Provider i.e. child nodes found under path {}. JCR Provider scanning would not be performed", (Object)this.pauseScanNodePath);
                        this.pauseMessageLogged = true;
                    }
                    return;
                }
                if (this.pauseMessageLogged) {
                    this.pauseMessageLogged = false;
                }
            }
            boolean scanWf = false;
            for (WatchedFolder wf : this.watchedFolders) {
                if (!wf.needsScan()) continue;
                scanWf = true;
                if (!didRefresh) {
                    this.session.refresh(false);
                    didRefresh = true;
                }
                this.counters[0] = this.counters[0] + 1L;
                WatchedFolder.ScanResult sr = wf.scan();
                boolean toDo = false;
                if (sr.toAdd.size() > 0) {
                    this.logger.info("Registering resource with OSGi installer: {}", sr.toAdd);
                    toDo = true;
                }
                if (sr.toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer: {}", sr.toRemove);
                    toDo = true;
                }
                if (!toDo) continue;
                this.installer.updateResources(URL_SCHEME, sr.toAdd.toArray(new InstallableResource[sr.toAdd.size()]), sr.toRemove.toArray(new String[sr.toRemove.size()]));
            }
            if (scanWf || this.updateFoldersListTimer.expired()) {
                if (!didRefresh) {
                    this.session.refresh(false);
                    didRefresh = true;
                }
                this.updateFoldersListTimer.reset();
                this.counters[1] = this.counters[1] + 1L;
                List<String> toRemove = this.updateFoldersList();
                if (toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer (folder deleted): {}", toRemove);
                    this.installer.updateResources(URL_SCHEME, null, toRemove.toArray(new String[toRemove.size()]));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception in runOneCycle()", (Throwable)e);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.counters[2] = this.counters[2] + 1L;
    }

    boolean scanningIsPaused() throws RepositoryException {
        if (this.session.nodeExists(this.pauseScanNodePath)) {
            Node node = this.session.getNode(this.pauseScanNodePath);
            boolean result = node.hasNodes();
            if (result && this.logger.isDebugEnabled()) {
                ArrayList<String> nodeNames = new ArrayList<String>();
                NodeIterator childItr = node.getNodes();
                while (childItr.hasNext()) {
                    nodeNames.add(childItr.nextNode().getName());
                }
                this.logger.debug("Found child nodes {} at path {}. Scanning would be paused", nodeNames, (Object)this.pauseScanNodePath);
            }
            return result;
        }
        return false;
    }

    private boolean anyWatchFolderNeedsScan() {
        for (WatchedFolder wf : this.watchedFolders) {
            if (!wf.needsScan()) continue;
            return true;
        }
        return false;
    }

    long[] getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult handleRemoval(String resourceType, String id, String url) {
        if (!this.writeBack) {
            return null;
        }
        int pos = url.indexOf(58);
        String path = url.substring(pos + 1);
        if (!url.startsWith(URL_SCHEME)) {
            this.logger.debug("Not removing unmanaged artifact from repository: {}", (Object)url);
            return null;
        }
        String[] rootPaths = this.folderNameFilter.getRootPaths();
        String systemConfigRootPath = rootPaths[rootPaths.length - 1];
        if (path.startsWith(systemConfigRootPath)) {
            this.logger.debug("Not removing system artifact from repository at {}", (Object)path);
            return null;
        }
        boolean found = false;
        int lastSlash = path.lastIndexOf(47);
        while (!found && lastSlash > 1) {
            String prefix = path.substring(0, lastSlash);
            if (this.folderNameFilter.getPriority(prefix) != -1) {
                found = true;
                continue;
            }
            lastSlash = prefix.lastIndexOf(47);
        }
        if (found) {
            this.logger.debug("Removing artifact at {}", (Object)path);
            Session session = null;
            try {
                session = this.repository.loginAdministrative(null);
                if (session.itemExists(path)) {
                    session.getItem(path).remove();
                    session.save();
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to remove resource from " + path, (Throwable)re);
                UpdateResult updateResult = null;
                return updateResult;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            return new UpdateResult(url);
        }
        this.logger.debug("Not removing unmanaged artifact from repository at {}", (Object)path);
        return null;
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, null, dict, attributes);
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, is, null, attributes);
    }

    private String getPathWithHighestPrio(String oldPath) {
        String path;
        String rootPath = this.folderNameFilter.getRootPaths()[0] + '/';
        if (!oldPath.startsWith(rootPath)) {
            int slashPos = oldPath.indexOf(47, 1);
            path = rootPath + oldPath.substring(slashPos + 1);
        } else {
            path = oldPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        if (!this.writeBack) {
            return null;
        }
        if (!resourceType.equals("config")) {
            return null;
        }
        Session session = null;
        try {
            String path;
            int lastSlash;
            session = this.repository.loginAdministrative(null);
            boolean resourceIsMoved = true;
            if (url != null) {
                String nodePath;
                int pos = url.indexOf(58);
                String oldPath = url.substring(pos + 1);
                if (url.startsWith("jcrinstall:")) {
                    nodePath = this.getPathWithHighestPrio(oldPath);
                } else {
                    lastSlash = url.lastIndexOf(47);
                    int lastPos = url.lastIndexOf(46);
                    String name = lastSlash == -1 || lastPos < lastSlash ? id : url.substring(lastSlash + 1, lastPos);
                    nodePath = this.getPathWithHighestPrio(this.newConfigPath + name + ".config");
                }
                if (!nodePath.endsWith(".config")) {
                    if (session.itemExists(nodePath)) {
                        session.getItem(nodePath).remove();
                    }
                    path = nodePath + ".config";
                } else {
                    path = nodePath;
                }
                resourceIsMoved = nodePath.equals(oldPath);
                this.logger.debug("Update of {} at {}", (Object)resourceType, (Object)path);
            } else {
                String name = attributes != null && attributes.get("resource.uri.hint") != null ? (String)attributes.get("resource.uri.hint") : id;
                path = this.newConfigPath + name + ".config";
                this.logger.debug("Add of {} at {}", (Object)resourceType, (Object)path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("# Configuration created by Apache Sling JCR Installer\n".getBytes(ENCODING));
            ConfigurationHandler.write(baos, dict);
            baos.close();
            JcrUtil.createPath(session, path, NT_FILE);
            Node dataNode = JcrUtil.createPath(session, path + "/jcr:content", NT_RESOURCE);
            dataNode.setProperty(PROP_DATA, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            dataNode.setProperty(PROP_MODIFIED, Calendar.getInstance());
            dataNode.setProperty(PROP_ENC, ENCODING);
            dataNode.setProperty(PROP_MIME, MIME_TXT);
            session.save();
            UpdateResult result = new UpdateResult("jcrinstall:" + path);
            lastSlash = path.lastIndexOf(47);
            String parentPath = path.substring(0, lastSlash);
            result.setPriority(Integer.valueOf(this.folderNameFilter.getPriority(parentPath)));
            result.setResourceIsMoved(resourceIsMoved);
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)re);
            UpdateResult updateResult = null;
            return updateResult;
        }
        catch (IOException e) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)e);
            UpdateResult updateResult = null;
            return updateResult;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindInstaller(OsgiInstaller osgiInstaller) {
        this.installer = osgiInstaller;
    }

    protected void unbindInstaller(OsgiInstaller osgiInstaller) {
        if (this.installer == osgiInstaller) {
            this.installer = null;
        }
    }

    class StoppableThread
    extends Thread {
        boolean active = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoppableThread() {
            Class<JcrInstaller> clazz = JcrInstaller.class;
            synchronized (JcrInstaller.class) {
                this.setName("JcrInstaller." + ++bgThreadCounter);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.setDaemon(true);
                return;
            }
        }

        public final void run() {
            block6: {
                JcrInstaller.this.logger.info("Background thread {} starting", (Object)Thread.currentThread().getName());
                try {
                    JcrInstaller.this.session = JcrInstaller.this.repository.loginAdministrative(JcrInstaller.this.repository.getDefaultWorkspace());
                    for (String path : JcrInstaller.this.roots) {
                        JcrInstaller.this.listeners.add(new RootFolderListener(JcrInstaller.this.session, JcrInstaller.this.folderNameFilter, path, JcrInstaller.this.updateFoldersListTimer));
                        JcrInstaller.this.logger.debug("Configured root folder: {}", (Object)path);
                    }
                    JcrInstaller.this.session.getWorkspace().getObservationManager().addEventListener((EventListener)JcrInstaller.this, 3, "/", false, null, null, true);
                    JcrInstaller.this.moveEventListener = new EventListener(){

                        public void onEvent(EventIterator events) {
                            try {
                                while (events.hasNext()) {
                                    Event e = events.nextEvent();
                                    JcrInstaller.this.checkChanges(e.getIdentifier());
                                    JcrInstaller.this.checkChanges(e.getPath());
                                }
                            }
                            catch (RepositoryException re) {
                                JcrInstaller.this.logger.warn("RepositoryException in onEvent", (Throwable)re);
                            }
                        }
                    };
                    JcrInstaller.this.session.getWorkspace().getObservationManager().addEventListener(JcrInstaller.this.moveEventListener, 32, "/", true, null, null, true);
                    JcrInstaller.this.logger.debug("Watching for node events on / to detect removal/add of our root folders");
                    JcrInstaller.this.watchedFolders = new LinkedList();
                    for (String root : JcrInstaller.this.roots) {
                        JcrInstaller.this.findPathsToWatch(root, JcrInstaller.this.watchedFolders);
                    }
                    LinkedList<InstallableResource> resources = new LinkedList<InstallableResource>();
                    for (WatchedFolder f : JcrInstaller.this.watchedFolders) {
                        f.start();
                        WatchedFolder.ScanResult r = f.scan();
                        JcrInstaller.this.logger.debug("Startup: {} provides resources {}", (Object)f, r.toAdd);
                        resources.addAll(r.toAdd);
                    }
                    JcrInstaller.this.logger.debug("Registering {} resources with OSGi installer: {}", (Object)resources.size(), resources);
                    JcrInstaller.this.installer.registerResources(JcrInstaller.URL_SCHEME, resources.toArray(new InstallableResource[resources.size()]));
                }
                catch (RepositoryException re) {
                    JcrInstaller.this.logger.error("Repository exception during startup - deactivating installer!", (Throwable)re);
                    this.active = false;
                    ComponentContext ctx = JcrInstaller.this.componentContext;
                    if (ctx == null) break block6;
                    String name = (String)JcrInstaller.this.componentContext.getProperties().get("component.name");
                    ctx.disableComponent(name);
                }
            }
            while (this.active) {
                JcrInstaller.this.runOneCycle();
            }
            JcrInstaller.this.logger.info("Background thread {} done", (Object)Thread.currentThread().getName());
            ((JcrInstaller)JcrInstaller.this).counters[2] = -1L;
        }
    }

    static interface NodeConverter {
        public InstallableResource convertNode(Node var1, int var2) throws RepositoryException;
    }
}

