/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.installer.provider.jcr.impl.FolderNameFilter;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootFolderListener
implements EventListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RescanTimer timer;
    private final String watchedPath;

    RootFolderListener(Session session, FolderNameFilter fnf, String path, RescanTimer timer) throws RepositoryException {
        this.timer = timer;
        this.watchedPath = path;
        int eventTypes = 3;
        boolean isDeep = true;
        boolean noLocal = true;
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, eventTypes, this.watchedPath, isDeep, null, null, noLocal);
        this.log.info("Watching {} to detect potential changes in subfolders", (Object)this.watchedPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.watchedPath + ")";
    }

    void cleanup(Session session) throws RepositoryException {
        session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
    }

    public void onEvent(EventIterator it) {
        while (it.hasNext()) {
            Event e = it.nextEvent();
            this.log.debug("Got event {}", (Object)e);
        }
        this.timer.scheduleScan();
    }
}

