/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.provider.jcr.impl.ConfigNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FileNodeConverter;
import org.apache.sling.installer.provider.jcr.impl.FolderNameFilter;
import org.apache.sling.installer.provider.jcr.impl.JcrInstaller;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;

public class InstallerConfig {
    private final boolean writeBack;
    private final Collection<JcrInstaller.NodeConverter> converters = new ArrayList<JcrInstaller.NodeConverter>();
    private final int maxWatchedFolderDepth;
    private final FolderNameFilter folderNameFilter;
    private final String[] roots;
    private final String newConfigPath;
    private final String pauseScanNodePath;
    private final List<WatchedFolder> watchedFolders = new LinkedList<WatchedFolder>();
    private final Logger logger;

    public InstallerConfig(Logger logger, JcrInstaller.Configuration configuration, SlingSettingsService settings) {
        boolean preSlash;
        this.logger = logger;
        this.writeBack = configuration.sling_jcrinstall_enable_writeback();
        this.converters.add(new FileNodeConverter());
        this.converters.add(new ConfigNodeConverter());
        this.maxWatchedFolderDepth = configuration.sling_jcrinstall_folder_max_depth();
        String folderNameRegexp = configuration.sling_jcrinstall_folder_name_regexp().trim();
        this.folderNameFilter = new FolderNameFilter(configuration.sling_jcrinstall_search_path(), folderNameRegexp, settings.getRunModes());
        this.roots = this.folderNameFilter.getRootPaths();
        String newCfgPath = configuration.sling_jcrinstall_new_config_path();
        boolean postSlash = newCfgPath.endsWith("/");
        if (!postSlash) {
            newCfgPath = newCfgPath.concat("/");
        }
        if (!(preSlash = newCfgPath.startsWith("/"))) {
            newCfgPath = this.folderNameFilter.getRootPaths()[0] + '/' + newCfgPath;
        }
        this.newConfigPath = newCfgPath;
        this.pauseScanNodePath = configuration.sling_jcrinstall_signal_path();
    }

    public String[] getRoots() {
        return this.roots;
    }

    public FolderNameFilter getFolderNameFilter() {
        return this.folderNameFilter;
    }

    public Collection<JcrInstaller.NodeConverter> getConverters() {
        return this.converters;
    }

    public int getMaxWatchedFolderDepth() {
        return this.maxWatchedFolderDepth;
    }

    public String getPauseScanNodePath() {
        return this.pauseScanNodePath;
    }

    public boolean isWriteBack() {
        return this.writeBack;
    }

    public String getNewConfigPath() {
        return this.newConfigPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WatchedFolder> cloneWatchedFolders() {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            return new ArrayList<WatchedFolder>(this.watchedFolders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstallableResource> scanWatchedFolders() throws RepositoryException {
        LinkedList<InstallableResource> resources = new LinkedList<InstallableResource>();
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            for (WatchedFolder f : this.watchedFolders) {
                WatchedFolder.ScanResult r = f.scan();
                this.logger.debug("Startup: {} provides resources {}", (Object)f, r.toAdd);
                resources.addAll(r.toAdd);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkForRemovedWatchedFolders(Session session) throws RepositoryException {
        LinkedList<String> removedResources = new LinkedList<String>();
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            Iterator<WatchedFolder> i = this.watchedFolders.iterator();
            while (i.hasNext()) {
                WatchedFolder wf = i.next();
                this.logger.debug("Item {} exists? {}", (Object)wf.getPath(), (Object)session.itemExists(wf.getPath()));
                if (session.itemExists(wf.getPath())) continue;
                this.logger.info("Deleting {}, path does not exist anymore", (Object)wf);
                removedResources.addAll(wf.scan().toRemove);
                i.remove();
            }
        }
        return removedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatchedFolder(WatchedFolder toAdd) {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            WatchedFolder existing = null;
            for (WatchedFolder wf : this.watchedFolders) {
                if (!wf.getPath().equals(toAdd.getPath())) continue;
                existing = wf;
                break;
            }
            if (existing == null) {
                this.watchedFolders.add(toAdd);
                toAdd.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyWatchFolderNeedsScan() {
        List<WatchedFolder> list = this.watchedFolders;
        synchronized (list) {
            for (WatchedFolder wf : this.watchedFolders) {
                if (!wf.needsScan()) continue;
                return true;
            }
        }
        return false;
    }
}

