/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeLoader {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerNodeType(Session session, URL source) {
        if (source == null) {
            log.info("No node type definition source available");
            return false;
        }
        InputStream ins = null;
        try {
            ins = source.openStream();
            boolean bl = NodeTypeLoader.registerNodeType(session, ins);
            return bl;
        }
        catch (IOException ioe) {
            log.error("Cannot register node types from " + source, (Throwable)ioe);
        }
        catch (RepositoryException re) {
            log.error("Cannot register node types from " + source, (Throwable)re);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return false;
    }

    public static boolean registerNodeType(Session session, InputStream source) throws IOException, RepositoryException {
        Workspace workspace = session.getWorkspace();
        NodeTypeManager ntm = workspace.getNodeTypeManager();
        if (ntm instanceof JackrabbitNodeTypeManager) {
            log.debug("Using Jackrabbit to import node types");
            JackrabbitNodeTypeManager jntm = (JackrabbitNodeTypeManager)ntm;
            try {
                jntm.registerNodeTypes(source, "text/x-jcr-cnd");
                return true;
            }
            catch (RepositoryException re) {
                Throwable t = re.getCause();
                if (t != null && t.getClass().getName().endsWith(".InvalidNodeTypeDefException") && re.getCause().getMessage().indexOf("already exists") >= 0) {
                    log.debug("Node types already registered...");
                    return true;
                }
                throw re;
            }
        }
        log.warn("Repository does not implement JackrabbitNodeTypeManager, cannot import node types");
        return false;
    }
}

