/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.base.AbstractSlingRepository;
import org.apache.sling.jcr.base.NodeTypeLoader;
import org.apache.sling.jcr.base.internal.NamespaceMapper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader
implements NamespaceMapper {
    public static final String NODETYPES_BUNDLE_HEADER = "Sling-Nodetypes";
    public static final String NAMESPACES_BUNDLE_HEADER = "Sling-Namespaces";
    private static final Logger log = LoggerFactory.getLogger(Loader.class);
    private AbstractSlingRepository slingRepository;
    private List<Bundle> delayedBundles;
    private final Map<Long, NamespaceEntry[]> namespaceTable = new HashMap<Long, NamespaceEntry[]>();

    public Loader(AbstractSlingRepository repository, Bundle[] existingBundles) {
        this.slingRepository = repository;
        this.delayedBundles = new LinkedList<Bundle>();
        for (Bundle bundle : existingBundles) {
            if ((bundle.getState() & 3) != 0) continue;
            this.registerBundle(bundle);
        }
    }

    public void dispose() {
        if (this.delayedBundles != null) {
            this.delayedBundles.clear();
            this.delayedBundles = null;
        }
        this.slingRepository = null;
    }

    public void registerBundle(Bundle bundle) {
        this.registerNamespaces(bundle);
        if (this.registerBundleInternal(bundle, false)) {
            int currentSize = -1;
            for (int i = this.delayedBundles.size(); i > 0 && currentSize != this.delayedBundles.size() && !this.delayedBundles.isEmpty(); --i) {
                Iterator<Bundle> di = this.delayedBundles.iterator();
                while (di.hasNext()) {
                    Bundle delayed = di.next();
                    if (!this.registerBundleInternal(delayed, true)) continue;
                    di.remove();
                }
                currentSize = this.delayedBundles.size();
            }
        } else {
            this.delayedBundles.add(bundle);
        }
    }

    public void unregisterBundle(Bundle bundle) {
        this.unregisterNamespaces(bundle);
        if (this.delayedBundles.contains(bundle)) {
            this.delayedBundles.remove(bundle);
        }
    }

    public void updateBundle(Bundle bundle) {
        this.unregisterBundle(bundle);
        this.registerBundle(bundle);
    }

    protected void registerNamespaces(Bundle bundle) {
        String definition = (String)bundle.getHeaders().get(NAMESPACES_BUNDLE_HEADER);
        if (definition != null) {
            log.debug("registerNamespaces: Bundle {} tries to register: {}", (Object)bundle.getSymbolicName(), (Object)definition);
            StringTokenizer st = new StringTokenizer(definition, ",");
            ArrayList<NamespaceEntry> entries = new ArrayList<NamespaceEntry>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int pos = token.indexOf(61);
                if (pos == -1) {
                    log.warn("registerNamespaces: Bundle {} has an invalid namespace manifest header entry: {}", (Object)bundle.getSymbolicName(), (Object)token);
                    continue;
                }
                String prefix = token.substring(0, pos).trim();
                String namespace = token.substring(pos + 1).trim();
                entries.add(new NamespaceEntry(prefix, namespace));
            }
            if (entries.size() > 0) {
                this.namespaceTable.put(bundle.getBundleId(), entries.toArray(new NamespaceEntry[entries.size()]));
            }
        }
    }

    protected void unregisterNamespaces(Bundle bundle) {
        this.namespaceTable.remove(bundle.getBundleId());
    }

    private boolean registerBundleInternal(Bundle bundle, boolean isRetry) {
        try {
            if (this.registerNodeTypes(bundle, isRetry)) {
                return true;
            }
        }
        catch (RepositoryException re) {
            if (isRetry) {
                log.error("Cannot register node types for bundle {}: {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            log.debug("Retrying to register node types failed for bundle {}: {}", (Object)bundle.getSymbolicName(), (Object)re);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerNodeTypes(Bundle bundle, boolean isRetry) throws RepositoryException {
        String typesHeader = (String)bundle.getHeaders().get(NODETYPES_BUNDLE_HEADER);
        if (typesHeader == null) {
            log.debug("registerNodeTypes: Bundle {} has no nodetypes", (Object)bundle.getSymbolicName());
            return true;
        }
        boolean success = true;
        Session session = this.getSession();
        try {
            StringTokenizer tokener = new StringTokenizer(typesHeader, ",");
            while (tokener.hasMoreTokens()) {
                String nodeTypeFile = tokener.nextToken().trim();
                URL mappingURL = bundle.getEntry(nodeTypeFile);
                if (mappingURL == null) {
                    if (isRetry) continue;
                    log.warn("Custom node type definition {} not found in bundle {}", (Object)nodeTypeFile, (Object)bundle.getSymbolicName());
                    continue;
                }
                InputStream ins = null;
                try {
                    ins = mappingURL.openStream();
                    NodeTypeLoader.registerNodeType(session, ins);
                    if (!isRetry) continue;
                    log.info("Retrytring to register node types from {} in bundle {} succeeded.", new Object[]{nodeTypeFile, bundle.getSymbolicName()});
                }
                catch (IOException ioe) {
                    success = false;
                    if (isRetry) continue;
                    log.warn("Cannot read node types {} from bundle {}: {}", new Object[]{nodeTypeFile, bundle.getSymbolicName(), ioe});
                    log.warn("Stacktrace ", (Throwable)ioe);
                }
                catch (Exception e) {
                    success = false;
                    if (isRetry) continue;
                    log.error("Error loading node types {} from bundle {}: {}", new Object[]{nodeTypeFile, bundle.getSymbolicName(), e});
                    log.error("Stacktrace ", (Throwable)e);
                }
                finally {
                    if (ins == null) continue;
                    try {
                        ins.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        finally {
            this.ungetSession(session);
        }
        return success;
    }

    private Session getSession() throws RepositoryException {
        return this.slingRepository.loginAdministrative(null);
    }

    private void ungetSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public void defineNamespacePrefixes(Session session) throws RepositoryException {
        for (NamespaceEntry[] entries : this.namespaceTable.values()) {
            for (int i = 0; i < entries.length; ++i) {
                String mappedPrefix = null;
                try {
                    mappedPrefix = session.getNamespacePrefix(entries[i].namespace);
                }
                catch (NamespaceException ne) {
                    mappedPrefix = entries[i].prefix + "_new";
                    try {
                        session.getNamespaceURI(entries[i].prefix);
                    }
                    catch (NamespaceException ne2) {
                        mappedPrefix = entries[i].prefix;
                    }
                    session.getWorkspace().getNamespaceRegistry().registerNamespace(mappedPrefix, entries[i].namespace);
                }
                if (mappedPrefix == null || mappedPrefix.equals(entries[i].prefix)) continue;
                String oldUri = null;
                try {
                    oldUri = session.getNamespaceURI(entries[i].prefix);
                    session.setNamespacePrefix(entries[i].prefix + "_old", oldUri);
                }
                catch (NamespaceException ne) {
                    // empty catch block
                }
                session.setNamespacePrefix(entries[i].prefix, entries[i].namespace);
            }
        }
    }

    public static class NamespaceEntry {
        public final String prefix;
        public final String namespace;

        public NamespaceEntry(String p, String n) {
            this.prefix = p;
            this.namespace = n;
        }
    }
}

