/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlUtil {
    private static final String METHOD_GET_ACCESS_CONTROL_MANAGER = "getAccessControlManager";
    private static final String METHOD_GET_USER_MANAGER = "getUserManager";
    private static final String METHOD_GET_PRINCIPAL_MANAGER = "getPrincipalManager";
    private static final String METHOD_JACKRABBIT_ACL_GET_PATH = "getPath";
    private static final String METHOD_JACKRABBIT_ACL_IS_EMPTY = "isEmpty";
    private static final String METHOD_JACKRABBIT_ACL_SIZE = "size";
    private static final String METHOD_JACKRABBIT_ACL_ADD_ENTRY = "addEntry";
    private static final String METHOD_JACKRABBIT_ACE_IS_ALLOW = "isAllow";

    public static AccessControlManager getAccessControlManager(Session session) throws UnsupportedRepositoryOperationException, RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_ACCESS_CONTROL_MANAGER, AccessControlManager.class, new Object[0]);
    }

    public static UserManager getUserManager(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession jackrabbitSession = AccessControlUtil.getJackrabbitSession(session);
        if (jackrabbitSession != null) {
            return jackrabbitSession.getUserManager();
        }
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_USER_MANAGER, UserManager.class, new Object[0]);
    }

    public static PrincipalManager getPrincipalManager(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession jackrabbitSession = AccessControlUtil.getJackrabbitSession(session);
        if (jackrabbitSession != null) {
            return jackrabbitSession.getPrincipalManager();
        }
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_PRINCIPAL_MANAGER, PrincipalManager.class, new Object[0]);
    }

    public static String getPath(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_GET_PATH, String.class, new Object[0]);
    }

    public static boolean isEmpty(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_IS_EMPTY, Boolean.class, new Object[0]);
    }

    public static int size(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_SIZE, Integer.class, new Object[0]);
    }

    public static boolean addEntry(AccessControlList acl, Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        Object[] args = new Object[]{principal, privileges, isAllow};
        Class[] types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE};
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_ADD_ENTRY, Boolean.class, args, types);
    }

    public static boolean addEntry(AccessControlList acl, Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions) throws UnsupportedRepositoryOperationException, RepositoryException {
        Object[] args = new Object[]{principal, privileges, isAllow, restrictions};
        Class[] types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE, Map.class};
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_ADD_ENTRY, Boolean.class, args, types);
    }

    public static boolean isAllow(AccessControlEntry ace) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)ace, METHOD_JACKRABBIT_ACE_IS_ALLOW, Boolean.class, new Object[0]);
    }

    private static <T> T safeInvokeRepoMethod(Object target, String methodName, Class<T> returnType, Object[] args, Class[] argsTypes) throws UnsupportedRepositoryOperationException, RepositoryException {
        try {
            Method m = target.getClass().getMethod(methodName, argsTypes);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            return (T)m.invoke(target, args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof UnsupportedRepositoryOperationException) {
                throw (UnsupportedRepositoryOperationException)t;
            }
            if (t instanceof AccessDeniedException) {
                throw (AccessDeniedException)t;
            }
            if (t instanceof AccessControlException) {
                throw (AccessControlException)t;
            }
            if (t instanceof RepositoryException) {
                throw (RepositoryException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RepositoryException(methodName, t);
        }
        catch (Throwable t) {
            throw new RepositoryException(methodName, t);
        }
    }

    private static <T> T safeInvokeRepoMethod(Object target, String methodName, Class<T> returnType, Object ... args) throws UnsupportedRepositoryOperationException, RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod(target, methodName, returnType, args, new Class[0]);
    }

    private static JackrabbitSession getJackrabbitSession(Session session) {
        if (session instanceof JackrabbitSession) {
            return (JackrabbitSession)session;
        }
        return null;
    }
}

