/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Session;
import org.apache.sling.jcr.base.AbstractNamespaceMappingRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProxyHandler {
    private Class<?>[] interfaces;
    private final AbstractNamespaceMappingRepository repository;

    public SessionProxyHandler(AbstractNamespaceMappingRepository repo) {
        this.repository = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?>[] getInterfaces(Class<?> sessionClass) {
        if (this.interfaces != null) return this.interfaces;
        Class<SessionProxyHandler> clazz = SessionProxyHandler.class;
        synchronized (SessionProxyHandler.class) {
            if (this.interfaces != null) return this.interfaces;
            HashSet workInterfaces = new HashSet();
            this.guessWorkInterfaces(sessionClass, workInterfaces);
            this.interfaces = workInterfaces.toArray(new Class[workInterfaces.size()]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.interfaces;
        }
    }

    public Session createProxy(Session session) {
        Class<?> sessionClass = session.getClass();
        Class<?>[] interfaces = this.getInterfaces(sessionClass);
        return (Session)Proxy.newProxyInstance(sessionClass.getClassLoader(), interfaces, (InvocationHandler)new SessionProxyInvocationHandler(session, this.repository, interfaces));
    }

    private void guessWorkInterfaces(Class<?> clazz, Set<Class<?>> workInterfaces) {
        if (null != clazz) {
            this.addInterfaces(clazz.getInterfaces(), workInterfaces);
            this.guessWorkInterfaces(clazz.getSuperclass(), workInterfaces);
        }
    }

    private void addInterfaces(Class<?>[] classInterfaces, Set<Class<?>> workInterfaces) {
        for (int i = 0; i < classInterfaces.length; ++i) {
            workInterfaces.add(classInterfaces[i]);
            this.addInterfaces(classInterfaces[i].getInterfaces(), workInterfaces);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SessionProxyInvocationHandler
    implements InvocationHandler {
        private final Session delegatee;
        private final AbstractNamespaceMappingRepository repository;
        private final Class<?>[] interfaces;

        public SessionProxyInvocationHandler(Session delegatee, AbstractNamespaceMappingRepository repo, Class<?>[] interfaces) {
            this.delegatee = delegatee;
            this.repository = repo;
            this.interfaces = interfaces;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("impersonate") && args != null && args.length == 1) {
                Session session = this.delegatee.impersonate((Credentials)args[0]);
                this.repository.defineNamespacePrefixes(session);
                Class<?> sessionClass = session.getClass();
                return Proxy.newProxyInstance(sessionClass.getClassLoader(), this.interfaces, (InvocationHandler)new SessionProxyInvocationHandler(session, this.repository, this.interfaces));
            }
            try {
                return method.invoke((Object)this.delegatee, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }
}

