/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.NamespaceMapper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.SessionProxyHandler;
import org.apache.sling.jcr.base.internal.loader.Loader;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractNamespaceMappingRepository
implements SlingRepository {
    private Loader namespaceHandler;
    private SessionProxyHandler sessionProxyHandler;
    private ServiceTracker namespaceMapperTracker;

    protected void setup(BundleContext bundleContext) {
        this.namespaceMapperTracker = new ServiceTracker(bundleContext, NamespaceMapper.class.getName(), null);
        this.namespaceMapperTracker.open();
        this.namespaceHandler = new Loader(this, bundleContext);
        this.sessionProxyHandler = new SessionProxyHandler(this);
    }

    protected void tearDown() {
        if (this.namespaceMapperTracker != null) {
            this.namespaceMapperTracker.close();
            this.namespaceMapperTracker = null;
        }
        if (this.namespaceHandler != null) {
            this.namespaceHandler.dispose();
            this.namespaceHandler = null;
        }
        this.sessionProxyHandler = null;
    }

    void defineNamespacePrefixes(Session session) throws RepositoryException {
        Object[] nsMappers;
        Loader localHandler = this.namespaceHandler;
        if (localHandler != null) {
            localHandler.defineNamespacePrefixes(session);
        }
        if (this.namespaceMapperTracker != null && (nsMappers = this.namespaceMapperTracker.getServices()) != null) {
            for (int i = 0; i < nsMappers.length; ++i) {
                ((NamespaceMapper)nsMappers[i]).defineNamespacePrefixes(session);
            }
        }
    }

    protected Session getNamespaceAwareSession(Session session) throws RepositoryException {
        if (session == null) {
            return null;
        }
        this.defineNamespacePrefixes(session);
        SessionProxyHandler localHandler = this.sessionProxyHandler;
        if (localHandler != null) {
            return localHandler.createProxy(session);
        }
        return session;
    }
}

