/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryPrinter {
    private final Repository repository;
    private final String name;

    public RepositoryPrinter(Repository repo, Map<String, Object> props) {
        this.repository = repo;
        this.name = repo.getDescriptor("jcr.repository.name") != null ? "Repository " + repo.getDescriptor("jcr.repository.name") : (props.get("name") != null ? "Repository " + props.get("name").toString() : "Repository @" + repo.hashCode());
    }

    public String getTitle() {
        return this.name;
    }

    public Dictionary<String, Object> getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.webconsole.label", this.name);
        ((Dictionary)props).put("felix.webconsole.title", this.name);
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        return props;
    }

    public void printConfiguration(PrintWriter pw) {
        Repository repo = this.repository;
        this.writeHeader(pw, "Repository Properties");
        Object[] keys = repo.getDescriptorKeys();
        Arrays.sort(keys);
        for (Object key : keys) {
            String val = repo.getDescriptor((String)key);
            this.writeEntry(pw, (String)key, val);
        }
    }

    private void writeHeader(PrintWriter pw, String value) {
        pw.print(value);
        pw.println(":");
    }

    private void writeEntry(PrintWriter pw, String key, String value) {
        pw.print(key);
        pw.print(": ");
        if (value != null) {
            pw.println(value);
        } else {
            pw.println("-");
        }
    }
}

