/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.NamespaceMapper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.NodeTypeLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader
implements NamespaceMapper,
BundleListener {
    public static final String NODETYPES_BUNDLE_HEADER = "Sling-Nodetypes";
    public static final String NAMESPACES_BUNDLE_HEADER = "Sling-Namespaces";
    private final Logger log = LoggerFactory.getLogger(Loader.class);
    private final BundleContext bundleContext;
    private final SlingRepository slingRepository;
    private final List<Bundle> delayedBundles;
    private final Map<Long, NamespaceEntry[]> namespaceTable = new HashMap<Long, NamespaceEntry[]>();

    public Loader(SlingRepository repository, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.slingRepository = repository;
        this.delayedBundles = new ArrayList<Bundle>();
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() == 1) continue;
            this.registerBundle(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        List<Bundle> list = this.delayedBundles;
        synchronized (list) {
            this.delayedBundles.clear();
        }
    }

    public void defineNamespacePrefixes(Session session) throws RepositoryException {
        for (NamespaceEntry[] entries : this.namespaceTable.values()) {
            for (int i = 0; i < entries.length; ++i) {
                String mappedPrefix = null;
                try {
                    mappedPrefix = session.getNamespacePrefix(entries[i].namespace);
                }
                catch (NamespaceException ne) {
                    mappedPrefix = entries[i].prefix + "_new";
                    try {
                        session.getNamespaceURI(entries[i].prefix);
                    }
                    catch (NamespaceException ne2) {
                        mappedPrefix = entries[i].prefix;
                    }
                    session.getWorkspace().getNamespaceRegistry().registerNamespace(mappedPrefix, entries[i].namespace);
                }
                if (mappedPrefix == null || mappedPrefix.equals(entries[i].prefix)) continue;
                String oldUri = null;
                try {
                    oldUri = session.getNamespaceURI(entries[i].prefix);
                    session.setNamespacePrefix(entries[i].prefix + "_old", oldUri);
                }
                catch (NamespaceException ne) {
                    // empty catch block
                }
                session.setNamespacePrefix(entries[i].prefix, entries[i].namespace);
            }
        }
    }

    public final void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.registerBundle(event.getBundle());
                break;
            }
            case 16: {
                this.unregisterBundle(event.getBundle());
                break;
            }
            case 8: {
                this.updateBundle(event.getBundle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBundle(Bundle bundle) {
        this.registerNamespaces(bundle);
        if (this.registerBundleInternal(bundle, false)) {
            int currentSize = -1;
            for (int i = this.delayedBundles.size(); i > 0 && currentSize != this.delayedBundles.size() && !this.delayedBundles.isEmpty(); --i) {
                Iterator<Bundle> di = this.delayedBundles.iterator();
                while (di.hasNext()) {
                    Bundle delayed = di.next();
                    if (!this.registerBundleInternal(delayed, true)) continue;
                    di.remove();
                }
                currentSize = this.delayedBundles.size();
            }
        } else {
            List<Bundle> list = this.delayedBundles;
            synchronized (list) {
                this.delayedBundles.add(bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterBundle(Bundle bundle) {
        this.unregisterNamespaces(bundle);
        List<Bundle> list = this.delayedBundles;
        synchronized (list) {
            this.delayedBundles.remove(bundle);
        }
    }

    private void updateBundle(Bundle bundle) {
        this.unregisterBundle(bundle);
        this.registerBundle(bundle);
    }

    private void registerNamespaces(Bundle bundle) {
        String definition = (String)bundle.getHeaders().get(NAMESPACES_BUNDLE_HEADER);
        if (definition != null) {
            this.log.debug("registerNamespaces: Bundle {} tries to register: {}", (Object)bundle.getSymbolicName(), (Object)definition);
            StringTokenizer st = new StringTokenizer(definition, ",");
            ArrayList<NamespaceEntry> entries = new ArrayList<NamespaceEntry>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int pos = token.indexOf(61);
                if (pos == -1) {
                    this.log.warn("registerNamespaces: Bundle {} has an invalid namespace manifest header entry: {}", (Object)bundle.getSymbolicName(), (Object)token);
                    continue;
                }
                String prefix = token.substring(0, pos).trim();
                String namespace = token.substring(pos + 1).trim();
                entries.add(new NamespaceEntry(prefix, namespace));
            }
            if (entries.size() > 0) {
                this.namespaceTable.put(bundle.getBundleId(), entries.toArray(new NamespaceEntry[entries.size()]));
            }
        }
    }

    protected void unregisterNamespaces(Bundle bundle) {
        this.namespaceTable.remove(bundle.getBundleId());
    }

    private boolean registerBundleInternal(Bundle bundle, boolean isRetry) {
        try {
            if (this.registerNodeTypes(bundle, isRetry)) {
                return true;
            }
        }
        catch (RepositoryException re) {
            if (isRetry) {
                this.log.error("Cannot register node types for bundle {}: {}", (Object)bundle.getSymbolicName(), (Object)re);
            }
            this.log.debug("Retrying to register node types failed for bundle {}: {}", (Object)bundle.getSymbolicName(), (Object)re);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerNodeTypes(Bundle bundle, boolean isRetry) throws RepositoryException {
        String typesHeader = (String)bundle.getHeaders().get(NODETYPES_BUNDLE_HEADER);
        if (typesHeader == null) {
            this.log.debug("registerNodeTypes: Bundle {} has no nodetypes", (Object)bundle.getSymbolicName());
            return true;
        }
        boolean success = true;
        Session session = this.getSession();
        try {
            StringTokenizer tokener = new StringTokenizer(typesHeader, ",");
            while (tokener.hasMoreTokens()) {
                URL mappingURL;
                String nodeTypeFile = tokener.nextToken().trim();
                HashMap<String, String> nodeTypeFileParams = new HashMap<String, String>();
                nodeTypeFileParams.put("reregister", "true");
                if (nodeTypeFile.contains(";")) {
                    int idx = nodeTypeFile.indexOf(59);
                    String nodeTypeFileParam = nodeTypeFile.substring(idx + 1);
                    String[] params = nodeTypeFileParam.split(":=");
                    nodeTypeFileParams.put(params[0], params[1]);
                    nodeTypeFile = nodeTypeFile.substring(0, idx);
                }
                if ((mappingURL = bundle.getEntry(nodeTypeFile)) == null) {
                    if (isRetry) continue;
                    this.log.warn("Custom node type definition {} not found in bundle {}", (Object)nodeTypeFile, (Object)bundle.getSymbolicName());
                    continue;
                }
                InputStream ins = null;
                try {
                    ins = mappingURL.openStream();
                    String reregister = (String)nodeTypeFileParams.get("reregister");
                    boolean reregisterBool = Boolean.valueOf(reregister);
                    NodeTypeLoader.registerNodeType(session, mappingURL.toString(), new InputStreamReader(ins), reregisterBool);
                    if (!isRetry) continue;
                    this.log.info("Retrying to register node types from {} in bundle {} succeeded.", new Object[]{nodeTypeFile, bundle.getSymbolicName()});
                }
                catch (IOException ioe) {
                    success = false;
                    if (isRetry) continue;
                    this.log.warn("Cannot read node types {} from bundle {}: {}", new Object[]{nodeTypeFile, bundle.getSymbolicName(), ioe});
                    this.log.warn("Stacktrace ", (Throwable)ioe);
                }
                catch (Exception e) {
                    success = false;
                    if (isRetry) continue;
                    this.log.error("Error loading node types {} from bundle {}: {}", new Object[]{nodeTypeFile, bundle.getSymbolicName(), e});
                    this.log.error("Stacktrace ", (Throwable)e);
                }
                finally {
                    if (ins == null) continue;
                    try {
                        ins.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        finally {
            this.ungetSession(session);
        }
        return success;
    }

    private Session getSession() throws RepositoryException {
        return this.slingRepository.loginAdministrative(null);
    }

    private void ungetSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    private static class NamespaceEntry {
        public final String prefix;
        public final String namespace;

        public NamespaceEntry(String p, String n) {
            this.prefix = p;
            this.namespace = n;
        }
    }
}

