/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.sling.jcr.base.internal.LoginAdminWhitelistConfiguration;
import org.apache.sling.jcr.base.internal.WhitelistFragment;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={LoginAdminWhitelist.class}, property={"service.description=Apache Sling Login Admin Whitelist", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=LoginAdminWhitelistConfiguration.class)
public class LoginAdminWhitelist {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAdminWhitelist.class);
    private volatile ConfigurationState config;
    private volatile WhitelistFragment defaultFragment;
    private volatile WhitelistFragment additionalFragment;
    private final List<WhitelistFragment> whitelistFragments = new CopyOnWriteArrayList<WhitelistFragment>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindWhitelistFragment(WhitelistFragment fragment) {
        this.whitelistFragments.add(fragment);
        LOG.info("WhitelistFragment added '{}'", (Object)fragment);
    }

    void unbindWhitelistFragment(WhitelistFragment fragment) {
        this.whitelistFragments.remove(fragment);
        LOG.info("WhitelistFragment removed '{}'", (Object)fragment);
    }

    @Activate
    @Modified
    void configure(LoginAdminWhitelistConfiguration configuration) {
        this.config = new ConfigurationState(configuration);
        this.backwardsCompatibility(configuration);
    }

    public boolean allowLoginAdministrative(Bundle b) {
        if (this.config == null) {
            throw new IllegalStateException("LoginAdminWhitelist has no configuration.");
        }
        ConfigurationState localConfig = this.config;
        if (localConfig.bypassWhitelist) {
            LOG.debug("Whitelist is bypassed, all bundles allowed to use loginAdministrative");
            return true;
        }
        String bsn = b.getSymbolicName();
        if (localConfig.whitelistRegexp != null && localConfig.whitelistRegexp.matcher(bsn).matches()) {
            LOG.debug("{} is whitelisted to use loginAdministrative, by regexp", (Object)bsn);
            return true;
        }
        for (WhitelistFragment fragment : this.whitelistFragments) {
            if (!fragment.allows(bsn)) continue;
            LOG.debug("{} is whitelisted to use loginAdministrative, by whitelist fragment '{}'", (Object)bsn, (Object)fragment);
            return true;
        }
        LOG.debug("{} is not whitelisted to use loginAdministrative", (Object)bsn);
        return false;
    }

    private void backwardsCompatibility(LoginAdminWhitelistConfiguration configuration) {
        String[] additionalBsns;
        String[] defaultBsns;
        if (this.defaultFragment != null) {
            this.unbindWhitelistFragment(this.defaultFragment);
        }
        if (this.additionalFragment != null) {
            this.unbindWhitelistFragment(this.additionalFragment);
        }
        if ((defaultBsns = configuration.whitelist_bundles_default()) != null && defaultBsns.length != 0) {
            LOG.warn("Using deprecated configuration property 'whitelist.bundles.default'");
            this.defaultFragment = new WhitelistFragment("deprecated-whitelist.bundles.default", defaultBsns);
            this.bindWhitelistFragment(this.defaultFragment);
        }
        if ((additionalBsns = configuration.whitelist_bundles_additional()) != null && additionalBsns.length != 0) {
            LOG.warn("Using deprecated configuration property 'whitelist.bundles.additional'");
            this.additionalFragment = new WhitelistFragment("deprecated-whitelist.bundles.additional", additionalBsns);
            this.bindWhitelistFragment(this.additionalFragment);
        }
    }

    private static class ConfigurationState {
        private final boolean bypassWhitelist;
        private final Pattern whitelistRegexp;

        private ConfigurationState(LoginAdminWhitelistConfiguration config) {
            String regexp = config.whitelist_bundles_regexp();
            if (regexp.trim().length() > 0) {
                this.whitelistRegexp = Pattern.compile(regexp);
                LOG.warn("A whitelist.bundles.regexp is configured, this is NOT RECOMMENDED for production: {}", (Object)this.whitelistRegexp);
            } else {
                this.whitelistRegexp = null;
            }
            this.bypassWhitelist = config.whitelist_bypass();
            if (this.bypassWhitelist) {
                LOG.info("bypassWhitelist=true, whitelisted BSNs=<ALL>");
                LOG.warn("All bundles are allowed to use loginAdministrative due to the 'bypass whitelist' configuration of this service. This is NOT RECOMMENDED, for security reasons.");
            }
        }
    }
}

