/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.SlingSettingsService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.Loader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentLoaderService
implements SynchronousBundleListener {
    public static final String PROPERTY_CONTENT_LOADED = "content-loaded";
    private static final String PROPERTY_CONTENT_LOADED_AT = "content-load-time";
    private static final String PROPERTY_CONTENT_LOADED_BY = "content-loaded-by";
    private static final String PROPERTY_CONTENT_UNLOADED_AT = "content-unload-time";
    private static final String PROPERTY_CONTENT_UNLOADED_BY = "content-unloaded-by";
    public static final String PROPERTY_UNINSTALL_PATHS = "uninstall-paths";
    public static final String BUNDLE_CONTENT_NODE = "/var/sling/bundle-content";
    private static final String PROP_PASSWORD_DIGEST_ALGORITHM = "password.digest.algorithm";
    private static final String DEFAULT_PASSWORD_DIGEST_ALGORITHM = "sha1";
    private String passwordDigestAlgoritm = null;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private MimeTypeService mimeTypeService;
    private Loader initialContentLoader;
    private String slingId;
    private final Set<String> updatedBundles = new HashSet<String>();
    protected SlingSettingsService settingsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Session session = null;
        switch (event.getType()) {
            case 128: {
                try {
                    session = this.getSession();
                    boolean isUpdate = this.updatedBundles.remove(event.getBundle().getSymbolicName());
                    this.initialContentLoader.registerBundle(session, event.getBundle(), isUpdate);
                    break;
                }
                catch (Throwable t) {
                    this.log.error("bundleChanged: Problem loading initial content of bundle " + event.getBundle().getSymbolicName() + " (" + event.getBundle().getBundleId() + ")", t);
                    break;
                }
                finally {
                    this.ungetSession(session);
                }
            }
            case 8: {
                this.updatedBundles.add(event.getBundle().getSymbolicName());
                break;
            }
            case 16: {
                try {
                    session = this.getSession();
                    this.initialContentLoader.unregisterBundle(session, event.getBundle());
                    break;
                }
                catch (Throwable t) {
                    this.log.error("bundleChanged: Problem unloading initial content of bundle " + event.getBundle().getSymbolicName() + " (" + event.getBundle().getBundleId() + ")", t);
                    break;
                }
                finally {
                    this.ungetSession(session);
                }
            }
        }
    }

    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    protected void createRepositoryPath(Session writerSession, String repositoryPath) throws RepositoryException {
        if (!writerSession.itemExists(repositoryPath)) {
            Node node = writerSession.getRootNode();
            String path = repositoryPath.substring(1);
            int pos = path.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(path.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        node.addNode(token, "sling:Folder");
                        node.save();
                    }
                    node = node.getNode(token);
                }
                path = path.substring(pos + 1);
            }
            if (!node.hasNode(path)) {
                node.addNode(path, "sling:Folder");
                node.save();
            }
        }
    }

    protected String digestPassword(String pwd) throws IllegalArgumentException {
        try {
            StringBuffer password = new StringBuffer();
            password.append("{").append(this.passwordDigestAlgoritm).append("}");
            password.append(DefaultContentCreator.digest(this.passwordDigestAlgoritm, pwd.getBytes("UTF-8")));
            return password.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) {
        this.slingId = this.settingsService.getSlingId();
        this.initialContentLoader = new Loader(this);
        componentContext.getBundleContext().addBundleListener((BundleListener)this);
        Dictionary props = componentContext.getProperties();
        Object propValue = props.get(PROP_PASSWORD_DIGEST_ALGORITHM);
        this.passwordDigestAlgoritm = propValue instanceof String ? (String)propValue : DEFAULT_PASSWORD_DIGEST_ALGORITHM;
        Session session = null;
        try {
            Bundle[] bundles;
            session = this.getSession();
            this.createRepositoryPath(session, BUNDLE_CONTENT_NODE);
            this.log.debug("Activated - attempting to load content from all bundles which are neither INSTALLED nor UNINSTALLED");
            int ignored = 0;
            for (Bundle bundle : bundles = componentContext.getBundleContext().getBundles()) {
                if ((bundle.getState() & 3) == 0) {
                    try {
                        this.initialContentLoader.registerBundle(session, bundle, false);
                        continue;
                    }
                    catch (Throwable t) {
                        this.log.error("Problem loading initial content of bundle " + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", t);
                        continue;
                    }
                    finally {
                        if (session.hasPendingChanges()) {
                            session.refresh(false);
                        }
                    }
                }
                ++ignored;
            }
            this.log.debug("Out of {} bundles, {} were not in a suitable state for initial content loading", (Object)bundles.length, (Object)ignored);
        }
        catch (Throwable t) {
            this.log.error("activate: Problem while loading initial content and registering mappings for existing bundles", t);
        }
        finally {
            this.ungetSession(session);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        componentContext.getBundleContext().removeBundleListener((BundleListener)this);
        if (this.initialContentLoader != null) {
            this.initialContentLoader.dispose();
            this.initialContentLoader = null;
        }
        this.passwordDigestAlgoritm = null;
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    private Session getSession() throws RepositoryException {
        return this.getRepository().loginAdministrative(null);
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Throwable t) {
                this.log.error("Unable to log out of session: " + t.getMessage(), t);
            }
        }
    }

    public Map<String, Object> getBundleContentInfo(Session session, Bundle bundle, boolean create) throws RepositoryException {
        Node bcNode;
        String nodeName = bundle.getSymbolicName();
        Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
        if (!parentNode.hasNode(nodeName)) {
            if (!create) {
                return null;
            }
            try {
                bcNode = parentNode.addNode(nodeName, "nt:unstructured");
                bcNode.addMixin("mix:lockable");
                parentNode.save();
            }
            catch (RepositoryException re) {
                this.log.warn("Unable to create node " + nodeName, (Throwable)re);
                session.refresh(true);
            }
        }
        if ((bcNode = parentNode.getNode(nodeName)).isLocked()) {
            return null;
        }
        try {
            bcNode.lock(false, true);
        }
        catch (LockException le) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (bcNode.hasProperty(PROPERTY_CONTENT_LOADED)) {
            info.put(PROPERTY_CONTENT_LOADED, bcNode.getProperty(PROPERTY_CONTENT_LOADED).getBoolean());
        } else {
            info.put(PROPERTY_CONTENT_LOADED, false);
        }
        if (bcNode.hasProperty(PROPERTY_UNINSTALL_PATHS)) {
            Value[] values = bcNode.getProperty(PROPERTY_UNINSTALL_PATHS).getValues();
            String[] s = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                s[i] = values[i].getString();
            }
            info.put(PROPERTY_UNINSTALL_PATHS, s);
        }
        return info;
    }

    public void unlockBundleContentInfo(Session session, Bundle bundle, boolean contentLoaded, List<String> createdNodes) throws RepositoryException {
        String nodeName = bundle.getSymbolicName();
        Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
        Node bcNode = parentNode.getNode(nodeName);
        if (contentLoaded) {
            bcNode.setProperty(PROPERTY_CONTENT_LOADED, contentLoaded);
            bcNode.setProperty(PROPERTY_CONTENT_LOADED_AT, Calendar.getInstance());
            bcNode.setProperty(PROPERTY_CONTENT_LOADED_BY, this.slingId);
            bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_AT, (String)null);
            bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_BY, (String)null);
            if (createdNodes != null && createdNodes.size() > 0) {
                bcNode.setProperty(PROPERTY_UNINSTALL_PATHS, createdNodes.toArray(new String[createdNodes.size()]));
            }
            bcNode.save();
        }
        bcNode.unlock();
    }

    public void contentIsUninstalled(Session session, Bundle bundle) {
        String nodeName = bundle.getSymbolicName();
        try {
            Node parentNode = (Node)session.getItem(BUNDLE_CONTENT_NODE);
            if (parentNode.hasNode(nodeName)) {
                Node bcNode = parentNode.getNode(nodeName);
                bcNode.setProperty(PROPERTY_CONTENT_LOADED, false);
                bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_AT, Calendar.getInstance());
                bcNode.setProperty(PROPERTY_CONTENT_UNLOADED_BY, this.slingId);
                bcNode.save();
            }
        }
        catch (RepositoryException re) {
            this.log.error("Unable to update bundle content info.", (Throwable)re);
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

