/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentLoaderService;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.PathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContentCreator
implements ContentCreator {
    private PathEntry configuration;
    private final Pattern jsonDatePattern = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");
    private final SimpleDateFormat jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final Stack<Node> parentNodeStack = new Stack();
    private final List<Node> versionables = new ArrayList<Node>();
    private final Map<String, List<String>> delayedReferences = new HashMap<String, List<String>>();
    private final Map<String, String[]> delayedMultipleReferences = new HashMap<String, String[]>();
    private String defaultRootName;
    private Node rootNode;
    private boolean isRootNodeImport;
    private boolean ignoreOverwriteFlag = false;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final ContentLoaderService jcrContentHelper;
    private Map<String, ImportProvider> importProviders;
    private List<String> createdNodes;
    private static final long INSTANCE_SEED = System.currentTimeMillis();
    private static final int STORAGE_LEVELS = 3;
    private static final char[] hexTable = "0123456789abcdef".toCharArray();

    public DefaultContentCreator(ContentLoaderService jcrContentHelper) {
        this.jcrContentHelper = jcrContentHelper;
    }

    public void init(PathEntry pathEntry, Map<String, ImportProvider> defaultImportProviders, List<String> createdNodes) {
        this.configuration = pathEntry;
        this.importProviders = new HashMap<String, ImportProvider>();
        for (Map.Entry<String, ImportProvider> current : defaultImportProviders.entrySet()) {
            if (this.configuration.isIgnoredImportProvider(current.getKey())) continue;
            this.importProviders.put(current.getKey(), current.getValue());
        }
        this.createdNodes = createdNodes;
    }

    public void prepareParsing(Node parentNode, String defaultRootName) {
        this.parentNodeStack.clear();
        this.parentNodeStack.push(parentNode);
        this.defaultRootName = defaultRootName;
        this.rootNode = null;
        this.isRootNodeImport = defaultRootName == null;
    }

    public List<Node> getVersionables() {
        return this.versionables;
    }

    public void clear() {
        this.versionables.clear();
    }

    public void setIgnoreOverwriteFlag(boolean flag) {
        this.ignoreOverwriteFlag = flag;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public Map<String, ImportProvider> getImportProviders() {
        return this.importProviders;
    }

    public ImportProvider getImportProvider(String name) {
        ImportProvider provider = null;
        Iterator<String> ipIter = this.importProviders.keySet().iterator();
        while (provider == null && ipIter.hasNext()) {
            String ext = ipIter.next();
            if (!name.endsWith(ext)) continue;
            provider = this.importProviders.get(ext);
        }
        return provider;
    }

    public String getImportProviderExtension(String name) {
        String providerExt = null;
        Iterator<String> ipIter = this.importProviders.keySet().iterator();
        while (providerExt == null && ipIter.hasNext()) {
            String ext = ipIter.next();
            if (!name.endsWith(ext)) continue;
            providerExt = ext;
        }
        return providerExt;
    }

    @Override
    public void createNode(String name, String primaryNodeType, String[] mixinNodeTypes) throws RepositoryException {
        Node parentNode = this.parentNodeStack.peek();
        if (name == null) {
            if (this.parentNodeStack.size() > 1) {
                throw new RepositoryException("Node needs to have a name.");
            }
            name = this.defaultRootName;
        }
        if (!this.isRootNodeImport || this.parentNodeStack.size() > 1) {
            boolean addToVersionables;
            Node node;
            if (!this.ignoreOverwriteFlag && this.configuration.isOverwrite() && parentNode.hasNode(name)) {
                parentNode.getNode(name).remove();
            }
            if (parentNode.hasNode(name)) {
                node = parentNode.getNode(name);
            } else if (primaryNodeType == null) {
                node = parentNode.addNode(name);
                if (this.createdNodes != null) {
                    this.createdNodes.add(node.getPath());
                }
            } else {
                node = parentNode.addNode(name, primaryNodeType);
                if (this.createdNodes != null) {
                    this.createdNodes.add(node.getPath());
                }
            }
            if (mixinNodeTypes != null) {
                for (String mixin : mixinNodeTypes) {
                    if (node.isNodeType(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
            boolean bl = addToVersionables = this.configuration.isCheckin() && node.isNodeType("mix:versionable");
            if (addToVersionables) {
                this.versionables.add(node);
            }
            this.parentNodeStack.push(node);
            if (this.rootNode == null) {
                this.rootNode = node;
            }
        }
    }

    @Override
    public void createProperty(String name, int propertyType, String value) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew()) {
            return;
        }
        if (propertyType == 9) {
            String propPath = node.getPath() + "/" + name;
            String uuid = this.getUUID(node.getSession(), propPath, this.getAbsPath(node, value));
            if (uuid != null) {
                node.setProperty(name, uuid, propertyType);
            }
        } else if ("jcr:isCheckedOut".equals(name)) {
            boolean checkedout = Boolean.valueOf(value);
            if (!checkedout && !this.versionables.contains(node)) {
                this.versionables.add(node);
            }
        } else if (propertyType == 5) {
            try {
                node.setProperty(name, this.parseDateString(value));
            }
            catch (ParseException e) {
                node.setProperty(name, value, propertyType);
            }
        } else if (propertyType == 0) {
            node.setProperty(name, value);
        } else {
            node.setProperty(name, value, propertyType);
        }
    }

    @Override
    public void createProperty(String name, int propertyType, String[] values) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew()) {
            return;
        }
        if (propertyType == 9) {
            String propPath = node.getPath() + "/" + name;
            boolean hasAll = true;
            String[] uuids = new String[values.length];
            String[] uuidOrPaths = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                uuids[i] = this.getUUID(node.getSession(), propPath, this.getAbsPath(node, values[i]));
                String string = uuidOrPaths[i] = uuids[i] != null ? uuids[i] : this.getAbsPath(node, values[i]);
                if (uuids[i] != null) continue;
                hasAll = false;
            }
            node.setProperty(name, uuids, propertyType);
            if (!hasAll) {
                this.delayedMultipleReferences.put(propPath, uuidOrPaths);
            }
        } else if (propertyType == 5) {
            try {
                ValueFactory valueFactory = node.getSession().getValueFactory();
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = valueFactory.createValue(this.parseDateString(values[i]));
                }
                node.setProperty(name, jcrValues, propertyType);
            }
            catch (ParseException e) {
                this.jcrContentHelper.log.warn("Could not create dates for property, fallingback to defaults", (Throwable)e);
                node.setProperty(name, values, propertyType);
            }
        } else {
            node.setProperty(name, values, propertyType);
        }
    }

    protected Value createValue(ValueFactory factory, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return factory.createValue(((Long)value).longValue());
        }
        if (value instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)value);
            return factory.createValue(c);
        }
        if (value instanceof Calendar) {
            return factory.createValue((Calendar)value);
        }
        if (value instanceof Double) {
            return factory.createValue(((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return factory.createValue(((Boolean)value).booleanValue());
        }
        if (value instanceof InputStream) {
            return factory.createValue((InputStream)value);
        }
        return factory.createValue(value.toString());
    }

    @Override
    public void createProperty(String name, Object value) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew()) {
            return;
        }
        if (value == null) {
            if (node.hasProperty(name)) {
                node.getProperty(name).remove();
            }
        } else {
            Value jcrValue = this.createValue(node.getSession().getValueFactory(), value);
            node.setProperty(name, jcrValue);
        }
    }

    @Override
    public void createProperty(String name, Object[] values) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew()) {
            return;
        }
        if (values == null || values.length == 0) {
            if (node.hasProperty(name)) {
                node.getProperty(name).remove();
            }
        } else {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                jcrValues[i] = this.createValue(node.getSession().getValueFactory(), values[i]);
            }
            node.setProperty(name, jcrValues);
        }
    }

    @Override
    public void finishNode() throws RepositoryException {
        Node node = this.parentNodeStack.pop();
        this.resolveReferences(node);
    }

    private String getAbsPath(Node node, String path) throws RepositoryException {
        if (path.startsWith("/")) {
            return path;
        }
        while (path.startsWith("../")) {
            path = path.substring(3);
            node = node.getParent();
        }
        while (path.startsWith("./")) {
            path = path.substring(2);
        }
        return node.getPath() + "/" + path;
    }

    private String getUUID(Session session, String propPath, String referencePath) throws RepositoryException {
        if (session.itemExists(referencePath)) {
            Node refNode;
            Item item = session.getItem(referencePath);
            if (item.isNode() && (refNode = (Node)item).isNodeType("mix:referenceable")) {
                return refNode.getUUID();
            }
        } else {
            List<String> current = this.delayedReferences.get(referencePath);
            if (current == null) {
                current = new ArrayList<String>();
                this.delayedReferences.put(referencePath, current);
            }
            current.add(propPath);
        }
        return null;
    }

    private void resolveReferences(Node node) throws RepositoryException {
        List<String> props = this.delayedReferences.remove(node.getPath());
        if (props == null || props.size() == 0) {
            return;
        }
        if (!node.isNodeType("mix:referenceable")) {
            return;
        }
        Session session = node.getSession();
        String uuid = node.getUUID();
        for (String property : props) {
            String name = this.getName(property);
            Node parentNode = this.getParentNode(session, property);
            if (parentNode == null) continue;
            if (parentNode.hasProperty(name) && parentNode.getProperty(name).getDefinition().isMultiple()) {
                boolean hasAll = true;
                String[] uuidOrPaths = this.delayedMultipleReferences.get(property);
                String[] uuids = new String[uuidOrPaths.length];
                for (int i = 0; i < uuidOrPaths.length; ++i) {
                    if (uuidOrPaths[i].startsWith("/")) {
                        if (uuidOrPaths[i].equals(node.getPath())) {
                            uuidOrPaths[i] = uuid;
                            uuids[i] = uuid;
                            continue;
                        }
                        uuids[i] = null;
                        hasAll = false;
                        continue;
                    }
                    uuids[i] = uuidOrPaths[i];
                }
                parentNode.setProperty(name, uuids, 9);
                if (!hasAll) continue;
                this.delayedMultipleReferences.remove(property);
                continue;
            }
            parentNode.setProperty(name, uuid, 9);
        }
    }

    private String getName(String path) {
        int lastSlash = path.lastIndexOf(47);
        String name = lastSlash < 0 ? path : path.substring(lastSlash + 1);
        return name;
    }

    private Node getParentNode(Session session, String path) throws RepositoryException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            return session.getRootNode();
        }
        if (!session.itemExists(path = path.substring(0, lastSlash))) {
            return null;
        }
        Item item = session.getItem(path);
        return item.isNode() ? (Node)item : null;
    }

    private Calendar parseDateString(String value) throws ParseException {
        if (this.jsonDatePattern.matcher(value).matches()) {
            String modifiedJsonDate = value;
            if (value.lastIndexOf(":") == 26) {
                modifiedJsonDate = value.substring(0, 26) + value.substring(27);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.jsonDateFormat.parse(modifiedJsonDate));
            return cal;
        }
        return null;
    }

    @Override
    public void createFileAndResourceNode(String name, InputStream data, String mimeType, long lastModified) throws RepositoryException {
        int lastSlash = name.lastIndexOf(47);
        name = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        Node parentNode = this.parentNodeStack.peek();
        if (this.configuration.isOverwrite() && parentNode.hasNode(name)) {
            parentNode.getNode(name).remove();
        } else if (parentNode.hasNode(name)) {
            this.parentNodeStack.push(parentNode.getNode(name));
            this.parentNodeStack.push(parentNode.getNode(name).getNode("jcr:content"));
            return;
        }
        if (mimeType == null && (mimeType = this.jcrContentHelper.getMimeType(name)) == null) {
            this.jcrContentHelper.log.info("createFile: Cannot find content type for {}, using {}", (Object)name, (Object)DEFAULT_CONTENT_TYPE);
            mimeType = DEFAULT_CONTENT_TYPE;
        }
        if (lastModified <= 0L) {
            lastModified = System.currentTimeMillis();
        }
        this.createNode(name, "nt:file", null);
        this.createNode("jcr:content", "nt:resource", null);
        this.createProperty("jcr:mimeType", mimeType);
        this.createProperty("jcr:lastModified", lastModified);
        this.createProperty("jcr:data", data);
    }

    @Override
    public boolean switchCurrentNode(String subPath, String newNodeType) throws RepositoryException {
        if (subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(subPath, "/");
        Node node = this.parentNodeStack.peek();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!node.hasNode(token)) {
                if (newNodeType == null) {
                    return false;
                }
                Node n = node.addNode(token, newNodeType);
                if (this.createdNodes != null) {
                    this.createdNodes.add(n.getPath());
                }
            }
            node = node.getNode(token);
        }
        this.parentNodeStack.push(node);
        return true;
    }

    @Override
    public void createGroup(final String name, String[] members, Map<String, Object> extraProperties) throws RepositoryException {
        Group group;
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (authorizable == null) {
            group = userManager.createGroup(new Principal(){

                public String getName() {
                    return name;
                }
            }, this.hashPath(name));
            authorizable = group;
        } else if (!authorizable.isGroup()) {
            throw new RepositoryException("A user already exists with the requested name: " + name);
        }
        if (members != null) {
            group = (Group)authorizable;
            for (String member : members) {
                Authorizable memberAuthorizable = userManager.getAuthorizable(member);
                if (memberAuthorizable == null) continue;
                group.addMember(memberAuthorizable);
            }
        }
        if (extraProperties != null) {
            ValueFactory valueFactory = session.getValueFactory();
            Set<Map.Entry<String, Object>> entrySet = extraProperties.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Value value = this.createValue(valueFactory, entry.getValue());
                authorizable.setProperty(name, value);
            }
        }
    }

    @Override
    public void createUser(final String name, String password, Map<String, Object> extraProperties) throws RepositoryException {
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (authorizable == null) {
            String digestedPassword = this.jcrContentHelper.digestPassword(password);
            User user = userManager.createUser(name, digestedPassword, new Principal(){

                public String getName() {
                    return name;
                }
            }, this.hashPath(name));
            authorizable = user;
        } else if (authorizable.isGroup()) {
            throw new RepositoryException("A group already exists with the requested name: " + name);
        }
        if (extraProperties != null) {
            ValueFactory valueFactory = session.getValueFactory();
            Set<Map.Entry<String, Object>> entrySet = extraProperties.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Value value = this.createValue(valueFactory, entry.getValue());
                authorizable.setProperty(name, value);
            }
        }
    }

    protected String hashPath(String item) throws RepositoryException {
        try {
            String hash = DefaultContentCreator.digest("sha1", (INSTANCE_SEED + item).getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sb.append(hash, i * 2, i * 2 + 2).append("/");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException("Unable to hash the path.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Unable to hash the path.", (Throwable)e);
        }
    }

    @Override
    public void createAce(String principalId, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames) throws RepositoryException {
        AccessControlPolicy[] policies;
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        Authorizable authorizable = userManager.getAuthorizable(principalId);
        if (authorizable == null) {
            throw new RepositoryException("No principal found for id: " + principalId);
        }
        String resourcePath = parentNode.getPath();
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlList updatedAcl = null;
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            updatedAcl = (AccessControlList)policy;
            break;
        }
        if (updatedAcl == null) {
            AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                updatedAcl = (AccessControlList)policy;
            }
        }
        if (updatedAcl == null) {
            throw new RepositoryException("Unable to find or create an access control policy to update for " + resourcePath);
        }
        HashSet<String> postedPrivilegeNames = new HashSet<String>();
        if (grantedPrivilegeNames != null) {
            postedPrivilegeNames.addAll(Arrays.asList(grantedPrivilegeNames));
        }
        if (deniedPrivilegeNames != null) {
            postedPrivilegeNames.addAll(Arrays.asList(deniedPrivilegeNames));
        }
        ArrayList<Privilege> preserveGrantedPrivileges = new ArrayList<Privilege>();
        ArrayList<Privilege> preserveDeniedPrivileges = new ArrayList<Privilege>();
        AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
        ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
        for (AccessControlEntry ace : accessControlEntries) {
            Privilege[] privileges;
            if (!principalId.equals(ace.getPrincipal().getName())) continue;
            oldAces.add(ace);
            boolean isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace);
            for (Privilege privilege : privileges = ace.getPrivileges()) {
                String privilegeName = privilege.getName();
                if (postedPrivilegeNames.contains(privilegeName)) continue;
                if (isAllow) {
                    preserveGrantedPrivileges.add(privilege);
                    continue;
                }
                preserveDeniedPrivileges.add(privilege);
            }
        }
        if (!oldAces.isEmpty()) {
            for (AccessControlEntry ace : oldAces) {
                updatedAcl.removeAccessControlEntry(ace);
            }
        }
        ArrayList<Privilege> grantedPrivilegeList = new ArrayList<Privilege>();
        if (grantedPrivilegeNames != null) {
            for (String name : grantedPrivilegeNames) {
                if (name.length() == 0) continue;
                Privilege privilege = accessControlManager.privilegeFromName(name);
                grantedPrivilegeList.add(privilege);
            }
        }
        grantedPrivilegeList.addAll(preserveGrantedPrivileges);
        if (grantedPrivilegeList.size() > 0) {
            Principal principal = authorizable.getPrincipal();
            updatedAcl.addAccessControlEntry(principal, grantedPrivilegeList.toArray(new Privilege[grantedPrivilegeList.size()]));
        }
        if (!authorizable.isGroup()) {
            ArrayList<Privilege> deniedPrivilegeList = new ArrayList<Privilege>();
            if (deniedPrivilegeNames != null) {
                for (String name : deniedPrivilegeNames) {
                    if (name.length() == 0) continue;
                    Privilege privilege = accessControlManager.privilegeFromName(name);
                    deniedPrivilegeList.add(privilege);
                }
            }
            deniedPrivilegeList.addAll(preserveDeniedPrivileges);
            if (deniedPrivilegeList.size() > 0) {
                Principal principal = authorizable.getPrincipal();
                AccessControlUtil.addEntry((AccessControlList)updatedAcl, (Principal)principal, (Privilege[])deniedPrivilegeList.toArray(new Privilege[deniedPrivilegeList.size()]), (boolean)false);
            }
        }
        accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
    }

    public static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(data);
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }
}

