/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Dictionary;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.JcrContentHelper;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContentImporter
extends BaseImportLoader
implements JcrContentHelper,
ContentImporter {
    private final Logger log = LoggerFactory.getLogger(DefaultContentImporter.class);
    private MimeTypeService mimeTypeService;
    private static final String PROP_PASSWORD_DIGEST_ALGORITHM = "password.digest.algorithm";
    private static final String DEFAULT_PASSWORD_DIGEST_ALGORITHM = "sha1";
    private String passwordDigestAlgoritm = null;

    public void importContent(Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        Node node;
        if (name.endsWith(".jcr.xml") && (node = this.importSystemView(parent, name, contentStream)) != null) {
            if (importListener != null) {
                importListener.onCreate(node.getPath());
            }
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        ArrayList<String> createdPaths = new ArrayList<String>();
        contentCreator.init(importOptions, this.defaultImportProviders, createdPaths, importListener);
        contentCreator.prepareParsing(parent, this.toPlainName(contentCreator, name));
        ImportProvider ip = contentCreator.getImportProvider(name);
        ContentReader reader = ip.getReader();
        reader.parse(contentStream, (ContentCreator)contentCreator);
        Session session = parent.getSession();
        session.save();
        for (Node versionable : contentCreator.getVersionables()) {
            versionable.checkin();
        }
    }

    private String toPlainName(DefaultContentCreator contentCreator, String name) {
        String providerExt = contentCreator.getImportProviderExtension(name);
        if (providerExt != null) {
            if (name.length() == providerExt.length()) {
                return null;
            }
            return name.substring(0, name.length() - providerExt.length());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Node importSystemView(Node parent, String name, InputStream contentStream) throws IOException {
        Node node;
        InputStream ins;
        block16: {
            block14: {
                Node node2;
                block15: {
                    ins = null;
                    if (name.endsWith(".jcr.xml")) {
                        name = name.substring(0, name.length() - ".jcr.xml".length());
                    }
                    if (!parent.hasNode(name)) break block14;
                    this.log.debug("importSystemView: Node {} for XML already exists, nothing to to", (Object)name);
                    node2 = parent.getNode(name);
                    Object var8_9 = null;
                    if (ins == null) break block15;
                    try {
                        ins.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                return node2;
            }
            ins = contentStream;
            Session session = parent.getSession();
            session.importXML(parent.getPath(), ins, 0);
            node = parent.hasNode(name) ? parent.getNode(name) : null;
            Object var8_10 = null;
            if (ins == null) break block16;
            try {
                ins.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return node;
        catch (InvalidSerializedDataException isde) {
            Node node3;
            block17: {
                this.log.info("importSystemView: XML does not seem to be system view export, trying old style; cause: {}", (Object)isde.toString());
                node3 = null;
                Object var8_11 = null;
                if (ins == null) break block17;
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node3;
        }
        catch (RepositoryException re) {
            Node node4;
            block18: {
                this.log.info("importSystemView: Repository issue loading XML, trying old style; cause: {}", (Object)re.toString());
                node4 = null;
                Object var8_12 = null;
                if (ins == null) break block18;
                {
                    catch (Throwable throwable) {
                        block19: {
                            Object var8_13 = null;
                            if (ins == null) break block19;
                            try {
                                ins.close();
                            }
                            catch (IOException ignore) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ins.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            return node4;
        }
    }

    public String digestPassword(String pwd) throws IllegalArgumentException {
        try {
            StringBuffer password = new StringBuffer();
            password.append("{").append(this.passwordDigestAlgoritm).append("}");
            password.append(DefaultContentCreator.digest(this.passwordDigestAlgoritm, pwd.getBytes("UTF-8")));
            return password.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary props = componentContext.getProperties();
        Object propValue = props.get(PROP_PASSWORD_DIGEST_ALGORITHM);
        this.passwordDigestAlgoritm = propValue instanceof String ? (String)propValue : DEFAULT_PASSWORD_DIGEST_ALGORITHM;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.passwordDigestAlgoritm = null;
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

