/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEntry
extends ImportOptions {
    public static final String CONTENT_HEADER = "Sling-Initial-Content";
    public static final String OVERWRITE_DIRECTIVE = "overwrite";
    public static final String OVERWRITE_PROPERTIES_DIRECTIVE = "overwriteProperties";
    public static final String UNINSTALL_DIRECTIVE = "uninstall";
    public static final String PATH_DIRECTIVE = "path";
    public static final String WORKSPACE_DIRECTIVE = "workspace";
    public static final String CHECKIN_DIRECTIVE = "checkin";
    public static final String IGNORE_IMPORT_PROVIDERS_DIRECTIVE = "ignoreImportProviders";
    private final String path;
    private final boolean overwrite;
    private final boolean overwriteProperties;
    private final boolean uninstall;
    private final boolean checkin;
    private final List<String> ignoreImportProviders;
    private final String target;
    private final String workspace;

    public static Iterator<PathEntry> getContentPaths(Bundle bundle) {
        ArrayList<PathEntry> entries = new ArrayList<PathEntry>();
        String root = (String)bundle.getHeaders().get(CONTENT_HEADER);
        if (root != null) {
            ManifestHeader header = ManifestHeader.parse((String)root);
            for (ManifestHeader.Entry entry : header.getEntries()) {
                entries.add(new PathEntry(entry));
            }
        }
        if (entries.size() == 0) {
            return null;
        }
        return entries.iterator();
    }

    public PathEntry(ManifestHeader.Entry entry) {
        this.path = entry.getValue();
        String overwriteValue = entry.getDirectiveValue(OVERWRITE_DIRECTIVE);
        this.overwrite = overwriteValue != null ? Boolean.valueOf(overwriteValue) : false;
        String overwritePropertiesValue = entry.getDirectiveValue(OVERWRITE_PROPERTIES_DIRECTIVE);
        this.overwriteProperties = overwritePropertiesValue != null ? Boolean.valueOf(overwritePropertiesValue) : false;
        String uninstallValue = entry.getDirectiveValue(UNINSTALL_DIRECTIVE);
        this.uninstall = uninstallValue != null ? Boolean.valueOf(uninstallValue) : this.overwrite;
        String pathValue = entry.getDirectiveValue(PATH_DIRECTIVE);
        this.target = pathValue != null ? pathValue : null;
        String checkinValue = entry.getDirectiveValue(CHECKIN_DIRECTIVE);
        this.checkin = checkinValue != null ? Boolean.valueOf(checkinValue) : false;
        this.ignoreImportProviders = new ArrayList<String>();
        String expandValue = entry.getDirectiveValue(IGNORE_IMPORT_PROVIDERS_DIRECTIVE);
        if (expandValue != null && expandValue.length() > 0) {
            StringTokenizer st = new StringTokenizer(expandValue, ",");
            while (st.hasMoreTokens()) {
                this.ignoreImportProviders.add(st.nextToken());
            }
        }
        String workspaceValue = entry.getDirectiveValue(WORKSPACE_DIRECTIVE);
        this.workspace = pathValue != null ? workspaceValue : null;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isPropertyOverwrite() {
        return this.overwriteProperties;
    }

    public boolean isUninstall() {
        return this.uninstall;
    }

    @Override
    public boolean isCheckin() {
        return this.checkin;
    }

    @Override
    public boolean isIgnoredImportProvider(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return this.ignoreImportProviders.contains(extension);
    }

    public String getTarget() {
        return this.target;
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

