/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;

public class JsonReader
implements ContentReader {
    private static final Pattern jsonDate = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");
    private static final String REFERENCE = "jcr:reference:";
    private static final String PATH = "jcr:path:";
    private static final String NAME = "jcr:name:";
    private static final String URI = "jcr:uri:";
    private static final Set<String> ignoredNames = new HashSet<String>();
    private static final Set<String> ignoredPrincipalPropertyNames;
    private static final String SECURITY_PRINCIPLES = "security:principals";
    private static final String SECURITY_ACL = "security:acl";
    public static final ImportProvider PROVIDER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(URL url, ContentCreator contentCreator) throws IOException, RepositoryException {
        InputStream ins = null;
        try {
            ins = url.openStream();
            this.parse(ins, contentCreator);
            Object var5_4 = null;
            if (ins == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ins == null) throw throwable;
            try {
                ins.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ins.close();
            return;
        }
        catch (IOException ignore) {}
    }

    public void parse(InputStream ins, ContentCreator contentCreator) throws IOException, RepositoryException {
        try {
            String jsonString = this.toString(ins).trim();
            if (!jsonString.startsWith("{")) {
                jsonString = "{" + jsonString + "}";
            }
            JSONObject json = new JSONObject(jsonString);
            this.createNode(null, json, contentCreator);
        }
        catch (JSONException je) {
            throw (IOException)new IOException(je.getMessage()).initCause(je);
        }
    }

    protected void createNode(String name, JSONObject obj, ContentCreator contentCreator) throws JSONException, RepositoryException {
        int i;
        Object primaryTypeObj = obj.opt("jcr:primaryType");
        String primaryType = null;
        if (primaryTypeObj != null) {
            primaryType = String.valueOf(primaryTypeObj);
        }
        String[] mixinTypes = null;
        Object mixinsObject = obj.opt("jcr:mixinTypes");
        if (mixinsObject instanceof JSONArray) {
            JSONArray mixins = (JSONArray)mixinsObject;
            mixinTypes = new String[mixins.length()];
            for (i = 0; i < mixins.length(); ++i) {
                mixinTypes[i] = mixins.getString(i);
            }
        }
        contentCreator.createNode(name, primaryType, mixinTypes);
        JSONArray names = obj.names();
        for (i = 0; names != null && i < names.length(); ++i) {
            String n = names.getString(i);
            if (ignoredNames.contains(n)) continue;
            Object o = obj.get(n);
            if (SECURITY_PRINCIPLES.equals(n)) {
                this.createPrincipals(o, contentCreator);
                continue;
            }
            if (SECURITY_ACL.equals(n)) {
                this.createAcl(o, contentCreator);
                continue;
            }
            if (o instanceof JSONObject) {
                this.createNode(n, (JSONObject)o, contentCreator);
                continue;
            }
            this.createProperty(n, o, contentCreator);
        }
        contentCreator.finishNode();
    }

    protected void createProperty(String name, Object value, ContentCreator contentCreator) throws JSONException, RepositoryException {
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            if (array.length() > 0) {
                String[] values = new String[array.length()];
                for (int i = 0; i < array.length(); ++i) {
                    values[i] = array.get(i).toString();
                }
                int propertyType = this.getType(name, array.get(0));
                contentCreator.createProperty(this.getName(name), propertyType, values);
            } else {
                contentCreator.createProperty(this.getName(name), 1, new String[0]);
            }
        } else {
            int propertyType = this.getType(name, value);
            contentCreator.createProperty(this.getName(name), propertyType, value.toString());
        }
    }

    protected int getType(String name, Object object) {
        if (object instanceof Double || object instanceof Float) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 6;
        }
        if (object instanceof String) {
            if (name.startsWith(REFERENCE)) {
                return 9;
            }
            if (name.startsWith(PATH)) {
                return 8;
            }
            if (name.startsWith(NAME)) {
                return 7;
            }
            if (name.startsWith(URI)) {
                return 11;
            }
            if (jsonDate.matcher((String)object).matches()) {
                return 5;
            }
        }
        return 0;
    }

    protected String getName(String name) {
        if (name.startsWith(REFERENCE)) {
            return name.substring(REFERENCE.length());
        }
        if (name.startsWith(PATH)) {
            return name.substring(PATH.length());
        }
        if (name.startsWith(NAME)) {
            return name.substring(NAME.length());
        }
        if (name.startsWith(URI)) {
            return name.substring(URI.length());
        }
        return name;
    }

    private String toString(InputStream ins) throws IOException {
        int rd;
        String encoding;
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        ins.mark(5);
        int c = ins.read();
        if (c == 35) {
            StringBuffer buf = new StringBuffer();
            c = ins.read();
            while (!Character.isWhitespace((char)c)) {
                buf.append((char)c);
                c = ins.read();
            }
            encoding = buf.toString();
        } else {
            ins.reset();
            encoding = "UTF-8";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((rd = ins.read(buf)) >= 0) {
            bos.write(buf, 0, rd);
        }
        bos.close();
        return new String(bos.toByteArray(), encoding);
    }

    protected void createPrincipals(Object obj, ContentCreator contentCreator) throws JSONException, RepositoryException {
        if (obj instanceof JSONObject) {
            this.createPrincipal((JSONObject)obj, contentCreator);
        } else if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JSONObject)) {
                    throw new JSONException("Unexpected data type in principals array: " + object.getClass().getName());
                }
                this.createPrincipal((JSONObject)object, contentCreator);
            }
        }
    }

    protected void createPrincipal(JSONObject json, ContentCreator contentCreator) throws JSONException, RepositoryException {
        String name = json.getString("name");
        boolean isGroup = json.optBoolean("isgroup", false);
        LinkedHashMap<String, Object> extraProps = new LinkedHashMap<String, Object>();
        JSONArray names = json.names();
        for (int p = 0; p < names.length(); ++p) {
            String propName = names.getString(p);
            if (ignoredPrincipalPropertyNames.contains(propName)) continue;
            Object value = json.get(propName);
            extraProps.put(propName, value);
        }
        if (isGroup) {
            String[] members = null;
            JSONArray membersJSONArray = json.optJSONArray("members");
            if (membersJSONArray != null) {
                members = new String[membersJSONArray.length()];
                for (int i = 0; i < membersJSONArray.length(); ++i) {
                    members[i] = membersJSONArray.getString(i);
                }
            }
            contentCreator.createGroup(name, members, extraProps);
        } else {
            String password = json.getString("password");
            contentCreator.createUser(name, password, extraProps);
        }
    }

    protected void createAcl(Object obj, ContentCreator contentCreator) throws JSONException, RepositoryException {
        if (obj instanceof JSONObject) {
            this.createAce((JSONObject)obj, contentCreator);
        } else if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JSONObject)) {
                    throw new JSONException("Unexpected data type in acl array: " + object.getClass().getName());
                }
                this.createAce((JSONObject)object, contentCreator);
            }
        }
    }

    protected void createAce(JSONObject ace, ContentCreator contentCreator) throws JSONException, RepositoryException {
        String principalID = ace.getString("principal");
        String[] grantedPrivileges = null;
        JSONArray granted = ace.optJSONArray("granted");
        if (granted != null) {
            grantedPrivileges = new String[granted.length()];
            for (int a = 0; a < granted.length(); ++a) {
                grantedPrivileges[a] = granted.getString(a);
            }
        }
        String[] deniedPrivileges = null;
        JSONArray denied = ace.optJSONArray("denied");
        if (denied != null) {
            deniedPrivileges = new String[denied.length()];
            for (int a = 0; a < denied.length(); ++a) {
                deniedPrivileges[a] = denied.getString(a);
            }
        }
        String order = ace.optString("order", null);
        contentCreator.createAce(principalID, grantedPrivileges, deniedPrivileges, order);
    }

    static {
        ignoredNames.add("jcr:primaryType");
        ignoredNames.add("jcr:mixinTypes");
        ignoredNames.add("jcr:uuid");
        ignoredNames.add("jcr:baseVersion");
        ignoredNames.add("jcr:predecessors");
        ignoredNames.add("jcr:successors");
        ignoredNames.add("jcr:checkedOut");
        ignoredNames.add("jcr:created");
        ignoredPrincipalPropertyNames = new HashSet<String>();
        ignoredPrincipalPropertyNames.add("name");
        ignoredPrincipalPropertyNames.add("isgroup");
        ignoredPrincipalPropertyNames.add("members");
        ignoredPrincipalPropertyNames.add("dynamic");
        ignoredPrincipalPropertyNames.add("password");
        PROVIDER = new ImportProvider(){
            private JsonReader jsonReader;

            public ContentReader getReader() {
                if (this.jsonReader == null) {
                    this.jsonReader = new JsonReader();
                }
                return this.jsonReader;
            }
        };
    }
}

