/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.readers.JsonReader;
import org.apache.sling.jcr.contentloader.internal.readers.XmlReader;
import org.apache.sling.jcr.contentloader.internal.readers.ZipReader;

public abstract class BaseImportLoader {
    public static final String EXT_XML = ".xml";
    public static final String EXT_JCR_XML = ".jcr.xml";
    public static final String EXT_JSON = ".json";
    public static final String EXT_JAR = ".jar";
    public static final String EXT_ZIP = ".zip";
    Map<String, ImportProvider> defaultImportProviders = new LinkedHashMap<String, ImportProvider>();

    public BaseImportLoader() {
        this.defaultImportProviders.put(EXT_JCR_XML, null);
        this.defaultImportProviders.put(EXT_JSON, JsonReader.PROVIDER);
        this.defaultImportProviders.put(EXT_XML, XmlReader.PROVIDER);
        this.defaultImportProviders.put(EXT_JAR, ZipReader.JAR_PROVIDER);
        this.defaultImportProviders.put(EXT_ZIP, ZipReader.ZIP_PROVIDER);
    }

    public void dispose() {
        this.defaultImportProviders = null;
    }
}

