/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class XmlReader
implements ContentReader {
    private static final Logger logger = LoggerFactory.getLogger(XmlReader.class);
    private static final String ELEM_NODE = "node";
    private static final String ELEM_PRIMARY_NODE_TYPE = "primaryNodeType";
    private static final String ELEM_MIXIN_NODE_TYPE = "mixinNodeType";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_NAME = "name";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_VALUES = "values";
    private static final String ELEM_TYPE = "type";
    private static final String XML_STYLESHEET_PROCESSING_INSTRUCTION = "xml-stylesheet";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String ELEM_FILE_NAMESPACE = "http://www.jcp.org/jcr/nt/1.0";
    private static final String ELEM_FILE_NAME = "file";
    public static final ImportProvider PROVIDER = new ImportProvider(){
        private XmlReader xmlReader;

        public ContentReader getReader() throws IOException {
            if (this.xmlReader == null) {
                try {
                    this.xmlReader = new XmlReader();
                }
                catch (Throwable t) {
                    throw (IOException)new IOException(t.getMessage()).initCause(t);
                }
            }
            return this.xmlReader;
        }
    };
    private KXmlParser xmlParser = new KXmlParser();

    XmlReader() {
        try {
            this.xmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void parse(URL url, ContentCreator creator) throws IOException, RepositoryException {
        BufferedInputStream bufferedInput = null;
        try {
            try {
                bufferedInput = new BufferedInputStream(url.openStream());
                this.parseInternal(bufferedInput, creator, url);
            }
            catch (XmlPullParserException xppe) {
                throw (IOException)new IOException(xppe.getMessage()).initCause(xppe);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            XmlReader.closeStream(bufferedInput);
            throw throwable;
        }
        XmlReader.closeStream(bufferedInput);
    }

    public void parse(InputStream ins, ContentCreator creator) throws IOException, RepositoryException {
        BufferedInputStream bufferedInput = null;
        try {
            try {
                bufferedInput = new BufferedInputStream(ins);
                URL xmlLocation = null;
                this.parseInternal(bufferedInput, creator, xmlLocation);
            }
            catch (XmlPullParserException xppe) {
                throw (IOException)new IOException(xppe.getMessage()).initCause(xppe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            XmlReader.closeStream(bufferedInput);
            throw throwable;
        }
        XmlReader.closeStream(bufferedInput);
    }

    private void parseInternal(InputStream bufferedInput, ContentCreator creator, URL xmlLocation) throws XmlPullParserException, IOException, RepositoryException {
        StringBuilder contentBuffer = new StringBuilder();
        bufferedInput.mark(bufferedInput.available());
        this.xmlParser.setInput(bufferedInput, null);
        NodeDescription.SHARED.clear();
        PropertyDescription.SHARED.clear();
        FileDescription.SHARED.clear();
        NodeDescription currentNode = null;
        PropertyDescription currentProperty = null;
        int eventType = this.xmlParser.getEventType();
        while (eventType != 1) {
            ProcessingInstruction pi;
            if (eventType == 8 && (pi = new ProcessingInstruction(this.xmlParser.getText())).getName().equals(XML_STYLESHEET_PROCESSING_INSTRUCTION) && xmlLocation != null) {
                bufferedInput.reset();
                XslTransformerStream transformerStream = new XslTransformerStream(bufferedInput, pi.getAttribute(HREF_ATTRIBUTE), xmlLocation);
                transformerStream.startTransform();
                this.parseInternal(transformerStream, creator, xmlLocation);
                transformerStream.close();
                return;
            }
            if (eventType == 2) {
                String currentElement = this.xmlParser.getName();
                if (ELEM_PROPERTY.equals(currentElement)) {
                    currentNode = NodeDescription.create(currentNode, creator);
                    currentProperty = PropertyDescription.SHARED;
                } else if (ELEM_NODE.equals(currentElement)) {
                    currentNode = NodeDescription.create(currentNode, creator);
                    currentNode = NodeDescription.SHARED;
                } else if (ELEM_FILE_NAME.equals(currentElement) && ELEM_FILE_NAMESPACE.equals(this.xmlParser.getNamespace())) {
                    if (xmlLocation != null) {
                        int attributeCount = this.xmlParser.getAttributeCount();
                        if (attributeCount < 2 || attributeCount > 3) {
                            throw new IOException("File element must have these attributes: url, mimeType and lastModified: " + xmlLocation);
                        }
                        try {
                            AttributeMap attributes = AttributeMap.getInstance();
                            attributes.setValues(this.xmlParser);
                            FileDescription.SHARED.setBaseLocation(xmlLocation);
                            FileDescription.SHARED.setValues(attributes);
                            attributes.clear();
                        }
                        catch (ParseException e) {
                            IOException ioe = new IOException("Error parsing file description: " + xmlLocation);
                            ioe.initCause(e);
                            throw ioe;
                        }
                        FileDescription.SHARED.create(creator);
                        FileDescription.SHARED.clear();
                    } else {
                        logger.warn("file element encountered when xml location isn't known. skipping.");
                    }
                }
            } else if (eventType == 3) {
                String qName = this.xmlParser.getName();
                String content = contentBuffer.toString().trim();
                contentBuffer.delete(0, contentBuffer.length());
                if (ELEM_PROPERTY.equals(qName)) {
                    currentProperty = PropertyDescription.create(currentProperty, creator);
                } else if (ELEM_NAME.equals(qName)) {
                    if (currentProperty != null) {
                        currentProperty.name = content;
                    } else if (currentNode != null) {
                        currentNode.name = content;
                    }
                } else if (ELEM_VALUE.equals(qName)) {
                    if (currentProperty == null) {
                        throw new IOException("XML file does not seem to contain valid content xml. Unexpected value element in : " + xmlLocation);
                    }
                    currentProperty.addValue(content);
                } else if (ELEM_VALUES.equals(qName)) {
                    if (currentProperty == null) {
                        throw new IOException("XML file does not seem to contain valid content xml. Unexpected value element in : " + xmlLocation);
                    }
                    currentProperty.isMultiValue = true;
                } else if (ELEM_TYPE.equals(qName)) {
                    if (currentProperty == null) {
                        throw new IOException("XML file does not seem to contain valid content xml. Unexpected value element in : " + xmlLocation);
                    }
                    currentProperty.type = content;
                } else if (ELEM_NODE.equals(qName)) {
                    currentNode = NodeDescription.create(currentNode, creator);
                    creator.finishNode();
                } else if (ELEM_PRIMARY_NODE_TYPE.equals(qName)) {
                    if (currentNode == null) {
                        throw new IOException("Element is not allowed at this location: " + qName + " in " + xmlLocation);
                    }
                    currentNode.primaryNodeType = content;
                } else if (ELEM_MIXIN_NODE_TYPE.equals(qName)) {
                    if (currentNode == null) {
                        throw new IOException("Element is not allowed at this location: " + qName + " in " + xmlLocation);
                    }
                    currentNode.addMixinType(content);
                }
            } else if (eventType == 4 || eventType == 5) {
                contentBuffer.append(this.xmlParser.getText());
            }
            eventType = this.xmlParser.nextToken();
        }
    }

    private static void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AttributeMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = -6304058237706001104L;
        private static final AttributeMap instance = new AttributeMap();

        protected AttributeMap() {
        }

        public static AttributeMap getInstance() {
            return instance;
        }

        public void setValues(KXmlParser xmlParser) {
            int count = xmlParser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                this.put(xmlParser.getAttributeName(i), xmlParser.getAttributeValue(i));
            }
        }
    }

    protected static final class FileDescription {
        private URL url;
        private String mimeType;
        private URL baseLocation;
        private Long lastModified;
        public static FileDescription SHARED = new FileDescription();
        private static final String SRC_ATTRIBUTE = "src";
        private static final String MIME_TYPE_ATTRIBUTE = "mimeType";
        private static final String LAST_MODIFIED_ATTRIBUTE = "lastModified";
        public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

        protected FileDescription() {
        }

        public void setValues(AttributeMap attributes) throws MalformedURLException, ParseException {
            Set attributeNames = attributes.keySet();
            for (String name : attributeNames) {
                String value = (String)attributes.get(name);
                if (name.equals(SRC_ATTRIBUTE)) {
                    this.url = new URL(this.baseLocation, value);
                    continue;
                }
                if (name.equals(MIME_TYPE_ATTRIBUTE)) {
                    this.mimeType = value;
                    continue;
                }
                if (!name.equals(LAST_MODIFIED_ATTRIBUTE)) continue;
                this.lastModified = DATE_FORMAT.parse(value).getTime();
            }
        }

        public void create(ContentCreator creator) throws RepositoryException, IOException {
            String[] parts = this.url.getPath().split("/");
            String name = parts[parts.length - 1];
            InputStream stream = this.url.openStream();
            if (this.lastModified == null) {
                try {
                    this.lastModified = new File(this.url.toURI()).lastModified();
                }
                catch (Throwable ignore) {
                    this.lastModified = Calendar.getInstance().getTimeInMillis();
                }
            }
            creator.createFileAndResourceNode(name, stream, this.mimeType, this.lastModified);
            XmlReader.closeStream(stream);
            creator.finishNode();
            creator.finishNode();
            this.clear();
        }

        public URL getUrl() {
            return this.url;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Long getLastModified() {
            return this.lastModified;
        }

        public void clear() {
            this.url = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        public void setBaseLocation(URL xmlLocation) {
            this.baseLocation = xmlLocation;
        }

        static {
            DATE_FORMAT.setLenient(true);
        }
    }

    private static class ProcessingInstruction {
        private Map<String, String> attributes = new HashMap<String, String>();
        private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s(.[^=\\s]*)\\s?=\\s?\"(.[^\"]*)\"");
        private static final Pattern NAME_PATTERN = Pattern.compile("^(.[^\\s\\?>]*)");
        private String name;

        public ProcessingInstruction(String text) throws IOException {
            Matcher nameMatcher = NAME_PATTERN.matcher(text);
            if (!nameMatcher.find()) {
                throw new IOException("Malformed processing instruction: " + text);
            }
            this.name = nameMatcher.group(1);
            Matcher attributeMatcher = ATTRIBUTE_PATTERN.matcher(text);
            while (attributeMatcher.find()) {
                this.attributes.put(attributeMatcher.group(1), attributeMatcher.group(2));
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }
    }

    protected static final class PropertyDescription {
        public static PropertyDescription SHARED = new PropertyDescription();
        public String name;
        public String type;
        public List<String> values;
        public boolean isMultiValue;

        protected PropertyDescription() {
        }

        public static PropertyDescription create(PropertyDescription desc, ContentCreator creator) throws RepositoryException {
            int type;
            int n = type = desc.type == null ? 1 : PropertyType.valueFromName((String)desc.type);
            if (desc.isMultiValue) {
                creator.createProperty(desc.name, type, desc.getPropertyValues());
            } else {
                String value = null;
                if (desc.values != null && desc.values.size() == 1) {
                    value = desc.values.get(0);
                }
                creator.createProperty(desc.name, type, value);
            }
            desc.clear();
            return null;
        }

        public void addValue(String v) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(v);
        }

        private String[] getPropertyValues() {
            if (this.values == null || this.values.size() == 0) {
                return null;
            }
            return this.values.toArray(new String[this.values.size()]);
        }

        private void clear() {
            this.name = null;
            this.type = null;
            if (this.values != null) {
                this.values.clear();
            }
            this.isMultiValue = false;
        }
    }

    protected static final class NodeDescription {
        public static NodeDescription SHARED = new NodeDescription();
        public String name;
        public String primaryNodeType;
        public List<String> mixinTypes;

        protected NodeDescription() {
        }

        public static NodeDescription create(NodeDescription desc, ContentCreator creator) throws RepositoryException {
            if (desc != null) {
                creator.createNode(desc.name, desc.primaryNodeType, desc.getMixinTypes());
                desc.clear();
            }
            return null;
        }

        public void addMixinType(String v) {
            if (this.mixinTypes == null) {
                this.mixinTypes = new ArrayList<String>();
            }
            this.mixinTypes.add(v);
        }

        private String[] getMixinTypes() {
            if (this.mixinTypes == null || this.mixinTypes.size() == 0) {
                return null;
            }
            return this.mixinTypes.toArray(new String[this.mixinTypes.size()]);
        }

        private void clear() {
            this.name = null;
            this.primaryNodeType = null;
            if (this.mixinTypes != null) {
                this.mixinTypes.clear();
            }
        }
    }

    private static class XslTransformerStream
    extends PipedInputStream {
        private InputStream inputXml;
        private String xslHref;
        private Thread transformerThread;
        private PipedOutputStream pipedOut;
        private URL xmlLocation;

        public XslTransformerStream(InputStream inputXml, String xslHref, URL xmlLocation) throws IOException {
            this.inputXml = inputXml;
            this.xslHref = xslHref;
            this.transformerThread = null;
            this.pipedOut = new PipedOutputStream(this);
            this.xmlLocation = xmlLocation;
        }

        public void startTransform() throws IOException {
            final URL xslResource = new URL(this.xmlLocation, this.xslHref);
            this.transformerThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        try {
                            StreamSource xml = new StreamSource(XslTransformerStream.this.inputXml);
                            StreamSource xsl = new StreamSource(xslResource.toExternalForm());
                            Templates templates = TransformerFactory.newInstance().newTemplates(xsl);
                            StreamResult streamResult = new StreamResult(XslTransformerStream.this.pipedOut);
                            templates.newTransformer().transform(xml, streamResult);
                        }
                        catch (TransformerConfigurationException e) {
                            throw new RuntimeException("Error initializing XSL transformer", e);
                        }
                        catch (TransformerException e) {
                            throw new RuntimeException("Error transforming", e);
                        }
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        XmlReader.closeStream(XslTransformerStream.this.pipedOut);
                        throw throwable;
                    }
                    XmlReader.closeStream(XslTransformerStream.this.pipedOut);
                }
            }, "XslTransformerThread");
            this.transformerThread.start();
        }
    }
}

