/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.BaseImportLoader;
import org.apache.sling.jcr.contentloader.internal.ContentCreator;
import org.apache.sling.jcr.contentloader.internal.ContentReader;
import org.apache.sling.jcr.contentloader.internal.DefaultContentCreator;
import org.apache.sling.jcr.contentloader.internal.ImportProvider;
import org.apache.sling.jcr.contentloader.internal.JcrContentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContentImporter
extends BaseImportLoader
implements JcrContentHelper,
ContentImporter {
    private final Logger log = LoggerFactory.getLogger(DefaultContentImporter.class);
    private MimeTypeService mimeTypeService;

    public void importContent(Node parent, String name, InputStream contentStream, ImportOptions importOptions, ContentImportListener importListener) throws RepositoryException, IOException {
        boolean replace;
        Node node;
        if (name.endsWith(".jcr.xml") && (node = this.importSystemView(parent, name, contentStream, replace = importOptions == null ? false : importOptions.isOverwrite())) != null) {
            if (importListener != null) {
                importListener.onCreate(node.getPath());
            }
            return;
        }
        DefaultContentCreator contentCreator = new DefaultContentCreator(this);
        ArrayList<String> createdPaths = new ArrayList<String>();
        contentCreator.init(importOptions, this.defaultImportProviders, createdPaths, importListener);
        contentCreator.prepareParsing(parent, this.toPlainName(contentCreator, name));
        ImportProvider ip = contentCreator.getImportProvider(name);
        ContentReader reader = ip.getReader();
        reader.parse(contentStream, (ContentCreator)contentCreator);
        Session session = parent.getSession();
        session.save();
        for (Node versionable : contentCreator.getVersionables()) {
            versionable.checkin();
            if (importListener == null) continue;
            importListener.onCheckin(versionable.getPath());
        }
    }

    private String toPlainName(DefaultContentCreator contentCreator, String name) {
        String providerExt = contentCreator.getImportProviderExtension(name);
        if (providerExt != null) {
            if (name.length() == providerExt.length()) {
                return null;
            }
            return name.substring(0, name.length() - providerExt.length());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node importSystemView(Node parent, String name, InputStream contentStream, boolean replace) throws IOException {
        Node node;
        Node node2;
        InputStream ins = null;
        try {
            String nodeName;
            String string = nodeName = name.endsWith(".jcr.xml") ? name.substring(0, name.length() - ".jcr.xml".length()) : name;
            if (nodeName.length() == 0) {
                throw new IOException("Node name must not be empty (or extension only)");
            }
            if (parent.hasNode(nodeName)) {
                Node existingNode = parent.getNode(nodeName);
                if (replace) {
                    this.log.debug("importSystemView: Removing existing node at {}", (Object)nodeName);
                    existingNode.remove();
                } else {
                    this.log.debug("importSystemView: Node {} for XML already exists, nothing to to", (Object)nodeName);
                    Node node3 = existingNode;
                    return node3;
                }
            }
            ins = contentStream;
            Session session = parent.getSession();
            session.importXML(parent.getPath(), ins, 0);
            node2 = parent.hasNode(nodeName) ? parent.getNode(nodeName) : null;
        }
        catch (InvalidSerializedDataException isde) {
            this.log.info("importSystemView: XML does not seem to be system view export, trying old style; cause: {}", (Object)isde.toString());
            node = null;
            return node;
        }
        catch (RepositoryException re) {
            this.log.info("importSystemView: Repository issue loading XML, trying old style; cause: {}", (Object)re.toString());
            node = null;
            return node;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return node2;
    }

    public String getMimeType(String name) {
        MimeTypeService mts = this.mimeTypeService;
        return mts != null ? mts.getMimeType(name) : null;
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

