/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;

@Component
@Service
@Properties(value={@Property(name="extensions", value={"json"}), @Property(name="contentTypes", value={"application/json"})})
public class JsonReader
implements ContentReader {
    private static final Pattern jsonDate = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");
    private static final String REFERENCE = "jcr:reference:";
    private static final String PATH = "jcr:path:";
    private static final String NAME = "jcr:name:";
    private static final String URI = "jcr:uri:";
    protected static final Set<String> ignoredNames = new HashSet<String>();
    private static final Set<String> ignoredPrincipalPropertyNames;
    private static final String SECURITY_PRINCIPLES = "security:principals";
    private static final String SECURITY_ACL = "security:acl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(URL url, ContentCreator contentCreator) throws IOException, RepositoryException {
        InputStream ins = null;
        try {
            ins = url.openStream();
            this.parse(ins, contentCreator);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void parse(InputStream ins, ContentCreator contentCreator) throws IOException, RepositoryException {
        try {
            String jsonString = this.toString(ins).trim();
            if (!jsonString.startsWith("{")) {
                jsonString = "{" + jsonString + "}";
            }
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("org.apache.johnzon.supports-comments", true);
            JsonObject json = Json.createReaderFactory(config).createReader((Reader)new StringReader(jsonString)).readObject();
            this.createNode(null, json, contentCreator);
        }
        catch (JsonException je) {
            throw (IOException)new IOException(je.getMessage()).initCause(je);
        }
    }

    protected boolean handleSecurity(String n, Object o, ContentCreator contentCreator) throws RepositoryException {
        if (SECURITY_PRINCIPLES.equals(n)) {
            this.createPrincipals(o, contentCreator);
        } else if (SECURITY_ACL.equals(n)) {
            this.createAcl(o, contentCreator);
        } else {
            return false;
        }
        return true;
    }

    protected void writeChildren(JsonObject obj, ContentCreator contentCreator) throws RepositoryException {
        for (Map.Entry entry : obj.entrySet()) {
            Object o;
            String n = (String)entry.getKey();
            if (ignoredNames.contains(n) || this.handleSecurity(n, o = entry.getValue(), contentCreator)) continue;
            if (o instanceof JsonObject) {
                this.createNode(n, (JsonObject)o, contentCreator);
                continue;
            }
            this.createProperty(n, o, contentCreator);
        }
    }

    protected void createNode(String name, JsonObject obj, ContentCreator contentCreator) throws RepositoryException {
        String primaryType = obj.getString("jcr:primaryType", null);
        String[] mixinTypes = null;
        Object mixinsObject = obj.get((Object)"jcr:mixinTypes");
        if (mixinsObject instanceof JsonArray) {
            JsonArray mixins = (JsonArray)mixinsObject;
            mixinTypes = new String[mixins.size()];
            for (int i = 0; i < mixinTypes.length; ++i) {
                mixinTypes[i] = mixins.getString(i);
            }
        }
        contentCreator.createNode(name, primaryType, mixinTypes);
        this.writeChildren(obj, contentCreator);
        contentCreator.finishNode();
    }

    protected void createProperty(String name, Object value, ContentCreator contentCreator) throws RepositoryException {
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            if (array.size() > 0) {
                String[] values = new String[array.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.unbox(array.get(i)).toString();
                }
                int propertyType = this.getType(name, this.unbox(array.get(0)));
                contentCreator.createProperty(this.getName(name), propertyType, values);
            } else {
                contentCreator.createProperty(this.getName(name), 1, new String[0]);
            }
        } else if (value instanceof JsonValue) {
            value = this.unbox(value);
            int propertyType = this.getType(name, value);
            contentCreator.createProperty(this.getName(name), propertyType, value.toString());
        }
    }

    private Object unbox(Object o) {
        if (o instanceof JsonValue) {
            switch (((JsonValue)o).getValueType()) {
                case FALSE: {
                    return false;
                }
                case TRUE: {
                    return true;
                }
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    if (((JsonNumber)o).isIntegral()) {
                        return ((JsonNumber)o).longValue();
                    }
                    return ((JsonNumber)o).doubleValue();
                }
                case STRING: {
                    return ((JsonString)o).getString();
                }
            }
            return o;
        }
        return o;
    }

    private int getType(String name, Object object) {
        if (object instanceof Double || object instanceof Float) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 6;
        }
        if (object instanceof String) {
            if (name.startsWith(REFERENCE)) {
                return 9;
            }
            if (name.startsWith(PATH)) {
                return 8;
            }
            if (name.startsWith(NAME)) {
                return 7;
            }
            if (name.startsWith(URI)) {
                return 11;
            }
            if (jsonDate.matcher((String)object).matches()) {
                return 5;
            }
        }
        return 0;
    }

    private String getName(String name) {
        if (name.startsWith(REFERENCE)) {
            return name.substring(REFERENCE.length());
        }
        if (name.startsWith(PATH)) {
            return name.substring(PATH.length());
        }
        if (name.startsWith(NAME)) {
            return name.substring(NAME.length());
        }
        if (name.startsWith(URI)) {
            return name.substring(URI.length());
        }
        return name;
    }

    private String toString(InputStream ins) throws IOException {
        int rd;
        String encoding;
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        ins.mark(5);
        int c = ins.read();
        if (c == 35) {
            StringBuffer buf = new StringBuffer();
            c = ins.read();
            while (!Character.isWhitespace((char)c)) {
                buf.append((char)c);
                c = ins.read();
            }
            encoding = buf.toString();
        } else {
            ins.reset();
            encoding = "UTF-8";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((rd = ins.read(buf)) >= 0) {
            bos.write(buf, 0, rd);
        }
        bos.close();
        return new String(bos.toByteArray(), encoding);
    }

    protected void createPrincipals(Object obj, ContentCreator contentCreator) throws RepositoryException {
        if (obj instanceof JsonObject) {
            this.createPrincipal((JsonObject)obj, contentCreator);
        } else if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JsonObject)) {
                    throw new JsonException("Unexpected data type in principals array: " + object.getClass().getName());
                }
                this.createPrincipal((JsonObject)object, contentCreator);
            }
        }
    }

    private void createPrincipal(JsonObject json, ContentCreator contentCreator) throws RepositoryException {
        String name = json.getString("name");
        boolean isGroup = json.getBoolean("isgroup", false);
        LinkedHashMap<String, Object> extraProps = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            String propName = (String)entry.getKey();
            if (ignoredPrincipalPropertyNames.contains(propName)) continue;
            Object value = this.unbox(entry.getValue());
            extraProps.put(propName, value);
        }
        if (isGroup) {
            String[] members = null;
            JsonArray membersJSONArray = (JsonArray)json.get((Object)"members");
            if (membersJSONArray != null) {
                members = new String[membersJSONArray.size()];
                for (int i = 0; i < members.length; ++i) {
                    members[i] = membersJSONArray.getString(i);
                }
            }
            contentCreator.createGroup(name, members, extraProps);
        } else {
            String password = json.getString("password");
            contentCreator.createUser(name, password, extraProps);
        }
    }

    private void createAcl(Object obj, ContentCreator contentCreator) throws RepositoryException {
        if (obj instanceof JsonObject) {
            this.createAce((JsonObject)obj, contentCreator);
        } else if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JsonObject)) {
                    throw new JsonException("Unexpected data type in acl array: " + object.getClass().getName());
                }
                this.createAce((JsonObject)object, contentCreator);
            }
        }
    }

    private void createAce(JsonObject ace, ContentCreator contentCreator) throws RepositoryException {
        String principalID = ace.getString("principal");
        String[] grantedPrivileges = null;
        JsonArray granted = (JsonArray)ace.get((Object)"granted");
        if (granted != null) {
            grantedPrivileges = new String[granted.size()];
            for (int a = 0; a < grantedPrivileges.length; ++a) {
                grantedPrivileges[a] = granted.getString(a);
            }
        }
        String[] deniedPrivileges = null;
        JsonArray denied = (JsonArray)ace.get((Object)"denied");
        if (denied != null) {
            deniedPrivileges = new String[denied.size()];
            for (int a = 0; a < deniedPrivileges.length; ++a) {
                deniedPrivileges[a] = denied.getString(a);
            }
        }
        String order = ace.getString("order", null);
        contentCreator.createAce(principalID, grantedPrivileges, deniedPrivileges, order);
    }

    static {
        ignoredNames.add("jcr:primaryType");
        ignoredNames.add("jcr:mixinTypes");
        ignoredNames.add("jcr:uuid");
        ignoredNames.add("jcr:baseVersion");
        ignoredNames.add("jcr:predecessors");
        ignoredNames.add("jcr:successors");
        ignoredNames.add("jcr:checkedOut");
        ignoredNames.add("jcr:created");
        ignoredPrincipalPropertyNames = new HashSet<String>();
        ignoredPrincipalPropertyNames.add("name");
        ignoredPrincipalPropertyNames.add("isgroup");
        ignoredPrincipalPropertyNames.add("members");
        ignoredPrincipalPropertyNames.add("dynamic");
        ignoredPrincipalPropertyNames.add("password");
    }
}

