/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.header.MediaRangeList;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrincipalAceHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessServlet;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.sling.servlets.post.JSONResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessPostServlet
extends AbstractAccessServlet {
    private static final long serialVersionUID = -5918670409789895333L;
    private final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<PostResponseCreatorHolder> postResponseCreators = new ArrayList<PostResponseCreatorHolder>();
    private transient PostResponseCreator[] cachedPostResponseCreators = new PostResponseCreator[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse httpResponse) throws ServletException, IOException {
        PostResponse response = this.createPostResponse(request);
        response.setReferer(request.getHeader("referer"));
        String path = this.getItemPath(request);
        response.setPath(path);
        response.setLocation(this.externalizePath(request, path));
        path = this.getParentPath(path);
        if (path != null) {
            response.setParentLocation(this.externalizePath(request, path));
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ArrayList<Modification> changes = new ArrayList<Modification>();
        try {
            this.handleOperation(request, response, changes);
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", new String[]{change.getSource(), change.getDestination()});
                        break;
                    }
                }
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (ResourceNotFoundException rnfe) {
            response.setStatus(404, rnfe.getMessage());
        }
        catch (Exception throwable) {
            this.log.debug(String.format("Exception while handling POST %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)throwable);
            response.setError((Throwable)throwable);
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException e) {
                this.log.warn("RepositoryException in finally block: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (response.isSuccessful()) {
            String redirect = null;
            try {
                redirect = this.getRedirectUrl((HttpServletRequest)request, response);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Exception while handling redirect for POST %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)e);
                }
                response.setStatus(422, "invalid redirect");
                response.setError((Throwable)e);
            }
            if (redirect != null) {
                httpResponse.sendRedirect(redirect);
                return;
            }
        }
        response.send((HttpServletResponse)httpResponse, this.isSetStatus(request));
    }

    protected void validateResourcePath(Session jcrSession, String resourcePath) throws RepositoryException {
        if (!this.allowNonExistingPaths()) {
            if (resourcePath == null) {
                throw new ResourceNotFoundException("Resource path was not supplied.");
            }
            if (!jcrSession.nodeExists(resourcePath)) {
                throw new ResourceNotFoundException("Resource is not a JCR Node");
            }
        }
    }

    @Deprecated
    protected AbstractPostResponse createHtmlResponse(SlingHttpServletRequest req) {
        return (AbstractPostResponse)this.createPostResponse(req);
    }

    PostResponse createPostResponse(SlingHttpServletRequest req) {
        String headerValue;
        for (PostResponseCreator creator : this.cachedPostResponseCreators) {
            PostResponse response = creator.createPostResponse(req);
            if (response == null) continue;
            return response;
        }
        MediaRangeList mediaRangeList = null;
        String queryParam = req.getParameter(":http-equiv-accept");
        if (!(queryParam != null && queryParam.trim().length() != 0 || (headerValue = req.getHeader("Accept")) != null && headerValue.trim().length() != 0)) {
            mediaRangeList = new MediaRangeList(req.getResponseContentType());
        }
        if (mediaRangeList == null) {
            mediaRangeList = new MediaRangeList((HttpServletRequest)req);
        }
        if ("application/json".equals(mediaRangeList.prefer(new String[]{"text/html", "application/json"}))) {
            return new JSONResponse();
        }
        return new HtmlResponse();
    }

    @Deprecated
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        this.handleOperation(request, (PostResponse)response, changes);
    }

    protected abstract void handleOperation(SlingHttpServletRequest var1, PostResponse var2, List<Modification> var3) throws RepositoryException;

    @Deprecated
    protected String getRedirectUrl(HttpServletRequest request, AbstractPostResponse ctx) throws IOException {
        return this.getRedirectUrl(request, (PostResponse)ctx);
    }

    protected String getRedirectUrl(HttpServletRequest request, PostResponse ctx) throws IOException {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    throw new IOException("The redirect target included host information. This is not allowed for security reasons!");
                }
            }
            catch (URISyntaxException e) {
                throw new IOException("The redirect target was not a valid uri");
            }
            if (ctx.getPath() != null) {
                int star = result.indexOf(42);
                if (star >= 0) {
                    StringBuilder buf = new StringBuilder();
                    if (star > 0) {
                        buf.append(result.substring(0, star));
                    }
                    buf.append(ResourceUtil.getName((String)ctx.getPath()));
                    if (star < result.length() - 1) {
                        buf.append(result.substring(star + 1));
                    }
                    result = buf.toString();
                } else if (result.endsWith("/")) {
                    result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
                }
            }
        }
        return result;
    }

    protected boolean isSetStatus(SlingHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status", (Object)statusParam);
        return true;
    }

    protected String getItemPath(SlingHttpServletRequest request) {
        if (this.allowNonExistingPaths()) {
            return PrincipalAceHelper.getEffectivePath(request);
        }
        return request.getResource().getPath();
    }

    protected String externalizePath(SlingHttpServletRequest request, String path) {
        if (path == null) {
            if (this.allowNonExistingPaths()) {
                path = "/:repository";
            } else {
                return null;
            }
        }
        StringBuilder ret = new StringBuilder();
        ret.append(SlingRequestPaths.getContextPath((HttpServletRequest)request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    protected boolean allowNonExistingPaths() {
        return false;
    }

    @Nullable
    protected String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        return ResourceUtil.getParent((String)path);
    }

    protected AccessControlList getAccessControlList(AccessControlManager accessControlManager, String resourcePath, boolean mayCreate) throws RepositoryException {
        AccessControlPolicy[] policies;
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            return (AccessControlList)policy;
        }
        if (mayCreate) {
            AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                return (AccessControlList)policy;
            }
        }
        throw new RepositoryException("Unable to find or create an access control policy to update for " + resourcePath);
    }

    protected AccessControlList getAccessControlListOrNull(AccessControlManager accessControlManager, String resourcePath, boolean mayCreate) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlList acl = null;
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            acl = (AccessControlList)policy;
        }
        if (acl == null && mayCreate) {
            AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                acl = (AccessControlList)policy;
            }
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        PostResponseCreatorHolder nngh = new PostResponseCreatorHolder(creator, this.getRanking(properties));
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.getRanking() < this.postResponseCreators.get(index).getRanking(); ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<PostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                PostResponseCreatorHolder current = i.next();
                if (current.getCreator() != creator) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    private void updatePostResponseCreatorCache() {
        PostResponseCreator[] localCache = new PostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (PostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.getCreator();
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    private int getRanking(Map<String, Object> properties) {
        Object val = properties.get("service.ranking");
        return val instanceof Integer ? (Integer)val : 0;
    }

    private static final class PostResponseCreatorHolder {
        private final PostResponseCreator creator;
        private final int ranking;

        public PostResponseCreatorHolder(PostResponseCreator creator, int ranking) {
            this.creator = creator;
            this.ranking = ranking;
        }

        public PostResponseCreator getCreator() {
            return this.creator;
        }

        public int getRanking() {
            return this.ranking;
        }
    }
}

