/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.apache.sling.jcr.jackrabbit.accessmanager.ModifyPrincipalAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrincipalAceHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.ModifyAceServlet;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, ModifyPrincipalAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.selectors=modifyPAce", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="RestrictionProvider", bind="bindRestrictionProvider", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=RestrictionProvider.class), @Reference(name="PostResponseCreator", bind="bindPostResponseCreator", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=PostResponseCreator.class)})
public class ModifyPrincipalAceServlet
extends ModifyAceServlet
implements ModifyPrincipalAce {
    private static final long serialVersionUID = -4152308935573740745L;

    @Override
    protected boolean allowNonExistingPaths() {
        return true;
    }

    @Override
    public void modifyPrincipalAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, boolean autoSave) throws RepositoryException {
        this.modifyPrincipalAce(jcrSession, resourcePath, principalId, privileges, null, null, null, autoSave);
    }

    @Override
    public void modifyPrincipalAce(Session jcrSession, String resourcePath, String principalId, Map<String, String> privileges, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removeRestrictionNames, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, privileges, null, restrictions, mvRestrictions, removeRestrictionNames, autoSave, null);
    }

    @Override
    public void modifyPrincipalAce(Session jcrSession, String resourcePath, String principalId, Collection<LocalPrivilege> localPrivileges, boolean autoSave) throws RepositoryException {
        this.modifyAce(jcrSession, resourcePath, principalId, localPrivileges, null, autoSave, null);
    }

    @Override
    protected JackrabbitAccessControlList getAcl(@NotNull AccessControlManager acm, String resourcePath, Principal principal) throws RepositoryException {
        PrincipalAccessControlList acl = null;
        if (acm instanceof JackrabbitAccessControlManager) {
            JackrabbitAccessControlPolicy[] policies;
            JackrabbitAccessControlManager jacm = (JackrabbitAccessControlManager)acm;
            for (JackrabbitAccessControlPolicy policy : policies = jacm.getPolicies(principal)) {
                if (!(policy instanceof PrincipalAccessControlList)) continue;
                acl = (PrincipalAccessControlList)policy;
                break;
            }
            if (acl == null) {
                JackrabbitAccessControlPolicy[] applicablePolicies;
                for (JackrabbitAccessControlPolicy policy : applicablePolicies = jacm.getApplicablePolicies(principal)) {
                    if (!(policy instanceof PrincipalAccessControlList)) continue;
                    acl = (PrincipalAccessControlList)policy;
                    break;
                }
            }
        }
        return acl;
    }

    @Override
    protected String removeAces(@NotNull String resourcePath, @Nullable String order, @NotNull Principal principal, @NotNull JackrabbitAccessControlList acl) throws RepositoryException {
        AccessControlEntry[] existingAccessControlEntries = acl.getAccessControlEntries();
        for (int j = 0; j < existingAccessControlEntries.length; ++j) {
            AccessControlEntry ace = existingAccessControlEntries[j];
            @Nullable JackrabbitAccessControlEntry jrEntry = this.getJackrabbitAccessControlEntry(ace, resourcePath, principal);
            if (jrEntry == null) continue;
            if (order == null || order.length() == 0) {
                order = String.valueOf(j);
            }
            acl.removeAccessControlEntry(ace);
        }
        return order;
    }

    @Override
    protected void addAces(@NotNull String resourcePath, @NotNull Principal principal, @NotNull Map<Set<LocalRestriction>, List<LocalPrivilege>> restrictionsToLocalPrivilegesMap, boolean isAllow, @NotNull JackrabbitAccessControlList acl, Map<Privilege, Integer> privilegeLongestDepthMap) throws RepositoryException {
        if (isAllow) {
            super.addAces(resourcePath, principal, restrictionsToLocalPrivilegesMap, isAllow, acl, privilegeLongestDepthMap);
        } else if (!restrictionsToLocalPrivilegesMap.isEmpty()) {
            throw new IllegalArgumentException("Deny privileges are not allowed in a principal ACE");
        }
    }

    @Override
    @Nullable
    protected JackrabbitAccessControlEntry getJackrabbitAccessControlEntry(@NotNull AccessControlEntry entry, @NotNull String resourcePath, @NotNull Principal forPrincipal) {
        JackrabbitAccessControlEntry jrEntry = null;
        if (entry instanceof PrincipalAccessControlList.Entry && entry.getPrincipal().equals(forPrincipal) && PrincipalAceHelper.matchesResourcePath(resourcePath, entry)) {
            jrEntry = (JackrabbitAccessControlEntry)entry;
        }
        return jrEntry;
    }
}

