/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameFilter;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameGenerator;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractPostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizablePostServlet
extends AbstractPostServlet {
    private static final long serialVersionUID = -5918670409789895333L;
    protected static final String RP_NODE_NAME_VALUE_FROM = String.format("%s%s", ":name", "@ValueFrom");
    protected static final String RP_NODE_NAME_HINT_VALUE_FROM = String.format("%s%s", ":nameHint", "@ValueFrom");
    public static final String PROP_DATE_FORMAT = "servlet.post.dateFormats";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthorizablePostServlet.class);
    private final SecureRandom randomCollisionIndex = new SecureRandom();
    private transient DateParser dateParser;
    protected transient SystemUserManagerPaths systemUserManagerPaths;
    protected transient LinkedList<PrincipalNameGeneratorHolder> principalNameGenerators = new LinkedList();
    protected transient PrincipalNameFilter principalNameFilter;

    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        this.systemUserManagerPaths = sump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPrincipalNameGenerator(PrincipalNameGenerator generator, Map<String, Object> properties) {
        PrincipalNameGeneratorHolder pngh = new PrincipalNameGeneratorHolder(generator, this.getRanking(properties));
        LinkedList<PrincipalNameGeneratorHolder> linkedList = this.principalNameGenerators;
        synchronized (linkedList) {
            this.principalNameGenerators.add(pngh);
            Collections.sort(this.principalNameGenerators, (o1, o2) -> Integer.compare(((PrincipalNameGeneratorHolder)o1).ranking, ((PrincipalNameGeneratorHolder)o2).ranking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPrincipalNameGenerator(PrincipalNameGenerator generator) {
        LinkedList<PrincipalNameGeneratorHolder> linkedList = this.principalNameGenerators;
        synchronized (linkedList) {
            this.principalNameGenerators.removeIf(h -> ((PrincipalNameGeneratorHolder)h).generator == generator);
        }
    }

    protected void bindPrincipalNameFilter(PrincipalNameFilter filter) {
        this.principalNameFilter = filter;
    }

    protected void unbindPrincipalNameFilter(PrincipalNameFilter filter) {
        if (filter != null && filter.equals(this.principalNameFilter)) {
            this.principalNameFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getOrGeneratePrincipalName(Session jcrSession, Map<String, ?> properties, AuthorizableType type) throws RepositoryException {
        String principalName = null;
        PrincipalNameGenerator defaultPrincipalNameGenerator = null;
        PrincipalNameGenerator principalNameGenerator = null;
        LinkedList<PrincipalNameGeneratorHolder> linkedList = this.principalNameGenerators;
        synchronized (linkedList) {
            if (!this.principalNameGenerators.isEmpty()) {
                defaultPrincipalNameGenerator = this.principalNameGenerators.getFirst().getGenerator();
                principalNameGenerator = this.principalNameGenerators.getLast().getGenerator();
            }
        }
        if (principalNameGenerator != null) {
            PrincipalNameGenerator.NameInfo nameInfo = principalNameGenerator.getPrincipalName(properties, type, this.principalNameFilter, defaultPrincipalNameGenerator);
            if (nameInfo == null && defaultPrincipalNameGenerator != null) {
                nameInfo = defaultPrincipalNameGenerator.getPrincipalName(properties, type, this.principalNameFilter, defaultPrincipalNameGenerator);
            }
            if (nameInfo != null && (principalName = nameInfo.getPrincipalName()) != null && nameInfo.isMakeUnique()) {
                UserManager um = AccessControlUtil.getUserManager((Session)jcrSession);
                int MAX_TRIES = 1000;
                if (um.getAuthorizable(principalName) != null) {
                    for (int i = 0; i < 1000; ++i) {
                        int uniqueIndex = this.randomCollisionIndex.nextInt(9999);
                        String newPrincipalName = principalName + "_" + uniqueIndex;
                        if (um.getAuthorizable(newPrincipalName) != null) continue;
                        principalName = newPrincipalName;
                        break;
                    }
                    if (um.getAuthorizable(principalName) != null) {
                        throw new RepositoryException("Collision in generated principal names, generated name " + principalName + " already exists");
                    }
                }
            }
        } else {
            Object obj = properties.get(":name");
            if (obj instanceof String[] && Array.getLength(obj) == 1) {
                principalName = ((String[])obj)[0];
            } else if (obj instanceof String) {
                principalName = (String)obj;
            }
        }
        return principalName;
    }

    protected void activate(Map<String, Object> props) {
        String[] dateFormats;
        this.dateParser = new DateParser();
        for (String dateFormat : dateFormats = OsgiUtil.toStringArray((Object)props.get(PROP_DATE_FORMAT))) {
            this.dateParser.register(dateFormat);
        }
    }

    protected void deactivate() {
        this.dateParser = null;
    }

    @Deprecated
    protected Collection<RequestProperty> collectContent(Map<String, ?> properties) {
        return this.collectContentMap(properties).values();
    }

    protected Map<String, RequestProperty> collectContentMap(Map<String, ?> properties) {
        boolean requireItemPrefix = this.requireItemPathPrefix(properties);
        HashMap<String, RequestProperty> reqProperties = new HashMap<String, RequestProperty>();
        for (Map.Entry<String, ?> e : properties.entrySet()) {
            RequestProperty prop;
            String propPath;
            String paramName = e.getKey();
            boolean skipParam = paramName.startsWith(":");
            if (paramName.equals("_charset_")) {
                skipParam = true;
            }
            if (requireItemPrefix && !this.hasItemPathPrefix(paramName)) {
                skipParam = true;
            }
            if ((propPath = paramName.startsWith("./") ? paramName.substring(1) : String.format("/%s", paramName)).indexOf("..") != -1) {
                LOG.warn("Property path containing '..' is not supported, skipping parameter {}", (Object)paramName);
                skipParam = true;
            }
            if (skipParam) continue;
            if (propPath.endsWith("@TypeHint")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@TypeHint");
                String typeHintValue = this.convertToString(e.getValue());
                if (typeHintValue == null) continue;
                prop.setTypeHintValue(typeHintValue);
                continue;
            }
            if (propPath.endsWith("@DefaultValue")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@DefaultValue");
                prop.setDefaultValues(this.convertToRequestParameterArray(e.getValue()));
                continue;
            }
            if (propPath.endsWith("@ValueFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@ValueFrom");
                String[] valueFrom = this.convertToStringArray(e.getValue());
                if (valueFrom.length != 1) continue;
                String refName = valueFrom[0];
                prop.setValues(this.convertToRequestParameterArray(refName));
                continue;
            }
            if (propPath.endsWith("@Delete")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Delete");
                prop.setDelete(true);
                continue;
            }
            if (propPath.endsWith("@MoveFrom")) {
                LOG.warn("Suffix {} not supported, skipping parameter {}", (Object)"@MoveFrom", (Object)paramName);
                continue;
            }
            if (propPath.endsWith("@CopyFrom")) {
                LOG.warn("Suffix {} not supported, skipping parameter {}", (Object)"@CopyFrom", (Object)paramName);
                continue;
            }
            prop = this.getOrCreateRequestProperty(reqProperties, propPath, null);
            prop.setValues(this.convertToRequestParameterArray(e.getValue()));
        }
        return reqProperties;
    }

    private RequestProperty getOrCreateRequestProperty(Map<String, RequestProperty> props, String paramPath, String suffix) {
        if (suffix != null && paramPath.endsWith(suffix)) {
            paramPath = paramPath.substring(0, paramPath.length() - suffix.length());
        }
        return props.computeIfAbsent(paramPath, RequestProperty::new);
    }

    protected void processDeletes(Authorizable authorizable, Collection<RequestProperty> reqProperties, List<Modification> changes) throws RepositoryException {
        for (RequestProperty property : reqProperties) {
            String relativePath;
            if (!property.isDelete() || !authorizable.hasProperty(relativePath = property.getPath().substring(1))) continue;
            authorizable.removeProperty(relativePath);
            changes.add(Modification.onDeleted((String)relativePath));
        }
    }

    protected void processCreate(Session session, Authorizable authorizable, Map<String, RequestProperty> reqProperties, List<Modification> changes) throws RepositoryException {
        @NotNull String path = authorizable.getPath();
        for (RequestProperty prop : reqProperties.values()) {
            String[] mixins;
            String parentPath;
            String propName = prop.getName();
            if (!"jcr:primaryType".equals(propName) && !"jcr:mixinTypes".equals(propName) || (parentPath = prop.getParentPath()) == null && "jcr:primaryType".equals(propName)) continue;
            String tp = null;
            if (parentPath == null || "/".equals(parentPath)) {
                tp = path;
            } else if (parentPath.startsWith("/")) {
                tp = Paths.get(path, parentPath.substring(1)).toString();
            }
            if (tp == null || !tp.equals(path) && !Paths.get(tp, new String[0]).startsWith(path)) continue;
            Node node = null;
            if (session.nodeExists(tp)) {
                node = session.getNode(tp);
            } else {
                Node tempNode = session.getNode(path);
                Iterator<Path> elements = Paths.get(parentPath, new String[0]).iterator();
                while (elements.hasNext()) {
                    String segment = elements.next().toString();
                    String tempPath = Paths.get(tempNode.getPath(), segment).toString();
                    if (session.nodeExists(tempPath)) {
                        tempNode = session.getNode(tempPath);
                        continue;
                    }
                    String primaryType = this.getPrimaryType(reqProperties, tempPath);
                    tempNode = primaryType != null ? tempNode.addNode(segment, primaryType) : tempNode.addNode(segment);
                    changes.add(Modification.onCreated((String)tempNode.getPath()));
                }
                node = tempNode;
            }
            if (node == null) continue;
            if ("jcr:primaryType".equals(propName)) {
                if (tp.equals(path)) {
                    throw new AccessDeniedException("Access denied.");
                }
                String nodeType = prop == null ? null : prop.getStringValues()[0];
                if (nodeType == null || node.isNodeType(nodeType)) continue;
                node.setPrimaryType(nodeType);
                changes.add(Modification.onModified((String)Paths.get(node.getPath(), propName).toString()));
                continue;
            }
            if (!"jcr:mixinTypes".equals(propName) || (mixins = prop == null || !prop.hasValues() ? null : prop.getStringValues()) == null) continue;
            for (String mixin : mixins) {
                if (node.isNodeType(mixin)) continue;
                node.addMixin(mixin);
                changes.add(Modification.onModified((String)Paths.get(node.getPath(), propName).toString()));
            }
        }
    }

    private String getPrimaryType(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(String.format("%s/%s", path, "jcr:primaryType"));
        return prop == null ? null : prop.getStringValues()[0];
    }

    protected void writeContent(Session session, Authorizable authorizable, Collection<RequestProperty> reqProperties, List<Modification> changes) throws RepositoryException {
        for (RequestProperty prop : reqProperties) {
            boolean isSpecialProp;
            if (!prop.hasValues()) continue;
            String relativePath = prop.getPath().substring(1);
            String name = prop.getName();
            boolean bl = isSpecialProp = name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes");
            if (authorizable.isGroup()) {
                if (relativePath.equals("groupId")) {
                    isSpecialProp = true;
                }
            } else if (relativePath.equals("userId") || relativePath.equals("pwd") || relativePath.equals("pwdConfirm")) {
                isSpecialProp = true;
            }
            if (isSpecialProp || prop.isFileUpload()) continue;
            this.setPropertyAsIs(session, authorizable, prop, changes);
        }
    }

    private void setPropertyAsIs(Session session, Authorizable parent, RequestProperty prop, List<Modification> changes) throws RepositoryException {
        String parentPath = parent.isGroup() ? this.systemUserManagerPaths.getGroupPrefix() + parent.getID() : this.systemUserManagerPaths.getUserPrefix() + parent.getID();
        int type = 0;
        if (prop.getTypeHint() != null) {
            try {
                type = PropertyType.valueFromName((String)prop.getTypeHint());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String relativePath = prop.getPath().substring(1);
        String[] values = prop.getStringValues();
        if (values == null) {
            boolean removedProp = this.removePropertyIfExists(parent, relativePath);
            if (removedProp) {
                changes.add(Modification.onDeleted((String)(parentPath + "/" + relativePath)));
            }
        } else if (values.length == 0) {
            if (parent.hasProperty(relativePath)) {
                Value val = session.getValueFactory().createValue("");
                parent.setProperty(relativePath, val);
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
            }
        } else if (values.length == 1) {
            if (values[0].length() == 0) {
                boolean removedProp = this.removePropertyIfExists(parent, relativePath);
                if (removedProp) {
                    changes.add(Modification.onDeleted((String)(parentPath + "/" + relativePath)));
                }
            } else {
                Value val;
                Calendar c;
                if (type == 5 && (c = this.dateParser.parse(values[0])) != null) {
                    if (prop.hasMultiValueTypeHint()) {
                        Value[] array = new Value[]{session.getValueFactory().createValue(c)};
                        parent.setProperty(relativePath, array);
                        changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                    } else {
                        Value cVal = session.getValueFactory().createValue(c);
                        parent.setProperty(relativePath, cVal);
                        changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                    }
                    return;
                }
                if (type == 0) {
                    val = session.getValueFactory().createValue(values[0], 1);
                    parent.setProperty(relativePath, val);
                } else if (prop.hasMultiValueTypeHint()) {
                    Value[] array = new Value[]{session.getValueFactory().createValue(values[0], type)};
                    parent.setProperty(relativePath, array);
                } else {
                    val = session.getValueFactory().createValue(values[0], type);
                    parent.setProperty(relativePath, val);
                }
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
            }
        } else {
            ValueFactory valFac;
            Value[] c;
            if (type == 5 && (c = this.dateParser.parse(values, valFac = session.getValueFactory())) != null) {
                parent.setProperty(relativePath, c);
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                return;
            }
            Value[] vals = new Value[values.length];
            if (type == 0) {
                for (int i = 0; i < values.length; ++i) {
                    vals[i] = session.getValueFactory().createValue(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    vals[i] = session.getValueFactory().createValue(values[i], type);
                }
            }
            parent.setProperty(relativePath, vals);
            changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
        }
    }

    private boolean removePropertyIfExists(Authorizable authorizable, String path) throws RepositoryException {
        if (authorizable.getProperty(path) != null) {
            authorizable.removeProperty(path);
            return true;
        }
        return false;
    }

    protected boolean hasItemPathPrefix(String name) {
        return name.startsWith("/") || name.startsWith("./") || name.startsWith("../");
    }

    protected final boolean requireItemPathPrefix(Map<String, ?> properties) {
        boolean requirePrefix = false;
        Iterator<String> iterator = properties.keySet().iterator();
        while (iterator.hasNext() && !requirePrefix) {
            String name = iterator.next();
            requirePrefix = name.startsWith("./");
        }
        return requirePrefix;
    }

    protected String convertToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        if (obj instanceof RequestParameter) {
            ((RequestParameter)obj).getString();
        } else if (obj instanceof RequestParameter[]) {
            RequestParameter[] values = (RequestParameter[])obj;
            if (values.length > 0) {
                return values[0].getString();
            }
            return null;
        }
        return null;
    }

    @NotNull
    protected String[] convertToStringArray(Object obj) {
        String[] strArray = null;
        if (obj instanceof String) {
            strArray = new String[]{(String)obj};
        } else if (obj instanceof String[]) {
            strArray = (String[])obj;
        } else if (obj instanceof RequestParameter) {
            strArray = new String[]{((RequestParameter)obj).getString()};
        } else if (obj instanceof RequestParameter[]) {
            RequestParameter[] values = (RequestParameter[])obj;
            strArray = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strArray[i] = values[i].getString();
            }
        }
        return strArray == null ? new String[]{} : strArray;
    }

    @NotNull
    protected RequestParameter[] convertToRequestParameterArray(Object obj) {
        RequestParameter[] paramArray = null;
        if (obj instanceof String) {
            paramArray = new RequestParameter[]{new RequestParameterImpl((String)obj, null)};
        } else if (obj instanceof String[]) {
            String[] strValues = (String[])obj;
            paramArray = new RequestParameter[strValues.length];
            for (int i = 0; i < strValues.length; ++i) {
                paramArray[i] = new RequestParameterImpl(strValues[i], null);
            }
        } else if (obj instanceof RequestParameter) {
            paramArray = new RequestParameter[]{(RequestParameter)obj};
        } else if (obj instanceof RequestParameter[]) {
            paramArray = (RequestParameter[])obj;
        }
        return paramArray == null ? new RequestParameter[]{} : paramArray;
    }

    static class SlingUnsupportedEncodingException
    extends SlingIOException {
        private static final long serialVersionUID = -4482276105859280247L;

        SlingUnsupportedEncodingException(UnsupportedEncodingException uee) {
            super((IOException)uee);
        }
    }

    static class RequestParameterImpl
    implements RequestParameter {
        private String value;
        private String encoding;
        private byte[] content;

        RequestParameterImpl(String value, String encoding) {
            this.encoding = encoding;
            this.value = value;
            this.content = null;
        }

        String getEncoding() {
            return this.encoding;
        }

        void setEncoding(String encoding) {
            try {
                this.value = this.getString(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SlingUnsupportedEncodingException(uee);
            }
            this.encoding = encoding;
        }

        public byte[] get() {
            if (this.content == null) {
                try {
                    this.content = this.getString().getBytes(this.getEncoding());
                }
                catch (Exception e) {
                    this.content = this.getString().getBytes();
                }
            }
            return this.content;
        }

        public String getContentType() {
            return null;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.get());
        }

        public String getFileName() {
            return null;
        }

        public long getSize() {
            return this.get().length;
        }

        public String getString() {
            return this.value;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        public boolean isFormField() {
            return true;
        }

        public String getName() {
            return null;
        }

        public String toString() {
            return this.getString();
        }
    }

    private static final class PrincipalNameGeneratorHolder {
        private final PrincipalNameGenerator generator;
        private final int ranking;

        private PrincipalNameGeneratorHolder(PrincipalNameGenerator generator, int ranking) {
            this.generator = generator;
            this.ranking = ranking;
        }

        public PrincipalNameGenerator getGenerator() {
            return this.generator;
        }
    }
}

