/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.maintenance;

import java.util.Arrays;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;

public class RepositoryManagementUtil {
    private RepositoryManagementUtil() {
    }

    public static boolean isRunning(CompositeData status) {
        return RepositoryManagementMBean.StatusCode.RUNNING == RepositoryManagementUtil.getStatusCode(status);
    }

    public static boolean isValid(CompositeData status) {
        RepositoryManagementMBean.StatusCode statusCode = RepositoryManagementUtil.getStatusCode(status);
        return statusCode != RepositoryManagementMBean.StatusCode.UNAVAILABLE && statusCode != RepositoryManagementMBean.StatusCode.FAILED;
    }

    public static RepositoryManagementMBean.StatusCode getStatusCode(CompositeData status) {
        int c = (Integer)status.get("code");
        return Arrays.stream(RepositoryManagementMBean.StatusCode.values()).filter(sc -> sc.ordinal() == c).findFirst().orElse(RepositoryManagementMBean.StatusCode.NONE);
    }

    public static String getMessage(CompositeData status) {
        return (String)status.get("message");
    }
}

