/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.registration.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.Repository;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.sling.jcr.registration.AbstractRegistrationSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, name="org.apache.sling.jcr.jackrabbit.server.JndiRegistrationSupport", property={"service.vendor=The Apache Software Foundation", "service.description=JNDI Repository Registration"}, reference={@Reference(name="Repository", policy=ReferencePolicy.DYNAMIC, bind="bindRepository", unbind="unbindRepository", cardinality=ReferenceCardinality.MULTIPLE, service=Repository.class), @Reference(name="Log", policy=ReferencePolicy.DYNAMIC, bind="bindLog", unbind="unbindLog", cardinality=ReferenceCardinality.OPTIONAL, service=LogService.class)})
@Designate(ocd=Configuration.class)
public class JndiRegistrationSupport
extends AbstractRegistrationSupport {
    private Context jndiContext;

    @Override
    protected boolean doActivate() {
        Dictionary props = this.getComponentContext().getProperties();
        Properties env = new Properties();
        Enumeration pe = props.keys();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith("java.naming.")) continue;
            env.setProperty(key, (String)props.get(key));
        }
        try {
            this.jndiContext = this.createInitialContext(env);
            this.log(3, "Using JNDI context " + this.jndiContext.getEnvironment() + " to register repositories", null);
            return true;
        }
        catch (NamingException ne) {
            this.log(1, "Problem setting up JNDI initial context, repositories will not be registered. Reason: " + ne.getMessage(), null);
            return false;
        }
    }

    @Override
    protected void doDeactivate() {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException ne) {
                this.log(3, "Problem closing JNDI context", ne);
            }
            this.jndiContext = null;
        }
    }

    private Context createInitialContext(final Properties env) throws NamingException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Context>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Context run() throws NamingException {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader old = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(JndiRegistrationSupport.this.getClass().getClassLoader());
                    try {
                        InitialContext initialContext = new InitialContext(env);
                        return initialContext;
                    }
                    finally {
                        currentThread.setContextClassLoader(old);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (NamingException)pae.getCause();
        }
    }

    @Override
    protected Object bindRepository(String name, Repository repository) {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.bind(name, (Object)repository);
                this.log(3, "Repository bound to JNDI as " + name, null);
                return repository;
            }
            catch (NamingException ne) {
                this.log(1, "Failed to register repository " + name, ne);
            }
        }
        return null;
    }

    @Override
    protected void unbindRepository(String name, Object data) {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.unbind(name);
                this.log(3, "Repository " + name + " unbound from JNDI", null);
            }
            catch (NamingException ne) {
                this.log(1, "Problem unregistering repository " + name, ne);
            }
        }
    }

    @Override
    protected void bindLog(LogService log) {
        super.bindLog(log);
    }

    @Override
    protected void unbindLog(LogService log) {
        super.unbindLog(log);
    }

    @ObjectClassDefinition(name="Apache Sling JCR Repository JNDI Registrar", description="The JNDI Registrar listens for embedded repositories to be registered as services and registers them in the JNDI context under the name specified in the \"name\" service property.")
    public static @interface Configuration {
        @AttributeDefinition(name="Initial Context Factory", description="The fully qualified class name of the factory class that will create an initial context.")
        public String java_naming_factory_initial() default "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory";

        @AttributeDefinition(name="Provider URL", description="An URL string for the service provider (e.g. ldap://somehost:389)")
        public String java_naming_provider_url() default "http://sling.apache.org";
    }
}

