/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.AddGroupMembers;
import org.apache.sling.repoinit.parser.operations.RemoveGroupMembers;

class GroupMembershipVisitor
extends DoNothingVisitor {
    public GroupMembershipVisitor(Session s) {
        super(s);
    }

    @Override
    public void visitAddGroupMembers(AddGroupMembers am) {
        List members = am.getMembers();
        String groupname = am.getGroupname();
        Authorizable group = null;
        this.log.info("Adding members '{}' to group '{}'", (Object)members, (Object)groupname);
        try {
            group = UserUtil.getAuthorizable(this.session, groupname);
            if (group == null || !group.isGroup()) {
                throw new RuntimeException(groupname + " is not a group");
            }
            ((Group)group).addMembers(members.toArray(new String[0]));
        }
        catch (RepositoryException e) {
            this.report((Exception)((Object)e), "Unable to add members to group [" + groupname + "]:" + (Object)((Object)e));
        }
    }

    @Override
    public void visitRemoveGroupMembers(RemoveGroupMembers rm) {
        List members = rm.getMembers();
        String groupname = rm.getGroupname();
        Authorizable group = null;
        this.log.info("Removing members '{}' from group '{}'", (Object)members, (Object)groupname);
        try {
            group = UserUtil.getAuthorizable(this.session, groupname);
            if (group == null || !group.isGroup()) {
                throw new RuntimeException(groupname + " is not a group");
            }
            ((Group)group).removeMembers(members.toArray(new String[0]));
        }
        catch (RepositoryException e) {
            this.report((Exception)((Object)e), "Unable to remove members from group [" + groupname + "]:" + (Object)((Object)e));
        }
    }
}

