/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.repoinit.parser.operations.PropertyLine;
import org.apache.sling.repoinit.parser.operations.SetProperties;

class NodePropertiesVisitor
extends DoNothingVisitor {
    public NodePropertiesVisitor(Session s) {
        super(s);
    }

    private static boolean needToSetProperty(Node n, PropertyLine line) throws RepositoryException {
        if (!line.isDefault()) {
            return true;
        }
        String name = line.getPropertyName();
        return !n.hasProperty(name) || n.getProperty(name) == null;
    }

    @Override
    public void visitSetProperties(SetProperties sp) {
        for (String nodePath : sp.getPaths()) {
            try {
                this.log.info("Setting properties on nodePath '{}'", (Object)nodePath);
                Node n = this.session.getNode(nodePath);
                for (PropertyLine pl : sp.getPropertyLines()) {
                    String pName = pl.getPropertyName();
                    PropertyLine.PropertyType pType = pl.getPropertyType();
                    List values = pl.getPropertyValues();
                    int type = PropertyType.valueFromName((String)pType.name());
                    if (NodePropertiesVisitor.needToSetProperty(n, pl)) {
                        if (values.size() > 1) {
                            Value[] pValues = this.convertToValues(values);
                            n.setProperty(pName, pValues, type);
                            continue;
                        }
                        Value pValue = this.convertToValue(values.get(0));
                        n.setProperty(pName, pValue, type);
                        continue;
                    }
                    this.log.info("Property '{}' already set on path '{}', existing value will not be overwritten in 'default' mode", (Object)pName, (Object)nodePath);
                }
            }
            catch (RepositoryException e) {
                this.report((Exception)((Object)e), "Unable to set properties on path [" + nodePath + "]:" + (Object)((Object)e));
            }
        }
    }

    private Value[] convertToValues(List<Object> values) {
        int size = values.size();
        Value[] valueArray = new Value[size];
        for (int i = 0; i < size; ++i) {
            valueArray[i] = this.convertToValue(values.get(i));
        }
        return valueArray;
    }

    private Value convertToValue(Object value) {
        StringValue convertedValue = null;
        if (value instanceof String) {
            convertedValue = new StringValue((String)value);
        } else if (value instanceof Double) {
            convertedValue = new DoubleValue((Double)value);
        } else if (value instanceof Long) {
            convertedValue = new LongValue((Long)value);
        } else if (value instanceof Boolean) {
            convertedValue = new BooleanValue((Boolean)value);
        } else if (value instanceof Calendar) {
            convertedValue = new DateValue((Calendar)value);
        } else {
            throw new RuntimeException("Unable to convert " + value + " to jcr Value");
        }
        return convertedValue;
    }
}

