/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;

public class UserUtil {
    public static PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new IllegalArgumentException("Session is not a JackrabbitSession");
        }
        return ((JackrabbitSession)session).getPrincipalManager();
    }

    public static UserManager getUserManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new IllegalArgumentException("Session is not a JackrabbitSession");
        }
        return ((JackrabbitSession)session).getUserManager();
    }

    public static Authorizable getAuthorizable(Session session, String id) throws RepositoryException {
        return UserUtil.getUserManager(session).getAuthorizable(id);
    }

    public static void createServiceUser(Session session, String username, String path) throws RepositoryException {
        UserUtil.getUserManager(session).createSystemUser(username, path);
    }

    public static boolean isServiceUser(Session session, String id) throws RepositoryException {
        boolean result = false;
        Authorizable authorizable = UserUtil.getAuthorizable(session, id);
        if (authorizable != null && !authorizable.isGroup()) {
            User user = (User)authorizable;
            result = user.isSystemUser();
        }
        return result;
    }

    public static boolean deleteAuthorizable(Session session, String id) throws RepositoryException {
        Authorizable authorizable = UserUtil.getUserManager(session).getAuthorizable(id);
        if (authorizable != null) {
            authorizable.remove();
            return true;
        }
        return false;
    }

    public static boolean disableUser(Session session, String id, String reason) throws RepositoryException {
        if (reason == null) {
            throw new IllegalArgumentException("reason can't be null");
        }
        Authorizable authorizable = UserUtil.getUserManager(session).getAuthorizable(id);
        if (authorizable != null) {
            if (authorizable.isGroup()) {
                throw new IllegalStateException("Can't disable a group: " + id);
            }
            ((User)authorizable).disable(reason);
            return true;
        }
        return false;
    }

    public static void createUser(Session session, String username, String password, String path) throws RepositoryException {
        if (path == null) {
            UserUtil.getUserManager(session).createUser(username, password);
        } else {
            SameNamePrincipal p = new SameNamePrincipal(username);
            UserUtil.getUserManager(session).createUser(username, password, (Principal)p, path);
        }
    }

    public static boolean userExists(Session session, String id) throws RepositoryException {
        boolean result = false;
        Authorizable authorizable = UserUtil.getAuthorizable(session, id);
        if (authorizable != null) {
            result = !authorizable.isGroup();
        }
        return result;
    }

    static class SameNamePrincipal
    implements Principal {
        private final String name;

        SameNamePrincipal(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof SameNamePrincipal && this.name.equals(((SameNamePrincipal)other).name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

