/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.security.Principal;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.CreateGroup;
import org.apache.sling.repoinit.parser.operations.CreateServiceUser;
import org.apache.sling.repoinit.parser.operations.CreateUser;
import org.apache.sling.repoinit.parser.operations.DeleteGroup;
import org.apache.sling.repoinit.parser.operations.DeleteServiceUser;
import org.apache.sling.repoinit.parser.operations.DeleteUser;
import org.apache.sling.repoinit.parser.operations.DisableServiceUser;

class UserVisitor
extends DoNothingVisitor {
    public UserVisitor(Session s) {
        super(s);
    }

    @Override
    public void visitCreateServiceUser(CreateServiceUser s) {
        block4: {
            String username = s.getUsername();
            try {
                if (!UserUtil.userExists(this.session, username)) {
                    this.log.info("Creating service user {}", (Object)username);
                    UserUtil.createServiceUser(this.session, username, s.getPath());
                    break block4;
                }
                if (UserUtil.isServiceUser(this.session, username)) {
                    this.log.info("Service user {} already exists, no changes made.", (Object)username);
                    break block4;
                }
                String message = String.format("Existing user %s is not a service user.", username);
                throw new RuntimeException(message);
            }
            catch (Exception e) {
                this.report(e, "Unable to create service user [" + username + "]:" + e);
            }
        }
    }

    @Override
    public void visitDeleteServiceUser(DeleteServiceUser s) {
        String username = s.getUsername();
        this.log.info("Deleting service user {}", (Object)username);
        try {
            UserUtil.deleteAuthorizable(this.session, username);
        }
        catch (Exception e) {
            this.report(e, "Unable to delete service user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitCreateGroup(CreateGroup g) {
        final String groupname = g.getGroupname();
        try {
            Authorizable group = UserUtil.getAuthorizable(this.session, groupname);
            if (group == null || !group.isGroup()) {
                this.log.info("Creating group {}", (Object)groupname);
                if (g.getPath() == null) {
                    UserUtil.getUserManager(this.session).createGroup(groupname);
                } else {
                    UserUtil.getUserManager(this.session).createGroup(new Principal(){

                        @Override
                        public String getName() {
                            return groupname;
                        }
                    }, g.getPath());
                }
            } else {
                this.log.info("Group {} already exists, no changes made", (Object)groupname);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to create group [" + groupname + "]:" + e);
        }
    }

    @Override
    public void visitDeleteGroup(DeleteGroup g) {
        String groupname = g.getGroupname();
        this.log.info("Deleting group {}", (Object)groupname);
        try {
            if (!UserUtil.deleteAuthorizable(this.session, groupname)) {
                this.log.debug("Group {} doesn't exist - assuming delete to be a noop.", (Object)groupname);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to delete group [" + groupname + "]:" + e);
        }
    }

    @Override
    public void visitCreateUser(CreateUser u) {
        String username = u.getUsername();
        try {
            if (!UserUtil.userExists(this.session, username)) {
                String pwd = u.getPassword();
                if (pwd != null) {
                    this.log.warn("Creating user {} with cleartext password - should NOT be used on production systems", (Object)username);
                } else {
                    this.log.info("Creating user {}", (Object)username);
                }
                UserUtil.createUser(this.session, username, pwd, u.getPath());
            } else {
                this.log.info("User {} already exists, no changes made", (Object)username);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to create user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitDeleteUser(DeleteUser u) {
        String username = u.getUsername();
        this.log.info("Deleting user {}", (Object)username);
        try {
            if (!UserUtil.deleteAuthorizable(this.session, username)) {
                this.log.debug("User {} doesn't exist - assuming delete to be a noop.", (Object)username);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to delete user [" + username + "]:" + e);
        }
    }

    @Override
    public void visitDisableServiceUser(DisableServiceUser dsu) {
        String username = dsu.getUsername();
        String reason = dsu.getParametersDescription();
        this.log.info("Disabling service user {} reason {}", (Object[])new String[]{username, reason});
        try {
            if (!UserUtil.disableUser(this.session, username, reason)) {
                this.log.debug("Service user {} doesn't exist - assuming disable to be a noop.", (Object)username);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to disable service user [" + username + "]:" + e);
        }
    }
}

