/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclUtil {
    private static final String PRINCIPAL_NOT_FOUND_PATTERN = "Principal not found: {0}";
    private static final Logger LOG = LoggerFactory.getLogger(AclUtil.class);

    private AclUtil() {
    }

    public static JackrabbitAccessControlManager getJACM(Session s) throws RepositoryException {
        AccessControlManager acm = s.getAccessControlManager();
        AclUtil.checkState(acm instanceof JackrabbitAccessControlManager, "AccessControlManager is not a JackrabbitAccessControlManager: {0}", acm.getClass().getName());
        return (JackrabbitAccessControlManager)acm;
    }

    private static LocalRestrictions createLocalRestrictions(List<RestrictionClause> list, JackrabbitAccessControlList jacl, Session s) throws RepositoryException {
        HashMap<String, Value> restrictions = new HashMap<String, Value>();
        HashMap<String, Value[]> mvrestrictions = new HashMap<String, Value[]>();
        if (list != null && !list.isEmpty()) {
            ValueFactory vf = s.getValueFactory();
            for (RestrictionClause rc : list) {
                String restrictionName = rc.getName();
                int type = jacl.getRestrictionType(restrictionName);
                boolean isMvRestriction = jacl.isMultiValueRestriction(restrictionName);
                Value[] values = new Value[rc.getValues().size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = vf.createValue((String)rc.getValues().get(i), type);
                }
                if ("rep:glob".equals(restrictionName) && values.length == 0) {
                    restrictions.put(restrictionName, vf.createValue(""));
                    continue;
                }
                if (isMvRestriction) {
                    mvrestrictions.put(restrictionName, values);
                    continue;
                }
                AclUtil.checkState(values.length == 1, "Expected just one value for single valued restriction with name {0}", restrictionName);
                restrictions.put(restrictionName, values[0]);
            }
        }
        return new LocalRestrictions(restrictions, mvrestrictions);
    }

    public static void setAcl(Session session, List<String> principals, List<String> paths, List<String> privileges, boolean isAllow) throws RepositoryException {
        AclUtil.setAcl(session, principals, paths, privileges, isAllow, Collections.emptyList());
    }

    public static void setAcl(Session session, List<String> principals, List<String> paths, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        for (String jcrPath : AclUtil.getJcrPaths(session, paths)) {
            if (jcrPath != null && !session.nodeExists(jcrPath)) {
                throw new PathNotFoundException("Cannot set ACL on non-existent path " + jcrPath);
            }
            AclUtil.setAcl(session, principals, jcrPath, privileges, isAllow, restrictionClauses);
        }
    }

    private static void setAcl(Session session, List<String> principals, String jcrPath, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        String[] privArray = privileges.toArray(new String[privileges.size()]);
        Privilege[] jcrPriv = AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privArray);
        JackrabbitAccessControlList acl = AclUtil.getAccessControlList(acMgr, jcrPath, true);
        AclUtil.checkState(acl != null, "No JackrabbitAccessControlList available for path {0}", jcrPath);
        LocalRestrictions localRestrictions = AclUtil.createLocalRestrictions(restrictionClauses, acl, session);
        AccessControlEntry[] existingAces = acl.getAccessControlEntries();
        boolean changed = false;
        for (String name : principals) {
            Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)name);
            if (principal == null) {
                Authorizable authorizable = UserUtil.getAuthorizable(session, name);
                AclUtil.checkState(authorizable != null, "Authorizable not found: {0}", name);
                principal = authorizable.getPrincipal();
            }
            AclUtil.checkState(principal != null, PRINCIPAL_NOT_FOUND_PATTERN, name);
            LocalAccessControlEntry newAce = new LocalAccessControlEntry(principal, jcrPriv, isAllow, localRestrictions);
            if (AclUtil.contains(existingAces, newAce)) {
                LOG.info("Not adding {} to path {} since an equivalent access control entry already exists", (Object)newAce, (Object)jcrPath);
                continue;
            }
            acl.addEntry(newAce.principal, newAce.privileges, newAce.isAllow, newAce.restrictions.getRestrictions(), newAce.restrictions.getMVRestrictions());
            changed = true;
        }
        if (changed) {
            acMgr.setPolicy(jcrPath, (AccessControlPolicy)acl);
        }
    }

    public static void setRepositoryAcl(Session session, List<String> principals, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        AclUtil.setAcl(session, principals, (String)null, privileges, isAllow, restrictionClauses);
    }

    public static void removePolicy(@NotNull Session session, @NotNull String principalName) throws RepositoryException {
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
        if (principal == null) {
            LOG.info("Principal {} does not exist.", (Object)principalName);
            principal = new PrincipalImpl(principalName);
        }
        JackrabbitAccessControlManager acMgr = AclUtil.getJACM(session);
        for (JackrabbitAccessControlPolicy policy : acMgr.getPolicies(principal)) {
            if (!(policy instanceof JackrabbitAccessControlList) || policy instanceof PrincipalAccessControlList) continue;
            acMgr.removePolicy(policy.getPath(), (AccessControlPolicy)policy);
        }
    }

    public static void removePolicies(@NotNull Session session, @NotNull List<String> paths) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        for (String jcrPath : AclUtil.getJcrPaths(session, paths)) {
            if (!AclUtil.isValidPath(session, jcrPath)) {
                LOG.info("Cannot remove ACL; no node at {} ", (Object)jcrPath);
                continue;
            }
            LOG.info("Removing access control policy at {}", (Object)jcrPath);
            JackrabbitAccessControlList acl = AclUtil.getAccessControlList(acMgr, jcrPath, false);
            if (acl == null) {
                LOG.info("No ACL to remove at path {}", (Object)jcrPath);
                continue;
            }
            acMgr.removePolicy(jcrPath, (AccessControlPolicy)acl);
        }
    }

    public static void removeEntries(@NotNull Session session, @NotNull List<String> principals, @NotNull List<String> paths) throws RepositoryException {
        HashSet<String> principalNames = new HashSet<String>(principals);
        AccessControlManager acMgr = session.getAccessControlManager();
        for (String jcrPath : AclUtil.getJcrPaths(session, paths)) {
            if (!AclUtil.isValidPath(session, jcrPath)) {
                LOG.info("Cannot remove access control entries on non-existent path {}", (Object)jcrPath);
                continue;
            }
            JackrabbitAccessControlList acl = AclUtil.getAccessControlList(acMgr, jcrPath, false);
            if (acl != null) {
                boolean modified = false;
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    if (!principalNames.contains(ace.getPrincipal().getName())) continue;
                    acl.removeAccessControlEntry(ace);
                    modified = true;
                }
                if (!modified) continue;
                acMgr.setPolicy(jcrPath, (AccessControlPolicy)acl);
                continue;
            }
            LOG.info("Cannot remove access control entries for principal(s) {}. No ACL at {}", principalNames, (Object)jcrPath);
        }
    }

    public static void removeEntries(@NotNull Session session, @NotNull List<String> principals, @NotNull List<String> paths, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        HashSet<String> principalNames = new HashSet<String>(principals);
        AccessControlManager acMgr = session.getAccessControlManager();
        for (String jcrPath : AclUtil.getJcrPaths(session, paths)) {
            if (!AclUtil.isValidPath(session, jcrPath)) {
                LOG.info("Cannot remove access control entries on non-existent path {}", (Object)jcrPath);
                continue;
            }
            JackrabbitAccessControlList acl = AclUtil.getAccessControlList(acMgr, jcrPath, false);
            if (acl != null) {
                boolean modified = false;
                LocalRestrictions restr = AclUtil.createLocalRestrictions(restrictionClauses, acl, session);
                Privilege[] privs = AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privileges.toArray(new String[0]));
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    LocalAccessControlEntry entry;
                    Principal principal = ace.getPrincipal();
                    if (!principalNames.contains(principal.getName()) || !(entry = new LocalAccessControlEntry(ace.getPrincipal(), privs, isAllow, restr)).isEqual(ace)) continue;
                    acl.removeAccessControlEntry(ace);
                    modified = true;
                }
                if (modified) {
                    acMgr.setPolicy(jcrPath, (AccessControlPolicy)acl);
                    continue;
                }
                LOG.info("No matching access control entry found to remove for principals {} at {}. Expected entry with isAllow={}, privileges={}, restrictions={}", new Object[]{principalNames, jcrPath, isAllow, privileges, restrictionClauses});
                continue;
            }
            LOG.info("Cannot remove access control entries for principal(s) {}. No ACL at {}", principalNames, (Object)jcrPath);
        }
    }

    public static void setPrincipalAcl(Session session, String principalName, Collection<AclLine> lines, boolean isStrict) throws RepositoryException {
        PrincipalAccessControlList acl;
        JackrabbitAccessControlManager acMgr = AclUtil.getJACM(session);
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
        if (principal == null) {
            session.save();
            principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
            AclUtil.checkState(principal != null, PRINCIPAL_NOT_FOUND_PATTERN, principalName);
        }
        if ((acl = AclUtil.getPrincipalAccessControlList(acMgr, principal, true)) == null && isStrict) {
            String principalDescription = principal.getName();
            if (principal instanceof ItemBasedPrincipal) {
                principalDescription = principalDescription + " (" + ((ItemBasedPrincipal)principal).getPath() + ")";
            }
            throw new IllegalStateException("No PrincipalAccessControlList available for principal '" + principalDescription + "'.");
        }
        boolean modified = false;
        for (AclLine line : lines) {
            AclLine.Action action = line.getAction();
            List<String> jcrPaths = AclUtil.getJcrPaths(session, line.getProperty("paths"));
            if (action == AclLine.Action.DENY) {
                throw new AccessControlException("PrincipalAccessControlList doesn't support 'deny' entries.");
            }
            if (action == AclLine.Action.REMOVE) {
                throw new IllegalArgumentException(AclLine.Action.REMOVE + " is not supported. Use 'remove principal acl' instead.");
            }
            if (action == AclLine.Action.REMOVE_ALL) {
                if (!AclUtil.removePrincipalEntries(acl, principalName, (PrincipalAccessControlList.Entry entry) -> jcrPaths.contains(entry.getEffectivePath()))) continue;
                modified = true;
                continue;
            }
            if (action == AclLine.Action.ALLOW) {
                Privilege[] privileges = AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])line.getProperty("privileges").toArray(new String[0]));
                for (String effectivePath : jcrPaths) {
                    if (acl == null) {
                        LOG.info("No PrincipalAccessControlList available for principal {}", (Object)principal);
                        if (AclUtil.containsEquivalentEntry(session, effectivePath, principal, privileges, true, line.getRestrictions())) continue;
                        LOG.warn("No equivalent path-based entry exists for principal {} and effective path {} ", (Object)principal.getName(), (Object)effectivePath);
                        return;
                    }
                    LocalRestrictions restrictions = AclUtil.createLocalRestrictions(line.getRestrictions(), (JackrabbitAccessControlList)acl, session);
                    boolean added = acl.addEntry(effectivePath, privileges, restrictions.getRestrictions(), restrictions.getMVRestrictions());
                    if (!added) {
                        LOG.info("Equivalent principal-based entry already exists for principal {} and effective path {} ", (Object)principalName, (Object)effectivePath);
                        continue;
                    }
                    modified = true;
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown action " + action);
        }
        if (modified) {
            acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
    }

    public static void removePrincipalEntries(Session session, String principalName, Collection<AclLine> lines) throws RepositoryException {
        JackrabbitAccessControlManager acMgr = AclUtil.getJACM(session);
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
        if (principal == null) {
            session.save();
            principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
            AclUtil.checkState(principal != null, PRINCIPAL_NOT_FOUND_PATTERN, principalName);
        }
        PrincipalAccessControlList acl = AclUtil.getPrincipalAccessControlList(acMgr, principal, true);
        boolean modified = false;
        for (AclLine line : lines) {
            List<String> jcrPaths = AclUtil.getJcrPaths(session, line.getProperty("paths"));
            LocalRestrictions restr = AclUtil.createLocalRestrictions(line.getRestrictions(), (JackrabbitAccessControlList)acl, session);
            List privNames = line.getProperty("privileges");
            Privilege[] privs = AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privNames.toArray(new String[0]));
            Predicate<PrincipalAccessControlList.Entry> predicate = entry -> {
                if (!jcrPaths.contains(entry.getEffectivePath())) {
                    return false;
                }
                LocalAccessControlEntry lace = new LocalAccessControlEntry(entry.getPrincipal(), privs, line.getAction() == AclLine.Action.ALLOW, restr);
                return lace.isEqual((AccessControlEntry)entry);
            };
            if (AclUtil.removePrincipalEntries(acl, principalName, predicate)) {
                modified = true;
                continue;
            }
            LOG.info("No matching access control entry found to remove for principal {} at {}. Expected entry with isAllow={}, privileges={}, restrictions={}", new Object[]{principalName, jcrPaths, line.getAction(), privNames, line.getRestrictions()});
        }
        if (modified) {
            acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
    }

    public static void removePrincipalPolicy(@NotNull Session session, @NotNull String principalName) throws RepositoryException {
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)principalName);
        if (principal == null) {
            LOG.info("Cannot remove principal-based ACL. Principal {} does not exist.", (Object)principalName);
            return;
        }
        JackrabbitAccessControlManager acMgr = AclUtil.getJACM(session);
        PrincipalAccessControlList acl = AclUtil.getPrincipalAccessControlList(acMgr, principal, false);
        if (acl == null) {
            LOG.info("Cannot remove principal-based ACL for principal {}. No such policy exists.", (Object)principalName);
        } else {
            acMgr.removePolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
    }

    private static boolean isValidPath(@NotNull Session session, @Nullable String jcrPath) throws RepositoryException {
        return jcrPath == null || session.nodeExists(jcrPath);
    }

    @Nullable
    private static JackrabbitAccessControlList getAccessControlList(@NotNull AccessControlManager acMgr, @Nullable String path, boolean includeApplicable) throws RepositoryException {
        if (includeApplicable) {
            return AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
        }
        for (AccessControlPolicy policy : acMgr.getPolicies(path)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        return null;
    }

    @Nullable
    private static PrincipalAccessControlList getPrincipalAccessControlList(@NotNull JackrabbitAccessControlManager acMgr, @NotNull Principal principal, boolean includeApplicable) throws RepositoryException {
        PrincipalAccessControlList acl = null;
        for (JackrabbitAccessControlPolicy policy : acMgr.getPolicies(principal)) {
            if (!(policy instanceof PrincipalAccessControlList)) continue;
            acl = (PrincipalAccessControlList)policy;
            break;
        }
        if (acl == null && includeApplicable) {
            for (JackrabbitAccessControlPolicy policy : acMgr.getApplicablePolicies(principal)) {
                if (!(policy instanceof PrincipalAccessControlList)) continue;
                acl = (PrincipalAccessControlList)policy;
                break;
            }
        }
        return acl;
    }

    private static boolean removePrincipalEntries(@Nullable PrincipalAccessControlList acl, @NotNull String principalName, @NotNull Predicate<PrincipalAccessControlList.Entry> predicate) throws RepositoryException {
        boolean modified = false;
        if (acl == null) {
            LOG.info("Cannot remove entries. No principal-based ACL for {}", (Object)principalName);
        } else {
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                PrincipalAccessControlList.Entry entry;
                if (!(ace instanceof PrincipalAccessControlList.Entry) || !predicate.test(entry = (PrincipalAccessControlList.Entry)ace)) continue;
                acl.removeAccessControlEntry(ace);
                modified = true;
            }
        }
        return modified;
    }

    @NotNull
    private static List<String> getJcrPaths(@NotNull Session session, @NotNull List<String> paths) throws RepositoryException {
        ArrayList<String> jcrPaths = new ArrayList<String>(paths.size());
        for (String path : paths) {
            if (":repository".equals(path) || path == null || path.isEmpty()) {
                jcrPaths.add(null);
                continue;
            }
            if (path.startsWith(":home:")) {
                int lastHashIndex = path.lastIndexOf(35);
                AclUtil.checkState(lastHashIndex > -1, "Invalid format of home path: # deliminator expected.", new Object[0]);
                String subTreePath = path.substring(lastHashIndex + 1);
                for (String aPath : AclUtil.getAuthorizablePaths(session, path.substring(":home:".length(), lastHashIndex))) {
                    jcrPaths.add(aPath + subTreePath);
                }
                continue;
            }
            jcrPaths.add(path);
        }
        return jcrPaths;
    }

    @NotNull
    private static Iterable<String> getAuthorizablePaths(@NotNull Session session, @NotNull String ids) throws RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        for (String id : Text.explode((String)ids, (int)44)) {
            Authorizable a = UserUtil.getAuthorizable(session, id);
            if (a == null) {
                throw new PathNotFoundException("Cannot resolve path of user/group with id '" + id + "'.");
            }
            paths.add(a.getPath());
        }
        return paths;
    }

    private static boolean containsEquivalentEntry(Session session, String absPath, Principal principal, Privilege[] privileges, boolean isAllow, List<RestrictionClause> restrictionList) throws RepositoryException {
        if (absPath != null && !session.nodeExists(absPath)) {
            LOG.info("Cannot determine existence of equivalent path-based entry for principal {}. No node at path {} ", (Object)principal.getName(), (Object)absPath);
            return true;
        }
        for (AccessControlPolicy policy : session.getAccessControlManager().getPolicies(absPath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            LocalRestrictions lr = AclUtil.createLocalRestrictions(restrictionList, (JackrabbitAccessControlList)policy, session);
            LocalAccessControlEntry newEntry = new LocalAccessControlEntry(principal, privileges, isAllow, lr);
            if (!AclUtil.contains(((JackrabbitAccessControlList)policy).getAccessControlEntries(), newEntry)) continue;
            LOG.info("Equivalent path-based entry exists for principal {} and effective path {} ", (Object)newEntry.principal.getName(), (Object)absPath);
            return true;
        }
        return false;
    }

    static boolean contains(AccessControlEntry[] existingAces, LocalAccessControlEntry newAce) throws RepositoryException {
        for (int i = 0; i < existingAces.length; ++i) {
            JackrabbitAccessControlEntry existingEntry = (JackrabbitAccessControlEntry)existingAces[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Comparing {} with {}", (Object)newAce, (Object)AclUtil.toString(existingEntry));
            }
            if (!newAce.isContainedIn(existingEntry)) continue;
            return true;
        }
        return false;
    }

    private static String toString(JackrabbitAccessControlEntry entry) throws RepositoryException {
        return "[" + entry.getClass().getSimpleName() + "# principal: " + entry.getPrincipal() + ", privileges: " + Arrays.toString(entry.getPrivileges()) + ", isAllow: " + entry.isAllow() + ", restrictionNames: " + entry.getRestrictionNames() + "]";
    }

    private static void checkState(boolean expression, String msgPattern, Object ... args) {
        if (!expression) {
            if (args != null) {
                throw new IllegalStateException(msgPattern);
            }
            throw new IllegalStateException(MessageFormat.format(msgPattern, args));
        }
    }

    static boolean compareValues(Value[] a, Value[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        HashSet<Value> first = new HashSet<Value>(Arrays.asList(a));
        HashSet<Value> second = new HashSet<Value>(Arrays.asList(b));
        return first.equals(second);
    }

    private static class LocalRestrictions {
        private Map<String, Value> restrictions;
        private Map<String, Value[]> mvRestrictions;

        public LocalRestrictions() {
            this.restrictions = new HashMap<String, Value>();
            this.mvRestrictions = new HashMap<String, Value[]>();
        }

        public LocalRestrictions(Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) {
            this.restrictions = restrictions != null ? restrictions : new HashMap();
            this.mvRestrictions = mvRestrictions != null ? mvRestrictions : new HashMap();
        }

        public Map<String, Value> getRestrictions() {
            return this.restrictions;
        }

        public Map<String, Value[]> getMVRestrictions() {
            return this.mvRestrictions;
        }

        public int size() {
            return this.restrictions.size() + this.mvRestrictions.size();
        }
    }

    static class LocalAccessControlEntry {
        private final Principal principal;
        private final Privilege[] privileges;
        private final boolean isAllow;
        private final LocalRestrictions restrictions;

        LocalAccessControlEntry(Principal principal, Privilege[] privileges, boolean isAllow) {
            this(principal, privileges, isAllow, null);
        }

        LocalAccessControlEntry(Principal principal, Privilege[] privileges, boolean isAllow, LocalRestrictions restrictions) {
            this.principal = principal;
            this.privileges = privileges;
            this.isAllow = isAllow;
            this.restrictions = restrictions != null ? restrictions : new LocalRestrictions();
        }

        public boolean isContainedIn(JackrabbitAccessControlEntry other) throws RepositoryException {
            return other.getPrincipal().equals(this.principal) && this.contains(other.getPrivileges(), this.privileges) && other.isAllow() == this.isAllow && this.sameRestrictions(other);
        }

        public boolean isEqual(AccessControlEntry other) {
            if (!(other instanceof JackrabbitAccessControlEntry)) {
                return false;
            }
            try {
                JackrabbitAccessControlEntry otherAce = (JackrabbitAccessControlEntry)other;
                return other.getPrincipal().equals(this.principal) && this.equalPrivileges(other.getPrivileges(), this.privileges) && otherAce.isAllow() == this.isAllow && this.sameRestrictions(otherAce);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Cannot verify equivalence of access control entries", e);
            }
        }

        private Set<Privilege> expandPrivileges(Privilege[] privileges) {
            HashSet<Privilege> expandedSet = new HashSet<Privilege>();
            if (privileges != null) {
                for (Privilege privilege : privileges) {
                    if (privilege.isAggregate()) {
                        expandedSet.addAll(Arrays.asList(privilege.getAggregatePrivileges()));
                        continue;
                    }
                    expandedSet.add(privilege);
                }
            }
            return expandedSet;
        }

        private boolean sameRestrictions(JackrabbitAccessControlEntry jace) throws RepositoryException {
            if (jace.getRestrictionNames().length == this.restrictions.size()) {
                for (String rn : jace.getRestrictionNames()) {
                    Value[] newValues;
                    Value[] valueArray;
                    Value[] oldValues = jace.getRestrictions(rn);
                    if (this.restrictions.getRestrictions().get(rn) != null) {
                        Value[] valueArray2 = new Value[1];
                        valueArray = valueArray2;
                        valueArray2[0] = this.restrictions.getRestrictions().get(rn);
                    } else {
                        valueArray = newValues = this.restrictions.getMVRestrictions().get(rn);
                    }
                    if ((newValues == null || newValues.length == 0) && (oldValues == null || oldValues.length == 0) || AclUtil.compareValues(newValues, oldValues)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean contains(Privilege[] first, Privilege[] second) {
            Set<Privilege> set1 = this.expandPrivileges(first);
            Set<Privilege> set2 = this.expandPrivileges(second);
            return set1.containsAll(set2);
        }

        private boolean equalPrivileges(Privilege[] first, Privilege[] second) {
            Set<Privilege> set1 = this.expandPrivileges(first);
            Set<Privilege> set2 = this.expandPrivileges(second);
            return set1.equals(set2);
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + "# principal " + this.principal + ", privileges: " + Arrays.toString(this.privileges) + ", isAllow : " + this.isAllow + "]";
        }
    }
}

