/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceListener
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final String workspaceName;
    private final Session session;
    private final String startPath;
    private final String mountPrefix;
    private final ResourceResolver resolver;
    private final ServiceTracker eventAdminTracker;

    public JcrResourceListener(String workspaceName, ResourceResolverFactory factory, String startPath, String mountPrefix, ServiceTracker eventAdminTracker) throws LoginException, RepositoryException {
        this.workspaceName = workspaceName;
        HashMap<String, String> authInfo = new HashMap<String, String>();
        if (workspaceName != null) {
            authInfo.put("user.jcr.workspace", workspaceName);
        }
        this.resolver = factory.getAdministrativeResourceResolver(authInfo);
        this.session = (Session)this.resolver.adaptTo(Session.class);
        this.startPath = startPath;
        this.eventAdminTracker = eventAdminTracker;
        this.mountPrefix = mountPrefix.equals("/") ? null : mountPrefix;
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.startPath, true, null, null, false);
    }

    public void dispose() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
        this.resolver.close();
    }

    public void onEvent(EventIterator events) {
        EventAdmin localEA = (EventAdmin)this.eventAdminTracker.getService();
        if (localEA == null) {
            return;
        }
        HashMap addedEvents = new HashMap();
        HashMap<String, Event> changedEvents = new HashMap<String, Event>();
        HashMap removedEvents = new HashMap();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                HashMap<String, Event> map = null;
                String nodePath = event.getPath();
                if (event.getType() == 4 || event.getType() == 8 || event.getType() == 16) {
                    int lastSlash = nodePath.lastIndexOf(47);
                    nodePath = nodePath.substring(0, lastSlash);
                    map = changedEvents;
                } else if (event.getType() == 1) {
                    map = addedEvents;
                } else if (event.getType() == 2) {
                    map = removedEvents;
                }
                if (map == null) continue;
                if (this.mountPrefix != null) {
                    map.put(this.mountPrefix + nodePath, event);
                    continue;
                }
                map.put(nodePath, event);
            }
            catch (RepositoryException e) {
                this.logger.error("Error during modificatiozasn: {}", (Object)e.getMessage());
            }
        }
        for (Map.Entry e : removedEvents.entrySet()) {
            addedEvents.remove(e.getKey());
            changedEvents.remove(e.getKey());
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("path", this.createWorkspacePath((String)e.getKey()));
            ((Dictionary)properties).put("userid", ((Event)e.getValue()).getUserID());
            localEA.postEvent(new org.osgi.service.event.Event("org/apache/sling/api/resource/Resource/REMOVED", properties));
        }
        for (Map.Entry e : addedEvents.entrySet()) {
            changedEvents.remove(e.getKey());
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/ADDED", localEA);
        }
        for (Map.Entry e : changedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/CHANGED", localEA);
        }
    }

    private void sendOsgiEvent(String path, Event event, String topic, EventAdmin localEA) {
        Resource resource = this.resolver.getResource(path = this.createWorkspacePath(path));
        if (resource != null) {
            String resourceSuperType;
            Node node;
            if (path.endsWith("/jcr:content") && (node = (Node)resource.adaptTo(Node.class)) != null) {
                try {
                    Resource parentResource;
                    if (node.getParent().isNodeType("nt:file") && (parentResource = ResourceUtil.getParent((Resource)resource)) != null) {
                        resource = parentResource;
                    }
                }
                catch (RepositoryException re) {
                    // empty catch block
                }
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("path", resource.getPath());
            ((Dictionary)properties).put("userid", event.getUserID());
            String resourceType = resource.getResourceType();
            if (resourceType != null) {
                ((Dictionary)properties).put("resourceType", resource.getResourceType());
            }
            if ((resourceSuperType = resource.getResourceSuperType()) != null) {
                ((Dictionary)properties).put("resourceSuperType", resource.getResourceSuperType());
            }
            localEA.postEvent(new org.osgi.service.event.Event(topic, properties));
        }
    }

    private String createWorkspacePath(String path) {
        if (this.workspaceName == null) {
            return path;
        }
        return this.workspaceName + ":" + path;
    }
}

